/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees.vanilla;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenHugeMushrooms;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenPredicate;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Random;
import java.util.function.BiFunction;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpeciesDarkOak
extends Species {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 1;

    public SpeciesDarkOak(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesforestry", "darkoak"), treeFamily, ModContent.darkOakLeavesProperties);
        ModContent.darkOakLeavesProperties.setTree(treeFamily);
        this.setBasicGrowingParameters(0.6f, 10.0f, 4, 4, 0.8f);
        this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"darkoak"));
        this.setSoilLongevity(14);
        this.setRequiresTileEntity(true);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
        this.envFactor(BiomeDictionary.Type.MUSHROOM, 1.25f);
        this.generateSeed();
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
        this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
        this.addGenFeature((IGenFeature)new FeatureGenMound(5));
        this.addGenFeature((IGenFeature)new FeatureGenPredicate((IPostGenFeature)new FeatureGenHugeMushrooms().setMaxShrooms(1).setMaxAttempts(3)).setBiomePredicate(biome -> biome == Biomes.field_150585_R));
        this.addGenFeature((IGenFeature)new FeatureGenRoots(13).setScaler(this.getRootScaler()));
    }

    protected BiFunction<Integer, Integer, Integer> getRootScaler() {
        return (inRadius, trunkRadius) -> {
            float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
            return (int)((float)inRadius.intValue() * scale);
        };
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesDarkOak.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{Biomes.field_150585_R});
    }

    public int getLowestBranchHeight(World world, BlockPos pos) {
        return (int)((float)super.getLowestBranchHeight(world, pos) * this.biomeSuitability(world, pos));
    }

    public float getEnergy(World world, BlockPos pos) {
        return super.getEnergy(world, pos) * this.biomeSuitability(world, pos);
    }

    public float getGrowthRate(World world, BlockPos pos) {
        return super.getGrowthRate(world, pos) * this.biomeSuitability(world, pos);
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 2 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 6) {
                world.func_175656_a(pos, ModBlocks.blockStates.redMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }

    public boolean isThick() {
        return true;
    }
}

