/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees.vanilla;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Random;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpeciesBirch
extends Species {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 2;

    public SpeciesBirch(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesforestry", "birch"), treeFamily, ModContent.birchLeavesProperties);
        ModContent.birchLeavesProperties.setTree(treeFamily);
        this.setBasicGrowingParameters(0.1f, 14.0f, 4, 4, 1.25f);
        this.setRequiresTileEntity(true);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.generateSeed();
        this.setupStandardSeedDropping();
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesBirch.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{Biomes.field_150583_P, Biomes.field_150582_Q});
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, Blocks.field_150338_P.func_176223_P());
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
            }
            return true;
        }
        return false;
    }
}

