/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeWillow
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.1"));
    public static int leavesMeta = 14;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.3"));
    public static int logMeta = 0;
    public static BlockDynamicLeaves willowLeaves;
    public static int leavesHeight;
    public static int leavesHeightChance;

    public TreeWillow() {
        super(new ResourceLocation("dynamictreesforestry", "willow"));
        willowLeaves = new BlockDynamicLeaves(){

            public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean unknown) {
            }

            public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != state.func_177230_c() || (Integer)world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)HYDRO) != 1) {
                    super.func_180650_b(world, pos, state, rand);
                }
                if ((Integer)state.func_177229_b((IProperty)HYDRO) == 1 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150350_a && rand.nextInt(leavesHeightChance) == 0 && world.func_180495_p(pos.func_177981_b(leavesHeight)).func_177230_c() != state.func_177230_c()) {
                    world.func_175656_a(pos.func_177977_b(), state);
                }
            }

            public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
                if (entityIn.field_70181_x > 0.0 && entityIn.field_70181_x < 0.25) {
                    entityIn.field_70181_x += 0.025;
                }
                entityIn.func_70031_b(false);
                entityIn.field_70159_w *= 0.4;
                entityIn.field_70179_y *= 0.4;
            }
        };
        willowLeaves.setRegistryName("leaves_willow");
        ModContent.willowLeavesProperties.setTree((TreeFamily)this);
        ModContent.willowLeavesProperties.setDynamicLeavesState(willowLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        willowLeaves.setProperties(0, ModContent.willowLeavesProperties);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 10132315;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)willowLeaves);
        return super.getRegisterableBlocks(blockList);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesWillow(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.WILLOW.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    static {
        leavesHeight = 5;
        leavesHeightChance = 4;
    }

    public class SpeciesWillow
    extends Species {
        SpeciesWillow(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.willowLeavesProperties);
            this.setBasicGrowingParameters(0.6f, 10.0f, 1, 4, 1.0f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(16).setMaxLength(16));
        }
    }
}

