/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockBranchThickForestry;
import maxhyper.dynamictreesforestry.genfeatures.FeatureGenFruitLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeWalnut
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 4;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.3"));
    public static int logMeta = 1;
    public static float fruitingOffset = 0.5f;

    public TreeWalnut() {
        super(new ResourceLocation("dynamictreesforestry", "walnut"));
        ModContent.walnutLeavesProperties.setTree((TreeFamily)this);
        ModContent.fruitWalnutLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 6838610;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesWalnut(this));
    }

    public boolean isThick() {
        return true;
    }

    public BlockBranch createBranch() {
        return new BlockBranchThickForestry(this.getName() + "branch", EnumForestryWoodType.WALNUT);
    }

    public class SpeciesWalnut
    extends Species {
        SpeciesWalnut(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.walnutLeavesProperties);
            this.setBasicGrowingParameters(0.6f, 12.0f, 1, 4, 0.9f);
            this.generateSeed();
            this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
            ModContent.walnutLeaves.setSpecies(this);
            this.addGenFeature((IGenFeature)new FeatureGenFruitLeaves(10, 16, ModContent.walnutLeavesProperties.getDynamicLeavesState(), ModContent.fruitWalnutLeavesProperties.getDynamicLeavesState(), 0.5f));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            ModContent.walnutFruit.setSpecies((Species)this);
            this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.walnutFruit).setRayDistance(4.0f));
        }

        public float seasonalFruitProductionFactor(World world, BlockPos pos) {
            float offset = fruitingOffset;
            return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
        }

        public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
            return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
        }

        public int maxBranchRadius() {
            return 15;
        }

        public boolean isThick() {
            return true;
        }
    }
}

