/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockBranchThickForestry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeSilverLime
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 3;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.0"));
    public static int logMeta = 3;

    public TreeSilverLime() {
        super(new ResourceLocation("dynamictreesforestry", "silverlime"));
        ModContent.silverLimeLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 10124117;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesSilverLime(this));
    }

    public boolean isThick() {
        return true;
    }

    public BlockBranch createBranch() {
        return new BlockBranchThickForestry(this.getName() + "branch", EnumForestryWoodType.LIME);
    }

    public class SpeciesSilverLime
    extends Species {
        SpeciesSilverLime(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.silverLimeLeavesProperties);
            this.setBasicGrowingParameters(0.8f, 8.0f, 1, 3, 1.2f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public int maxBranchRadius() {
            return 12;
        }

        public boolean isThick() {
            return true;
        }
    }
}

