/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreePoplar
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.2"));
    public static int leavesMeta = 2;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.4"));
    public static int logMeta = 1;

    public TreePoplar() {
        super(new ResourceLocation("dynamictreesforestry", "poplar"));
        ModContent.poplarLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 10594124;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPoplar(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.POPLAR.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    public class SpeciesPoplar
    extends Species {
        SpeciesPoplar(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.poplarLeavesProperties);
            this.setBasicGrowingParameters(0.1f, 18.0f, 30, 2, 1.1f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            if (signal.numTurns > 0) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    probMap[dir.func_176745_a()] = 0;
                }
                probMap[EnumFacing.UP.func_176745_a()] = 0;
            }
            probMap[signal.dir.func_176734_d().func_176745_a()] = 0;
            return probMap;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 4);
        }
    }
}

