/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.genfeatures.FeatureGenFruitLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreePlum
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 8;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.5"));
    public static int logMeta = 1;
    public static float fruitingOffset = 0.0f;

    public TreePlum() {
        super(new ResourceLocation("dynamictreesforestry", "plum"));
        ModContent.plumLeavesProperties.setTree((TreeFamily)this);
        ModContent.fruitPlumLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 9984356;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPlum(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.PLUM.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    public class SpeciesPlum
    extends Species {
        SpeciesPlum(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.plumLeavesProperties);
            this.setBasicGrowingParameters(0.6f, 6.0f, 1, 3, 1.2f);
            this.generateSeed();
            this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
            ModContent.plumLeaves.setSpecies(this);
            this.addGenFeature((IGenFeature)new FeatureGenFruitLeaves(6, 8, ModContent.plumLeavesProperties.getDynamicLeavesState(), ModContent.fruitPlumLeavesProperties.getDynamicLeavesState(), 0.5f));
            ModContent.plumFruit.setSpecies((Species)this);
            this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.plumFruit).setRayDistance(2.0f).setFruitingRadius(3));
        }

        public float seasonalFruitProductionFactor(World world, BlockPos pos) {
            float offset = fruitingOffset;
            return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
        }

        public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
            return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
        }
    }
}

