/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockDynamicLeavesPalm;
import maxhyper.dynamictreesforestry.genfeatures.FeatureGenFruitPod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreePalm
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.2"));
    public static int leavesMeta = 1;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.4"));
    public static int logMeta = 2;
    public static float fruitingOffset = 1.5f;

    public TreePalm() {
        super(new ResourceLocation("dynamictreesforestry", "palm"));
        ModContent.palmLeavesProperties.setTree((TreeFamily)this);
        this.canSupportCocoa = true;
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 9197100;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPalm(this));
    }

    public float getPrimaryThickness() {
        return 3.0f;
    }

    public float getSecondaryThickness() {
        return 3.0f;
    }

    public HashMap<BlockPos, IBlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        if (destructionData.getNumEndpoints() < 1) {
            return null;
        }
        HashMap<BlockPos, IBlockState> leaves = new HashMap<BlockPos, IBlockState>();
        BlockPos relPos = destructionData.getEndPointRelPos(0).func_177984_a();
        ILeavesProperties leavesProperties = this.getCommonSpecies().getLeavesProperties();
        leaves.put(relPos, leavesProperties.getDynamicLeavesState(4));
        leaves.put(relPos.func_177984_a(), leavesProperties.getDynamicLeavesState(3));
        for (int hydro = 1; hydro <= 2; ++hydro) {
            IExtendedBlockState extState = (IExtendedBlockState)leavesProperties.getDynamicLeavesState(hydro);
            for (CoordUtils.Surround surr : BlockDynamicLeavesPalm.hydroSurroundMap[hydro]) {
                leaves.put(relPos.func_177971_a(surr.getOpposite().getOffset()), (IBlockState)extState.withProperty(BlockDynamicLeavesPalm.CONNECTIONS[surr.ordinal()], (Object)true));
            }
        }
        return leaves;
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.PALM.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    public class SpeciesPalm
    extends Species {
        SpeciesPalm(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.palmLeavesProperties);
            this.setBasicGrowingParameters(0.5f, 10.0f, 4, 3, 0.8f);
            this.generateSeed();
            this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
            ModContent.dateFruit.setSpecies(this);
            this.addGenFeature((IGenFeature)new FeatureGenFruitPod(ModContent.dateFruit, 1));
            this.addDropCreator((IDropCreator)new DropCreatorSeed(3.0f){

                public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                    if (random.nextInt(16) == 0) {
                        dropList.add(this.getFruit());
                    }
                    return dropList;
                }

                private ItemStack getFruit() {
                    return new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, 5);
                }

                public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                    int chance = 16;
                    if (fortune > 0 && (chance -= fortune) < 3) {
                        chance = 3;
                    }
                    if (random.nextInt(chance) == 0) {
                        dropList.add(this.getFruit());
                    }
                    return dropList;
                }
            });
        }

        public float seasonalFruitProductionFactor(World world, BlockPos pos) {
            float offset = fruitingOffset;
            return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
        }

        public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
            return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
        }

        public int getSeasonalTooltipFlags(int dimension) {
            return 12;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = 10;
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
            probMap[originDir.ordinal()] = 0;
            return probMap;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 3);
        }

        public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean natural) {
            IBlockState trunkBlockState = world.func_180495_p(treePos);
            BlockBranch branch = TreeHelper.getBranch((IBlockState)trunkBlockState);
            NodeFindEnds endFinder = new NodeFindEnds();
            MapSignal signal = new MapSignal(new INodeInspector[]{endFinder});
            branch.analyse(trunkBlockState, world, treePos, EnumFacing.DOWN, signal);
            List endPoints = endFinder.getEnds();
            for (BlockPos endPoint : endPoints) {
                TreeHelper.ageVolume((World)world, (BlockPos)endPoint, (int)2, (int)3, (int)3, (SafeChunkBounds)SafeChunkBounds.ANY);
            }
            int radius = branch.getRadius(world.func_180495_p(treePos.func_177984_a()));
            if (radius != 0) {
                branch.setRadius(world, treePos, radius + 1, null);
            }
            return super.postGrow(world, rootPos, treePos, soilLife, natural);
        }

        public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
            for (BlockPos endPoint : endPoints) {
                TreeHelper.ageVolume((World)world, (BlockPos)endPoint, (int)1, (int)2, (int)3, (SafeChunkBounds)safeBounds);
            }
            super.postGeneration(world, rootPos, biome, radius, endPoints, safeBounds, initialDirtState);
        }

        public boolean transitionToTree(World world, BlockPos pos) {
            TreeFamily family = this.getFamily();
            if (world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
                family.getDynamicBranch().setRadius(world, pos, (int)family.getPrimaryThickness(), null);
                world.func_175656_a(pos.func_177984_a(), this.getLeavesProperties().getDynamicLeavesState());
                world.func_175656_a(pos.func_177981_b(2), this.getLeavesProperties().getDynamicLeavesState().func_177226_a((IProperty)BlockDynamicLeaves.HYDRO, (Comparable)Integer.valueOf(3)));
                this.placeRootyDirtBlock(world, pos.func_177977_b(), 15);
                return true;
            }
            return false;
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"sandlike"}))) {
                return ModBlocks.blockRootySand;
            }
            return ModBlocks.blockRootyDirt;
        }
    }
}

