/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreePadauk
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.1"));
    public static int leavesMeta = 8;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.6"));
    public static int logMeta = 2;
    BlockSurfaceRoot surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");

    public TreePadauk() {
        super(new ResourceLocation("dynamictreesforestry", "padauk"));
        ModContent.padaukLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 11695675;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPadauk(this));
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.PADAUK.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    public class SpeciesPadauk
    extends Species {
        SpeciesPadauk(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.padaukLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 19.0f, 4, 13, 1.0f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"darkoak"));
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenRoots(7).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 7 ? (float)trunkRadius.intValue() / 12.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }
    }
}

