/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockBranchThickForestry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeMeranti
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.1"));
    public static int leavesMeta = 5;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.2"));
    public static int logMeta = 2;
    BlockSurfaceRoot surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");

    public TreeMeranti() {
        super(new ResourceLocation("dynamictreesforestry", "meranti"));
        ModContent.merantiLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 9264721;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMeranti(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public boolean isThick() {
        return true;
    }

    public BlockBranch createBranch() {
        return new BlockBranchThickForestry(this.getName() + "branch", EnumForestryWoodType.MAHOGANY);
    }

    public class SpeciesMeranti
    extends Species {
        SpeciesMeranti(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.merantiLeavesProperties);
            this.setBasicGrowingParameters(0.5f, 18.0f, 30, 12, 0.9f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"darkoak"));
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenMound(5));
            this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(16).setMaxLength(16));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(14).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 14 ? (float)trunkRadius.intValue() / 20.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public int maxBranchRadius() {
            return 14;
        }

        public boolean isThick() {
            return true;
        }
    }
}

