/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockBranchThickForestry;
import maxhyper.dynamictreesforestry.items.ItemDynamicSeedKapok;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeKapok
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.1"));
    public static int leavesMeta = 2;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.2"));
    public static int logMeta = 0;
    BlockSurfaceRoot surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");

    public TreeKapok() {
        super(new ResourceLocation("dynamictreesforestry", "kapok"));
        ModContent.kapokLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 6844208;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesKapok(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public boolean isThick() {
        return true;
    }

    public BlockBranch createBranch() {
        return new BlockBranchThickForestry(this.getName() + "branch", EnumForestryWoodType.KAPOK);
    }

    public class SpeciesKapok
    extends Species {
        SpeciesKapok(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.kapokLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 27.0f, 30, 16, 0.9f);
            this.setSeedStack(new ItemStack((Item)new ItemDynamicSeedKapok()));
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenVine());
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenMound(5));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(8).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 8 ? (float)trunkRadius.intValue() / 18.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            probMap[EnumFacing.DOWN.func_176745_a()] = 0;
            if (!signal.isInTrunk()) {
                probMap[EnumFacing.UP.func_176745_a()] = 1;
                if (signal.rand.nextInt(2) == 0) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        probMap[dir.func_176745_a()] = 1;
                    }
                }
            }
            probMap[signal.dir.func_176734_d().func_176745_a()] = 0;
            return probMap;
        }

        public int maxBranchRadius() {
            return 10;
        }

        public boolean isThick() {
            return true;
        }
    }
}

