/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeCocobolo
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.1"));
    public static int leavesMeta = 10;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.6"));
    public static int logMeta = 3;

    public TreeCocobolo() {
        super(new ResourceLocation("dynamictreesforestry", "cocobolo"));
        ModContent.cocoboloLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 5774606;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesCocobolo(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.COCOBOLO.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    public class SpeciesCocobolo
    extends Species {
        SpeciesCocobolo(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.cocoboloLeavesProperties);
            this.setBasicGrowingParameters(0.05f, 18.0f, 30, 8, 1.0f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            int signalHeight = pos.func_177956_o() - signal.rootPos.func_177956_o();
            if (signalHeight % 2 != 0) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    probMap[dir.func_176745_a()] = 0;
                }
            } else {
                probMap[EnumFacing.UP.func_176745_a()] = 30;
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    probMap[dir.func_176745_a()] = 1;
                }
            }
            if (!signal.isInTrunk()) {
                probMap[EnumFacing.DOWN.func_176745_a()] = 0;
                probMap[EnumFacing.UP.func_176745_a()] = 0;
            }
            probMap[signal.dir.func_176734_d().func_176745_a()] = 0;
            return probMap;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 4);
        }
    }
}

