/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockBranchThickForestry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeCoastSequoia
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 13;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.1"));
    public static int logMeta = 3;
    BlockSurfaceRoot surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");

    public TreeCoastSequoia() {
        super(new ResourceLocation("dynamictreesforestry", "coastsequoia"));
        ModContent.coastSequoiaLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 8272420;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPadauk(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        blockList.add((Block)((BlockBranchThick)this.getDynamicBranch()).getPairSide(true));
        return super.getRegisterableBlocks(blockList);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public BlockBranch createBranch() {
        String branchName = this.getName() + "branch";
        return new BlockBranchSequoia(branchName, EnumForestryWoodType.SEQUOIA);
    }

    protected class BlockBranchSequoia
    extends BlockBranchThickForestry {
        public BlockBranchSequoia(String name, EnumForestryWoodType type) {
            this(Material.field_151575_d, name, type);
        }

        public BlockBranchSequoia(Material material, String name, EnumForestryWoodType type) {
            super(material, name, type);
            this.otherBlock = new BlockBranchSequoia(material, name + "x", true, type);
            this.otherBlock.otherBlock = this;
            this.woodType = type;
            this.cacheBranchThickStates();
        }

        protected BlockBranchSequoia(Material material, String name, boolean extended, EnumForestryWoodType type) {
            super(material, name, extended, type);
            this.woodType = type;
        }

        @Override
        public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
            int radius = this.getRadius(blockState);
            return EnumForestryWoodType.GIGANTEUM.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
        }

        protected int getMaxSignalDepth() {
            return 64;
        }
    }

    public class SpeciesPadauk
    extends Species {
        SpeciesPadauk(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.coastSequoiaLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 45.0f, 20, 25, 2.1f);
            this.setSoilLongevity(80);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(50));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenMound(5));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(7).setScaler(this.getRootScaler()).setLevelLimit(8));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 7 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public int maxBranchRadius() {
            return 24;
        }

        public boolean isThick() {
            return true;
        }

        public int getWorldGenLeafMapHeight() {
            return 64;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            probMap[signal.dir.func_176734_d().func_176745_a()] = 0;
            return probMap;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 4);
        }
    }
}

