/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.genfeatures.FeatureGenFruitLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TreeCherry
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 6;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.3"));
    public static int logMeta = 3;
    public static float fruitingOffset = 0.0f;

    public TreeCherry() {
        super(new ResourceLocation("dynamictreesforestry", "cherry"));
        ModContent.cherryLeavesProperties.setTree((TreeFamily)this);
        ModContent.fruitCherryLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 11106353;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesCherry(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
                int radius = this.getRadius(blockState);
                return EnumForestryWoodType.CHERRY.getHardness() * (float)(radius * radius) / 64.0f * 8.0f;
            }
        };
    }

    public class SpeciesCherry
    extends Species {
        SpeciesCherry(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.cherryLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 10.0f, 1, 4, 1.0f);
            this.generateSeed();
            this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
            ModContent.cherryLeaves.setSpecies(this);
            this.addGenFeature((IGenFeature)new FeatureGenFruitLeaves(8, 12, ModContent.cherryLeavesProperties.getDynamicLeavesState(), ModContent.fruitCherryLeavesProperties.getDynamicLeavesState(), 0.5f));
            ModContent.cherryFruit.setSpecies((Species)this);
            this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.cherryFruit).setRayDistance(4.0f));
        }

        public float seasonalFruitProductionFactor(World world, BlockPos pos) {
            float offset = fruitingOffset;
            return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
        }

        public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
            return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
        }
    }
}

