/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import forestry.api.arboriculture.EnumForestryWoodType;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockBranchThickForestry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeBaobab
extends TreeFamily {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.1"));
    public static int leavesMeta = 12;
    public static Block logBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "logs.1"));
    public static int logMeta = 2;

    public TreeBaobab() {
        super(new ResourceLocation("dynamictreesforestry", "baobab"));
        ModContent.baobabLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 9344602;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesBaobab(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public boolean isThick() {
        return true;
    }

    public BlockBranch createBranch() {
        return new BlockBranchThickForestry(this.getName() + "branch", EnumForestryWoodType.BAOBAB);
    }

    public class SpeciesBaobab
    extends Species {
        SpeciesBaobab(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.baobabLeavesProperties);
            this.setBasicGrowingParameters(1.5f, 30.0f, 20, 20, 0.4f);
            this.setSoilLongevity(40);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenMound(999));
            this.addGenFeature((IGenFeature)new FeatureGenVine());
        }

        public int maxBranchRadius() {
            return 24;
        }

        public int getLowestBranchHeight(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return (int)((float)super.getLowestBranchHeight(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 4));
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 4);
        }

        private EnumFacing getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return EnumFacing.SOUTH;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return EnumFacing.EAST;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.UP;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            if (!signal.isInTrunk()) {
                EnumFacing relativePosToRoot = this.getRelativeFace(pos, signal.rootPos);
                if (signal.energy > 2.0f) {
                    probMap[EnumFacing.DOWN.func_176745_a()] = 0;
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        probMap[dir.func_176745_a()] = 0;
                    }
                }
                boolean isBranchUp = world.func_180495_p(pos.func_177972_a(relativePosToRoot)).func_177230_c() instanceof BlockBranch;
                boolean isBranchSide = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockBranch;
                probMap[EnumFacing.UP.func_176745_a()] = isBranchUp && !isBranchSide ? 0 : 2;
                probMap[relativePosToRoot.func_176745_a()] = isBranchSide && !isBranchUp ? 0 : 3;
            }
            probMap[originDir.func_176745_a()] = 0;
            return probMap;
        }

        public boolean isThick() {
            return true;
        }
    }
}

