/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.proxy;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.blocks.BlockDynamicLeavesFruit;
import maxhyper.dynamictreesforestry.event.EventListenerForestry;
import maxhyper.dynamictreesforestry.items.ItemDynamicSeedMaple;
import maxhyper.dynamictreesforestry.models.ModelLoaderBlockPalmFronds;
import maxhyper.dynamictreesforestry.models.ModelLoaderBlockPalmFrondsBig;
import maxhyper.dynamictreesforestry.proxy.CommonProxy;
import maxhyper.dynamictreesforestry.renderer.RenderMapleSeed;
import maxhyper.dynamictreesforestry.trees.TreeWillow;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registerEntityRenderers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockPalmFronds());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockPalmFrondsBig());
        MinecraftForge.EVENT_BUS.register((Object)new EventListenerForestry());
    }

    @Override
    public void init() {
        super.init();
        this.registerColorHandlers();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    public void registerColorHandlers() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            switch (tintIndex) {
                case 0: {
                    return TreeHelper.isLeaves((Block)state.func_177230_c()) ? ((BlockDynamicLeaves)state.func_177230_c()).getProperties(state).foliageColorMultiplier(state, world, pos) : -1;
                }
                case 1: {
                    return state.func_177230_c() instanceof BlockDynamicLeavesFruit ? ((BlockDynamicLeavesFruit)state.func_177230_c()).fruitColor(state) : -1;
                }
            }
            return -1;
        }, new Block[]{ModContent.appleLeaves, ModContent.walnutLeaves, ModContent.chestnutLeaves, ModContent.cherryLeaves, ModContent.lemonLeaves, ModContent.plumLeaves});
        BlockDynamicLeaves[] specialLeaves = new BlockDynamicLeaves[]{TreeWillow.willowLeaves, ModContent.palmFrondLeaves, ModContent.papayaFrondLeaves};
        for (BlockDynamicLeaves leaves : specialLeaves) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    Block block = state.func_177230_c();
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
        for (BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"dynamictreesforestry").values()) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    Block block = state.func_177230_c();
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ItemDynamicSeedMaple.EntityItemMapleSeed.class, (IRenderFactory)new RenderMapleSeed.Factory());
    }
}

