/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.models;

import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.primitives.Ints;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import maxhyper.dynamictreesforestry.blocks.BlockDynamicLeavesPalm;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BakedModelBlockPalmFronds
implements IBakedModel {
    protected ModelBlock modelBlock;
    TextureAtlasSprite barkParticles;
    private IBakedModel[] bakedFronds = new IBakedModel[8];

    public BakedModelBlockPalmFronds(ResourceLocation frondRes, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite frondIcon;
        this.modelBlock = new ModelBlock(null, null, null, false, false, ItemCameraTransforms.field_178357_a, null);
        this.barkParticles = frondIcon = bakedTextureGetter.apply(frondRes);
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(frondIcon);
            BlockVertexData[] quadData = new BlockVertexData[]{new BlockVertexData(0.0f, 0.0f, 2.0f, 10.0f, 4.0f), new BlockVertexData(0.0f, 1.0f, 2.0f, 10.0f, 0.0f), new BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 4.0f), new BlockVertexData(0.0f, 0.0f, 2.0f, 10.0f, 4.0f), new BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 4.0f), new BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new BlockVertexData(0.0f, 1.0f, 2.0f, 10.0f, 0.0f)};
            for (int pass = 0; pass < 3; ++pass) {
                for (int half = 0; half < 2; ++half) {
                    BlockVertexData[] outData = new BlockVertexData[8];
                    for (int v = 0; v < 8; ++v) {
                        float x = quadData[v].x;
                        float z = quadData[v].z;
                        float y = quadData[v].y;
                        double len = 0.75 - (double)y;
                        double angle = Math.atan2(x *= 1.25f, y);
                        x = (float)(Math.sin(angle += Math.PI * (half == 1 ? 1.2 : -1.2)) * len);
                        y = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(y * y + (z *= 1.25f) * z);
                        angle = Math.atan2(y, z);
                        y = (float)(Math.sin(angle += Math.PI * (pass == 2 ? 0.28 : (pass == 1 ? 0.06 : -0.17))) * len);
                        z = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(x * x + z * z);
                        angle = Math.atan2(x, z);
                        x = (float)(Math.sin(angle += 0.7853981633974483 * (double)surr.ordinal() + Math.PI * (pass == 1 ? 0.185 : (pass == 2 ? 0.08 : 0.005))) * len);
                        z = (float)(Math.cos(angle) * len);
                        x += 0.5f;
                        z += 0.5f;
                        y = (float)((double)y + (pass == 2 ? -0.125 : (pass == 0 ? 0.125 : 0.0)));
                        outData[v] = new BlockVertexData(x += (float)surr.getOffset().func_177958_n(), y, z += (float)surr.getOffset().func_177952_p(), quadData[v].u, quadData[v].v);
                    }
                    builder.func_177648_a(new BakedQuad(Ints.concat((int[][])new int[][]{outData[0].toInts(frondIcon), outData[1].toInts(frondIcon), outData[2].toInts(frondIcon), outData[3].toInts(frondIcon)}), 0, null, frondIcon, false, DefaultVertexFormats.field_176600_a));
                    builder.func_177648_a(new BakedQuad(Ints.concat((int[][])new int[][]{outData[4].toInts(frondIcon), outData[5].toInts(frondIcon), outData[6].toInts(frondIcon), outData[7].toInts(frondIcon)}), 0, null, frondIcon, false, DefaultVertexFormats.field_176600_a));
                    this.bakedFronds[surr.ordinal()] = builder.func_177645_b();
                }
            }
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        if (side == null && state != null && state.func_177230_c() instanceof BlockDynamicLeavesPalm && state instanceof IExtendedBlockState) {
            for (int i = 0; i < 8; ++i) {
                Boolean b = (Boolean)((IExtendedBlockState)state).getValue(BlockDynamicLeavesPalm.CONNECTIONS[i]);
                if (b == null || !b.booleanValue()) continue;
                quads.addAll(this.bakedFronds[i].func_188616_a(state, side, rand));
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkParticles;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedFronds[0].func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    public class BlockVertexData {
        public float x;
        public float y;
        public float z;
        public int color;
        public float u;
        public float v;

        public BlockVertexData(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.color = -1;
        }

        public BlockVertexData(BakedQuad quad, int vIndex) {
            this(quad.func_178209_a(), vIndex);
        }

        public BlockVertexData(int[] data, int vIndex) {
            vIndex *= 7;
            this.x = Float.intBitsToFloat(data[vIndex++]);
            this.y = Float.intBitsToFloat(data[vIndex++]);
            this.z = Float.intBitsToFloat(data[vIndex++]);
            this.color = data[vIndex++];
            this.u = Float.intBitsToFloat(data[vIndex++]);
            this.v = Float.intBitsToFloat(data[vIndex++]);
        }

        public int[] toInts() {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(this.u), Float.floatToRawIntBits(this.v), 0};
        }

        protected int[] toInts(TextureAtlasSprite texture) {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(texture.func_94214_a((double)this.u)), Float.floatToRawIntBits(texture.func_94207_b((double)this.v)), 0};
        }
    }
}

