/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.growth;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.cells.CellNormal;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.util.ResourceLocation;

public class CustomCellKits
extends CellKits {
    private final ICellKit poplar = new ICellKit(){
        private final ICell[] normalCells = new ICell[]{CellNull.NULLCELL, new CellNormal(1), new CellNormal(2), new CellNormal(3), new CellNormal(4), new CellNormal(5), new CellNormal(6), new CellNormal(7)};
        private final ICell branchCell = new CellNormal(5);
        private final CellKits.BasicSolver deciduousSolver = new CellKits.BasicSolver(new short[]{1299, 1059, 802, 785, 545});

        public ICell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.deciduous;
        }

        public ICellSolver getCellSolver() {
            return this.deciduousSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };

    public static void preInit() {
        new CustomCellKits();
    }

    public CustomCellKits() {
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesforestry", "poplar"), (ICellKit)this.poplar);
    }
}

