/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import maxhyper.dynamictreesforestry.blocks.BlockFruitDate;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenFruitPod
implements IPostGenFeature,
IPostGrowFeature {
    BlockFruitDate fruitPod;
    int allowedSize;
    protected int fruitingRadius = 6;
    protected int frondHeight = 20;

    public FeatureGenFruitPod(BlockFruitDate fruitPod, int size) {
        this.fruitPod = fruitPod;
        this.allowedSize = Math.max(size, 1);
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, Species species, int soilLife, boolean natural) {
        if (TreeHelper.getRadius((IBlockAccess)world, (BlockPos)rootPos.func_177984_a()) >= this.fruitingRadius && natural && world.field_73012_v.nextInt() % 16 == 0 && species.seasonalFruitProductionFactor(world, rootPos) > world.field_73012_v.nextFloat()) {
            this.addFruit(world, rootPos, this.getLeavesHeight(rootPos, world).func_177979_c(world.field_73012_v.nextInt(this.allowedSize)), false);
        }
        return false;
    }

    private BlockPos getLeavesHeight(BlockPos rootPos, World world) {
        for (int y = 1; y < this.frondHeight; ++y) {
            BlockPos testPos = rootPos.func_177981_b(y);
            if (!(world.func_180495_p(testPos).func_177230_c() instanceof BlockLeaves)) continue;
            return testPos;
        }
        return rootPos;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        boolean placed = false;
        int qty = 8;
        qty = (int)((float)qty * species.seasonalFruitProductionFactor(world, rootPos));
        for (int i = 0; i < qty; ++i) {
            if (world.field_73012_v.nextInt(4) != 0) continue;
            this.addFruit(world, rootPos, this.getLeavesHeight(rootPos, world).func_177979_c(world.field_73012_v.nextInt(this.allowedSize)), true);
            placed = true;
        }
        return placed;
    }

    private void addFruit(World world, BlockPos rootPos, BlockPos leavesPos, boolean worldGen) {
        if (rootPos.func_177956_o() == leavesPos.func_177956_o()) {
            return;
        }
        EnumFacing placeDir = EnumFacing.field_176754_o[world.field_73012_v.nextInt(4)];
        if (world.func_175623_d((leavesPos = leavesPos.func_177977_b()).func_177972_a(placeDir))) {
            world.func_175656_a(leavesPos.func_177972_a(placeDir), this.fruitPod.func_176223_P().func_177226_a((IProperty)BlockFruitDate.field_185512_D, (Comparable)placeDir.func_176734_d()).func_177226_a((IProperty)BlockFruitDate.field_176501_a, (Comparable)Integer.valueOf(worldGen ? 1 + world.field_73012_v.nextInt(2) : 0)));
        }
    }
}

