/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenFruitLeaves
implements IPostGenFeature,
IPostGrowFeature {
    public int boxSize;
    public int boxHeight;
    public IBlockState leaf1;
    public IBlockState leaf2;
    public float worldGenProportion;

    public FeatureGenFruitLeaves(int size, int height, IBlockState leafType1, IBlockState leafType2, float proportionForWorldgen) {
        this.boxSize = size;
        this.boxHeight = height;
        this.leaf1 = leafType1;
        this.leaf2 = leafType2;
        this.worldGenProportion = proportionForWorldgen;
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, Species species, int soilLife, boolean natural) {
        this.changeRandLeaf(world, rootPos, 1, species);
        return false;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        this.changeLeaves(world, rootPos, this.worldGenProportion, species);
        return true;
    }

    private void attemptLeafChange(World world, BlockPos pos, boolean worldGen, Species species) {
        int growthStage = 0;
        if (!world.func_175667_e(pos)) {
            return;
        }
        if (worldGen) {
            growthStage = world.field_73012_v.nextInt(4);
        }
        if (world.func_180495_p(pos).func_177230_c() == this.leaf1.func_177230_c() && ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockDynamicLeaves.TREE)).equals(this.leaf1.func_177229_b((IProperty)BlockDynamicLeaves.TREE)) && (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockDynamicLeaves.HYDRO) == 1) {
            if (world.field_73012_v.nextFloat() <= species.seasonalFruitProductionFactor(world, pos)) {
                world.func_175656_a(pos, this.leaf2.func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(growthStage)));
            }
        } else if (world.func_180495_p(pos).func_177230_c() == this.leaf2.func_177230_c()) {
            world.func_175656_a(pos, this.leaf1);
        }
    }

    private void changeRandLeaf(World world, BlockPos rootPos, int attempts, Species species) {
        Random rand = new Random();
        do {
            int randX = rootPos.func_177958_n() + rand.nextInt(2 * this.boxSize + 1) - this.boxSize;
            int randZ = rootPos.func_177952_p() + rand.nextInt(2 * this.boxSize + 1) - this.boxSize;
            int randY = rootPos.func_177956_o() + rand.nextInt(this.boxHeight + 1);
            this.attemptLeafChange(world, new BlockPos(randX, randY, randZ), false, species);
        } while (attempts-- > 0);
    }

    private void changeLeaves(World world, BlockPos rootPos, float proportion, Species species) {
        if (proportion <= 0.0f || proportion > 1.0f) {
            return;
        }
        Random rand = new Random();
        for (int x = rootPos.func_177958_n() - this.boxSize; x < rootPos.func_177958_n() + 2 * this.boxSize; ++x) {
            for (int z = rootPos.func_177952_p() - this.boxSize; z < rootPos.func_177952_p() + 2 * this.boxSize; ++z) {
                for (int y = rootPos.func_177956_o(); y < rootPos.func_177956_o() + this.boxHeight; ++y) {
                    if (!(rand.nextFloat() * (1.0f / proportion) <= 1.0f)) continue;
                    this.attemptLeafChange(world, new BlockPos(x, y, z), true, species);
                }
            }
        }
    }
}

