/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.dropcreators;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.event.SeedVoluntaryDropEvent;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreator;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DropCreatorOtherSeed
extends DropCreator {
    private final Item seed;
    private final int seedMeta;
    private float rarity = 1.0f;

    public DropCreatorOtherSeed(ItemStack seedStack) {
        super(new ResourceLocation("dynamictreesforestry", Objects.requireNonNull(seedStack.func_77973_b().getRegistryName()).func_110623_a()));
        this.seed = seedStack.func_77973_b();
        this.seedMeta = seedStack.func_77960_j();
    }

    public DropCreatorOtherSeed setRarity(float rarity) {
        this.rarity = rarity;
        return this;
    }

    protected float getHarvestRarity() {
        return this.rarity;
    }

    protected float getVoluntaryRarity() {
        return this.rarity;
    }

    protected float getLeavesRarity() {
        return this.rarity;
    }

    public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
        if (0.015625f * this.getHarvestRarity() > random.nextFloat()) {
            dropList.add(new ItemStack(this.seed, 1, this.seedMeta));
        }
        return dropList;
    }

    public List<ItemStack> getVoluntaryDrop(World world, Species species, BlockPos rootPos, Random random, List<ItemStack> dropList, int soilLife) {
        if (this.getVoluntaryRarity() * ModConfigs.seedDropRate > random.nextFloat()) {
            dropList.add(new ItemStack(this.seed, 1, this.seedMeta));
            SeedVoluntaryDropEvent seedDropEvent = new SeedVoluntaryDropEvent(world, rootPos, species, dropList);
            MinecraftForge.EVENT_BUS.post((Event)seedDropEvent);
            if (seedDropEvent.isCanceled()) {
                dropList.clear();
            }
        }
        return dropList;
    }

    public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
        int chance = (int)(20.0f / this.rarity);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (random.nextInt((int)((float)chance / this.getLeavesRarity())) == 0) {
            dropList.add(new ItemStack(this.seed, 1, this.seedMeta));
        }
        return dropList;
    }
}

