/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockFruitCocoa;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.Objects;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockFruitDate
extends BlockFruitCocoa {
    private int fruitMeta;
    private Species species;
    private static final double offset = 0.31;
    protected static final AxisAlignedBB[] COCOA_EAST_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.9975, 0.4375, 0.375, 1.2475, 0.75, 0.625), new AxisAlignedBB(0.8725, 0.3125, 0.3125, 1.2475, 0.75, 0.6875), new AxisAlignedBB(0.7475, 0.1875, 0.25, 1.2475, 0.75, 0.75)};
    protected static final AxisAlignedBB[] COCOA_WEST_AABB = new AxisAlignedBB[]{new AxisAlignedBB(-0.2475, 0.4375, 0.375, 0.0025000000000000022, 0.75, 0.625), new AxisAlignedBB(-0.2475, 0.3125, 0.3125, 0.1275, 0.75, 0.6875), new AxisAlignedBB(-0.2475, 0.1875, 0.25, 0.2525, 0.75, 0.75)};
    protected static final AxisAlignedBB[] COCOA_NORTH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.4375, -0.2475, 0.625, 0.75, 0.0025000000000000022), new AxisAlignedBB(0.3125, 0.3125, -0.2475, 0.6875, 0.75, 0.1275), new AxisAlignedBB(0.25, 0.1875, -0.2475, 0.75, 0.75, 0.2525)};
    protected static final AxisAlignedBB[] COCOA_SOUTH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.4375, 0.9975, 0.625, 0.75, 1.2475), new AxisAlignedBB(0.3125, 0.3125, 0.8725, 0.6875, 0.75, 1.2475), new AxisAlignedBB(0.25, 0.1875, 0.7475, 0.75, 0.75, 1.2475)};

    public BlockFruitDate(String name, int fruitMeta) {
        super(name);
        this.fruitMeta = fruitMeta;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)field_176501_a);
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            case SOUTH: {
                return COCOA_SOUTH_AABB[i];
            }
            default: {
                return COCOA_NORTH_AABB[i];
            }
            case WEST: {
                return COCOA_WEST_AABB[i];
            }
            case EAST: 
        }
        return COCOA_EAST_AABB[i];
    }

    public boolean func_176499_e(World world, BlockPos pos, IBlockState state) {
        IBlockState branchState = world.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
        BlockBranch branch = TreeHelper.getBranch((IBlockState)branchState);
        return branch != null && branch.getRadius(branchState) == 3 && branch.getFamily().canSupportCocoa;
    }

    private ItemStack fruitItem() {
        return new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, this.fruitMeta);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.fruitItem();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int i = (Integer)state.func_177229_b((IProperty)field_176501_a);
        if (i == 2) {
            drops.add((Object)this.fruitItem());
        }
    }
}

