/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.blocks;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.Species;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockDynamicLeavesFruit
extends BlockDynamicLeaves {
    private static final Map<fruitTypes, int[]> fruitColors = new HashMap<fruitTypes, int[]>(){
        {
            this.put(fruitTypes.APPLE, new int[]{14939292, 15512183, 16150611, 0xFF2E2E});
            this.put(fruitTypes.WALNUT, new int[]{12898890, 14074441, 15315529, 16491080});
            this.put(fruitTypes.CHESTNUT, new int[]{12898890, 11377990, 9857089, 8336189});
            this.put(fruitTypes.CHERRY, new int[]{12898890, 14195521, 15426871, 0xFF2E2E});
            this.put(fruitTypes.LEMON, new int[]{0x99FF00, 11925760, 13825024, 0xEEEE00});
            this.put(fruitTypes.PLUM, new int[]{15662874, 12696361, 9664567, 0x663446});
        }
    };
    private static final Map<fruitTypes, ItemStack> fruitDrops = new HashMap<fruitTypes, ItemStack>(){
        {
            this.put(fruitTypes.APPLE, new ItemStack(Items.field_151034_e));
            this.put(fruitTypes.WALNUT, new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, 1));
            this.put(fruitTypes.CHESTNUT, new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, 2));
            this.put(fruitTypes.CHERRY, new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, 0));
            this.put(fruitTypes.LEMON, new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, 3));
            this.put(fruitTypes.PLUM, new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fruits"))), 1, 4));
        }
    };
    private fruitTypes leafFruitType;
    private Species species;

    public BlockDynamicLeavesFruit setSpecies(Species species) {
        this.species = species;
        return this;
    }

    public BlockDynamicLeavesFruit(String name, fruitTypes fruitType) {
        this.setRegistryName("dynamictreesforestry", name);
        this.func_149663_c(name);
        this.leafFruitType = fruitType;
    }

    public void setProperties(ILeavesProperties properties) {
        this.setProperties(0, properties);
        this.setProperties(1, properties);
        this.setProperties(2, properties);
        this.setProperties(3, properties);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int age = (Integer)state.func_177229_b((IProperty)TREE);
        if (age < 3 && (double)rand.nextFloat() <= 0.01 * (double)this.species.seasonalFruitProductionFactor(world, pos)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    public static void addEntityBiodustFX(World world, double x, double y, double z, int ammount) {
        for (int i = 0; i < ammount; ++i) {
            ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
            Particle particle = effectRenderer.func_178927_a(EnumParticleTypes.VILLAGER_HAPPY.ordinal(), x + (double)world.field_73012_v.nextFloat(), y + (double)world.field_73012_v.nextFloat(), z + (double)world.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            if (particle == null) continue;
            effectRenderer.func_78873_a(particle);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(access, pos, state, fortune);
        int fruitAge = (Integer)state.func_177229_b((IProperty)BlockDynamicLeaves.TREE);
        if (fruitAge == 3 || fruitAge == 2 && fortune > 0) {
            drops.add(fruitDrops.get((Object)this.leafFruitType));
        }
        return drops;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
            if ((Integer)state.func_177229_b((IProperty)TREE) == 3) {
                if (mainHand.func_190926_b() && offHand.func_190926_b()) {
                    PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, state);
                    NetworkUtil.sendNetworkPacket((IForestryPacketClient)packet, (BlockPos)pos, (World)world);
                    ItemStack fruit = fruitDrops.get((Object)this.leafFruitType);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)fruit);
                    world.func_175656_a(pos, state.func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(0)));
                    return true;
                }
                return false;
            }
            if (mainHand.func_77973_b() == Items.field_151100_aR && mainHand.func_77960_j() == 15 && hand == EnumHand.MAIN_HAND) {
                this.useBoneMeal(world, pos, state, mainHand, player);
                return true;
            }
            if (offHand.func_77973_b() == Items.field_151100_aR && offHand.func_77960_j() == 15 && hand == EnumHand.OFF_HAND) {
                this.useBoneMeal(world, pos, state, offHand, player);
                return true;
            }
        }
        return false;
    }

    private void useBoneMeal(World world, BlockPos pos, IBlockState state, ItemStack handStack, EntityPlayer player) {
        BlockDynamicLeavesFruit.addEntityBiodustFX(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 4);
        int grow = 1;
        world.func_175656_a(pos, state.func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)TREE) + grow)));
        if (!player.func_184812_l_()) {
            handStack.func_190918_g(1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int fruitColor(IBlockState state) {
        return fruitColors.get((Object)this.leafFruitType)[(Integer)state.func_177229_b((IProperty)TREE)];
    }

    public static enum fruitTypes {
        APPLE,
        WALNUT,
        CHESTNUT,
        CHERRY,
        LEMON,
        PLUM;

    }
}

