/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class BiomeUtils {
    private final List<Biome> BIOME_TYPES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> BIOME_NAMES = Lists.newArrayList();
    private String CURRENT_BIOME_NAME;

    private void emptyData() {
        this.BIOME_NAMES.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_BIOME_NAME = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgument("&BIOME&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectBiomeData : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.BIOME_NAMES.isEmpty() || this.BIOME_TYPES.isEmpty());
        if (needsUpdate) {
            this.getBiomes();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateBiomeData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateBiomeData() {
        Biome newBiome = CraftPresence.player.field_70170_p.func_180494_b(CraftPresence.player.func_180425_c());
        String newBiomeName = newBiome.func_185359_l();
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME)) {
            this.CURRENT_BIOME_NAME = newBiomeName;
            if (!this.BIOME_NAMES.contains(newBiomeName)) {
                this.BIOME_NAMES.add(newBiomeName);
            }
            if (!this.BIOME_TYPES.contains(newBiome)) {
                this.BIOME_TYPES.add(newBiome);
            }
            this.updateBiomePresence();
        }
    }

    public void updateBiomePresence() {
        ArrayList biomeArgs = Lists.newArrayList();
        biomeArgs.add(new Pair<String, String>("&BIOME&", this.CURRENT_BIOME_NAME));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            biomeArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultBiomeMessage);
        String currentBiomeIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BIOME_NAME);
        String formattedIconKey = StringUtils.formatAsIcon(currentBiomeIcon.replace(" ", "_"));
        String CURRENT_BIOME_ICON = formattedIconKey.replace("&icon&", CraftPresence.CONFIG.defaultBiomeIcon);
        String CURRENT_BIOME_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentBiomeMessage, biomeArgs);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CURRENT_BIOME_MESSAGE, false);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CraftPresence.CLIENT.imageOf(CURRENT_BIOME_ICON, CraftPresence.CONFIG.defaultBiomeIcon, true), true);
    }

    private List<Biome> getBiomeTypes() {
        ArrayList biomeTypes = Lists.newArrayList();
        if (Biome.field_185377_q != null) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || biomeTypes.contains(biome)) continue;
                biomeTypes.add(biome);
            }
        }
        if (biomeTypes.isEmpty()) {
            for (Class<?> classObj : FileUtils.getClassNamesMatchingSuperType(Biome.class, true, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                if (classObj == null) continue;
                try {
                    Biome biomeObj = (Biome)classObj.newInstance();
                    if (biomeTypes.contains(biomeObj)) continue;
                    biomeTypes.add(biomeObj);
                }
                catch (Error | Exception ex) {
                    if (!ModUtils.IS_VERBOSE) continue;
                    ex.printStackTrace();
                }
            }
        }
        return biomeTypes;
    }

    public void getBiomes() {
        for (Biome biome : this.getBiomeTypes()) {
            if (biome == null) continue;
            if (!this.BIOME_NAMES.contains(biome.func_185359_l())) {
                this.BIOME_NAMES.add(biome.func_185359_l());
            }
            if (this.BIOME_TYPES.contains(biome)) continue;
            this.BIOME_TYPES.add(biome);
        }
        for (String biomeMessage : CraftPresence.CONFIG.biomeMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(biomeMessage) || StringUtils.isNullOrEmpty((part = biomeMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.BIOME_NAMES.contains(part[0])) continue;
            this.BIOME_NAMES.add(part[0]);
        }
    }
}

