/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.PairConsumer;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedScreen;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.SliderControl;
import java.awt.Color;
import java.io.File;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class ColorEditorGui
extends ExtendedScreen {
    private final String configValueName;
    private final PairConsumer<Integer, ColorEditorGui> onAdjustEntry;
    private final DataConsumer<ColorEditorGui> onInit;
    public String currentNormalHexValue;
    public String startingHexValue;
    public String currentNormalTexturePath;
    public String startingTexturePath;
    public boolean usingExternalTexture = false;
    private int pageNumber;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl nextPageButton;
    private ExtendedButtonControl previousPageButton;
    private String currentConvertedHexValue;
    private int currentRed;
    private int currentGreen;
    private int currentBlue;
    private int currentAlpha;
    private ExtendedTextControl hexText;
    private SliderControl redText;
    private SliderControl greenText;
    private SliderControl blueText;
    private SliderControl alphaText;
    private String currentConvertedTexturePath;
    private ExtendedTextControl textureText;
    private boolean isModified = false;
    private ResourceLocation currentTexture;

    public ColorEditorGui(GuiScreen parentScreen, String configValueName, PairConsumer<Integer, ColorEditorGui> onAdjustEntry, DataConsumer<ColorEditorGui> onInit) {
        super(parentScreen);
        this.configValueName = configValueName;
        this.pageNumber = 0;
        this.onAdjustEntry = onAdjustEntry;
        this.onInit = onInit;
    }

    @Override
    public void initializeUi() {
        int calc1 = this.field_146294_l / 2 - 183;
        int calc2 = this.field_146294_l / 2 + 3;
        String redTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.red", new Object[0]);
        String greenTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.green", new Object[0]);
        String blueTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.blue", new Object[0]);
        String alphaTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.alpha", new Object[0]);
        this.hexText = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.hexText.func_146203_f(10);
        this.redText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, CraftPresence.GUIS.getButtonY(2)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, redTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)));
        this.greenText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc2, CraftPresence.GUIS.getButtonY(2)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)));
        this.blueText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, CraftPresence.GUIS.getButtonY(3)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)));
        this.alphaText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc2, CraftPresence.GUIS.getButtonY(3)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)));
        this.textureText = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20, this::syncValues));
        this.textureText.func_146203_f(Short.MAX_VALUE);
        this.proceedButton = this.addControl(new ExtendedButtonControl(10, this.field_146295_m - 30, 80, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> {
            this.syncValues();
            if (this.isModified && this.onAdjustEntry != null) {
                this.onAdjustEntry.accept(this.pageNumber, this);
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, new String[0]));
        this.previousPageButton = this.addControl(new ExtendedButtonControl(this.proceedButton.getControlPosX() + this.proceedButton.getControlWidth() + 3, this.field_146295_m - 30, 20, 20, "<", () -> {
            if (this.pageNumber != 0) {
                --this.pageNumber;
                this.initValues();
                this.syncValues();
            }
        }, new String[0]));
        this.nextPageButton = this.addControl(new ExtendedButtonControl(this.previousPageButton.getControlPosX() + this.previousPageButton.getControlWidth() + 3, this.field_146295_m - 30, 20, 20, ">", () -> {
            if (this.pageNumber != 1) {
                ++this.pageNumber;
                this.initValues();
                this.syncValues();
            }
        }, new String[0]));
        this.initValues();
        this.syncValues();
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.color", this.configValueName.replaceAll("_", " "));
        String previewTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]);
        this.renderString(mainTitle, (float)this.field_146294_l / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(previewTitle, this.field_146294_l - 90, (float)this.field_146295_m - 29.5f, 0xFFFFFF);
        this.hexText.func_146189_e(this.pageNumber == 0);
        this.hexText.func_146184_c(this.hexText.func_146176_q());
        this.redText.setControlEnabled(this.pageNumber == 0);
        this.redText.setControlVisible(this.redText.isControlEnabled());
        this.greenText.setControlEnabled(this.pageNumber == 0);
        this.greenText.setControlVisible(this.greenText.isControlEnabled());
        this.blueText.setControlEnabled(this.pageNumber == 0);
        this.blueText.setControlVisible(this.blueText.isControlEnabled());
        this.alphaText.setControlEnabled(this.pageNumber == 0);
        this.alphaText.setControlVisible(this.alphaText.isControlEnabled());
        this.textureText.func_146189_e(this.pageNumber == 1);
        this.textureText.func_146184_c(this.textureText.func_146176_q());
        double tooltipX = this.field_146294_l - 45;
        double tooltipY = this.field_146295_m - 45;
        double tooltipHeight = 40.0;
        double tooltipTextWidth = 40.0;
        String borderColor = "#000000";
        String borderColorEnd = "#000000";
        if (this.pageNumber == 0) {
            String hexCodeTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.hex_code", new Object[0]);
            this.renderString(hexCodeTitle, (float)this.field_146294_l / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
            this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.hexText.func_146179_b()));
            CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0, this.field_146294_l - 2, this.field_146295_m - 2, this.currentConvertedHexValue, this.currentConvertedHexValue);
        }
        if (this.pageNumber == 1) {
            String textureTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]);
            this.renderString(textureTitle, (float)this.field_146294_l / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
            this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.textureText.func_146179_b()));
            if (this.currentTexture == null) {
                this.currentTexture = new ResourceLocation("");
            }
            double widthDivider = 32.0;
            double heightDivider = 32.0;
            if (this.usingExternalTexture) {
                String formattedConvertedName = this.currentConvertedTexturePath.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                this.currentTexture = ImageUtils.getTextureFromUrl(textureName, this.currentConvertedTexturePath.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                widthDivider = 44.0;
                heightDivider = 43.0;
            }
            CraftPresence.GUIS.drawTextureRect(0.0, this.field_146294_l - 47, this.field_146295_m - 47, 44.0, 44.0, 0.0, widthDivider, heightDivider, false, this.currentTexture);
        }
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0 + 1.0, tooltipX - 3.0 + 1.0, tooltipY + tooltipHeight + 3.0 - 1.0, borderColor, borderColorEnd);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2.0, tooltipY - 3.0 + 1.0, tooltipX + tooltipTextWidth + 3.0, tooltipY + tooltipHeight + 3.0 - 1.0, borderColor, borderColorEnd);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0, tooltipX + tooltipTextWidth + 3.0, tooltipY - 3.0 + 1.0, borderColor, borderColor);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY + tooltipHeight + 2.0, tooltipX + tooltipTextWidth + 3.0, tooltipY + tooltipHeight + 3.0, borderColorEnd, borderColorEnd);
        this.previousPageButton.setControlEnabled(this.pageNumber != 0);
        this.nextPageButton.setControlEnabled(this.pageNumber != 1);
        this.proceedButton.setControlMessage(this.isModified ? ModUtils.TRANSLATOR.translate("gui.config.message.button.save", new Object[0]) : ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]));
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 200 && this.pageNumber != 0) {
            --this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (keyCode == 208 && this.pageNumber != 1) {
            ++this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void initValues() {
        if (this.onInit != null) {
            this.onInit.accept(this);
            if (StringUtils.isNullOrEmpty(this.hexText.func_146179_b()) && !StringUtils.isNullOrEmpty(this.startingHexValue)) {
                this.hexText.func_146180_a(this.startingHexValue);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedTexturePath = null;
                this.currentTexture = new ResourceLocation("");
                this.pageNumber = 0;
            } else if (StringUtils.isNullOrEmpty(this.textureText.func_146179_b()) && !StringUtils.isNullOrEmpty(this.startingTexturePath)) {
                this.textureText.func_146180_a(this.startingTexturePath);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedTexturePath = null;
                this.currentTexture = new ResourceLocation("");
                this.pageNumber = 1;
            }
        }
    }

    private void syncValues() {
        if (this.pageNumber == 0) {
            Color localColor;
            Integer localValue = null;
            if (!StringUtils.isNullOrEmpty(this.hexText.func_146179_b())) {
                if (this.hexText.func_146179_b().startsWith("#") || this.hexText.func_146179_b().length() == 6) {
                    localValue = StringUtils.getColorFromHex(this.hexText.func_146179_b()).getRGB();
                } else if (this.hexText.func_146179_b().startsWith("0x")) {
                    try {
                        localColor = new Color(Long.decode(this.hexText.func_146179_b()).intValue(), true);
                        localValue = localColor.getRGB();
                    }
                    catch (Exception exception) {}
                } else if (StringUtils.getValidInteger(this.hexText.func_146179_b()).getFirst().booleanValue()) {
                    localValue = Integer.decode(this.hexText.func_146179_b());
                }
            }
            if (localValue != null && !Integer.toString(localValue).equals(this.currentConvertedHexValue)) {
                this.currentAlpha = localValue >> 24 & 0xFF;
                this.currentRed = localValue >> 16 & 0xFF;
                this.currentGreen = localValue >> 8 & 0xFF;
                this.currentBlue = localValue & 0xFF;
                this.alphaText.setSliderValue(this.currentAlpha);
                this.redText.setSliderValue(this.currentRed);
                this.greenText.setSliderValue(this.currentGreen);
                this.blueText.setSliderValue(this.currentBlue);
                this.currentNormalHexValue = this.hexText.func_146179_b();
                this.currentConvertedHexValue = Integer.toString(localValue);
            } else {
                boolean isAlphaDifferent;
                boolean isRedDifferent = this.redText.isDragging() && this.redText.getSliderValue(false) != (float)this.currentRed;
                boolean isGreenDifferent = this.greenText.isDragging() && this.greenText.getSliderValue(false) != (float)this.currentGreen;
                boolean isBlueDifferent = this.blueText.isDragging() && this.blueText.getSliderValue(false) != (float)this.currentBlue;
                boolean bl = isAlphaDifferent = this.alphaText.isDragging() && this.alphaText.getSliderValue(false) != (float)this.currentAlpha;
                if (isRedDifferent || isGreenDifferent || isBlueDifferent || isAlphaDifferent) {
                    this.currentRed = (int)this.redText.getSliderValue(false) & 0xFF;
                    this.currentGreen = (int)this.greenText.getSliderValue(false) & 0xFF;
                    this.currentBlue = (int)this.blueText.getSliderValue(false) & 0xFF;
                    this.currentAlpha = (int)this.alphaText.getSliderValue(false) & 0xFF;
                    localColor = new Color(this.currentRed, this.currentGreen, this.currentBlue, this.currentAlpha);
                    this.currentNormalHexValue = StringUtils.getHexFromColor(localColor);
                    this.hexText.func_146180_a(this.currentNormalHexValue);
                    this.currentConvertedHexValue = Long.toString(Long.decode(this.currentNormalHexValue).intValue());
                }
            }
            boolean bl = this.isModified = !this.hexText.func_146179_b().equals(this.startingHexValue);
        }
        if (this.pageNumber == 1) {
            if (!StringUtils.isNullOrEmpty(this.textureText.func_146179_b())) {
                this.usingExternalTexture = ImageUtils.isExternalImage(this.textureText.func_146179_b());
                if (!this.usingExternalTexture) {
                    if (this.textureText.func_146179_b().contains(CraftPresence.CONFIG.splitCharacter)) {
                        this.textureText.func_146180_a(this.textureText.func_146179_b().replace(CraftPresence.CONFIG.splitCharacter, ":"));
                    }
                    this.currentNormalTexturePath = this.textureText.func_146179_b().contains(":") && !this.textureText.func_146179_b().startsWith(":") ? this.textureText.func_146179_b() : (this.textureText.func_146179_b().startsWith(":") ? this.textureText.func_146179_b().substring(1) : "minecraft:" + this.textureText.func_146179_b());
                } else {
                    this.currentNormalTexturePath = this.textureText.func_146179_b();
                }
                this.currentConvertedTexturePath = this.currentNormalTexturePath.trim();
                if (!this.usingExternalTexture) {
                    if (this.currentConvertedTexturePath.contains(":")) {
                        String[] splitInput = this.currentConvertedTexturePath.split(":", 2);
                        this.currentTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        this.currentTexture = new ResourceLocation(this.currentConvertedTexturePath);
                    }
                } else {
                    String formattedConvertedName = this.currentConvertedTexturePath.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    this.currentTexture = ImageUtils.getTextureFromUrl(textureName, this.currentConvertedTexturePath.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
            } else {
                this.currentTexture = new ResourceLocation("");
            }
            this.isModified = !this.textureText.func_146179_b().equals(this.startingTexturePath.replace(CraftPresence.CONFIG.splitCharacter, ":"));
        }
    }
}

