/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedScreen;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    private final List<Class<?>> GUI_CLASSES = Lists.newArrayList();
    public boolean openConfigGUI = false;
    public boolean configGUIOpened = false;
    public boolean isInUse = false;
    public boolean isFocused = false;
    public boolean enabled = false;
    public int lastIndex = 0;
    public List<String> GUI_NAMES = Lists.newArrayList();
    private String CURRENT_GUI_NAME;
    private Class<?> CURRENT_GUI_CLASS;
    private GuiScreen CURRENT_SCREEN;

    public static FontRenderer getDefaultFontRenderer() {
        return CraftPresence.instance.field_71466_p;
    }

    public static int getDefaultFontHeight() {
        return GuiUtils.getDefaultFontRenderer().field_78288_b;
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        GL11.glEnable((int)3008);
        tessellator.func_78381_a();
    }

    public boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return mouseX >= elementX && mouseX <= elementX + elementWidth && mouseY >= elementY && mouseY <= elementY + elementHeight;
    }

    public boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return this.isMouseOver(mouseX, mouseY, button.getControlPosX(), button.getControlPosY(), button.getControlWidth() - 1, button.getControlHeight() - 1);
    }

    public boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return this.isMouseOver(mouseX, mouseY, textControl.getControlPosX(), textControl.getControlPosY(), textControl.getControlWidth() - 1, textControl.getControlHeight() - 1);
    }

    public boolean isMouseOver(double mouseX, double mouseY, CheckBoxControl checkBox) {
        return this.isMouseOver(mouseX, mouseY, checkBox.getControlPosX(), checkBox.getControlPosY(), checkBox.boxWidth - 1, checkBox.getControlHeight() - 1);
    }

    public int getNextIndex() {
        return this.lastIndex++;
    }

    public void resetIndex() {
        this.lastIndex = 0;
    }

    private void emptyData() {
        this.GUI_NAMES.clear();
        this.GUI_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.CURRENT_GUI_CLASS = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgument("&SCREEN&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerGui : this.enabled;
        this.isFocused = CraftPresence.instance.field_71462_r != null && CraftPresence.instance.field_71462_r.func_193976_p();
        boolean bl = needsUpdate = this.enabled && (this.GUI_NAMES.isEmpty() || this.GUI_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getScreens();
        }
        if (this.enabled) {
            if (CraftPresence.instance.field_71462_r != null) {
                this.isInUse = true;
                this.updateGUIData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
        if (this.configGUIOpened && !(CraftPresence.instance.field_71462_r instanceof ExtendedScreen)) {
            this.configGUIOpened = false;
        }
        if (this.openConfigGUI) {
            this.openScreen(new MainGui(CraftPresence.instance.field_71462_r));
            this.openConfigGUI = false;
        }
    }

    public void openScreen(GuiScreen targetScreen) {
        CraftPresence.instance.func_152344_a(() -> CraftPresence.instance.func_147108_a(targetScreen));
    }

    private void updateGUIData() {
        if (CraftPresence.instance.field_71462_r == null) {
            this.clearClientData();
        } else {
            GuiScreen newScreen = CraftPresence.instance.field_71462_r;
            Class<?> newScreenClass = newScreen.getClass();
            String newScreenName = newScreenClass.getSimpleName();
            if (!(newScreen.equals(this.CURRENT_SCREEN) && newScreenClass.equals(this.CURRENT_GUI_CLASS) && newScreenName.equals(this.CURRENT_GUI_NAME))) {
                this.CURRENT_SCREEN = newScreen;
                this.CURRENT_GUI_CLASS = newScreenClass;
                this.CURRENT_GUI_NAME = newScreenName;
                if (!this.GUI_NAMES.contains(newScreenName)) {
                    this.GUI_NAMES.add(newScreenName);
                }
                if (!this.GUI_CLASSES.contains(newScreenClass)) {
                    this.GUI_CLASSES.add(newScreenClass);
                }
                this.updateGUIPresence();
            }
        }
    }

    public void getScreens() {
        Class[] searchClasses = new Class[]{GuiScreen.class, GuiContainer.class};
        for (Class<?> classObj : FileUtils.getClassNamesMatchingSuperType(Arrays.asList(searchClasses), CraftPresence.CONFIG.includeExtraGuiClasses, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
            if (!this.GUI_NAMES.contains(classObj.getSimpleName())) {
                this.GUI_NAMES.add(classObj.getSimpleName());
            }
            if (this.GUI_CLASSES.contains(classObj)) continue;
            this.GUI_CLASSES.add(classObj);
        }
        for (String guiMessage : CraftPresence.CONFIG.guiMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(guiMessage) || StringUtils.isNullOrEmpty((part = guiMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.GUI_NAMES.contains(part[0])) continue;
            this.GUI_NAMES.add(part[0]);
        }
    }

    public void updateGUIPresence() {
        ArrayList guiArgs = Lists.newArrayList();
        guiArgs.add(new Pair<String, String>("&SCREEN&", this.CURRENT_GUI_NAME));
        guiArgs.add(new Pair<String, String>("&CLASS&", this.CURRENT_GUI_CLASS.getSimpleName()));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            guiArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultGuiMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentGuiMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, this.CURRENT_GUI_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultGuiMessage);
        String CURRENT_GUI_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentGuiMessage, guiArgs);
        CraftPresence.CLIENT.syncArgument("&SCREEN&", CURRENT_GUI_MESSAGE, false);
        CraftPresence.CLIENT.initArgument(true, "&SCREEN&");
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer fontRenderer, boolean withBackground) {
        if (CraftPresence.CONFIG.renderTooltips && !ModUtils.forceBlockTooltipRendering && !textToInput.isEmpty() && fontRenderer != null) {
            ArrayList textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = StringUtils.getStringWidth(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = posX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = posX > screenWidth / 2 ? posX - 12 - 8 : screenWidth - 16 - posX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList wrappedTextLines = Lists.newArrayList();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List<String> wrappedLine = StringUtils.splitTextByNewLine(StringUtils.wrapFormattedStringToWidth(textLine, tooltipTextWidth));
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = StringUtils.getStringWidth(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = posX > screenWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
            }
            int tooltipY = posY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            if (withBackground) {
                String borderColor;
                boolean usingExternalTexture;
                String backgroundColor;
                GL11.glDisable((int)2929);
                int zLevel = 300;
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.tooltipBackgroundColor)) {
                    backgroundColor = CraftPresence.CONFIG.tooltipBackgroundColor.length() == 6 ? "#" + CraftPresence.CONFIG.tooltipBackgroundColor : (CraftPresence.CONFIG.tooltipBackgroundColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.tooltipBackgroundColor).intValue()) : CraftPresence.CONFIG.tooltipBackgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                } else {
                    ResourceLocation backGroundTexture;
                    usingExternalTexture = ImageUtils.isExternalImage(CraftPresence.CONFIG.tooltipBackgroundColor);
                    double widthDivider = 32.0;
                    double heightDivider = 32.0;
                    if (!usingExternalTexture) {
                        backgroundColor = CraftPresence.CONFIG.tooltipBackgroundColor.contains(CraftPresence.CONFIG.splitCharacter) ? CraftPresence.CONFIG.tooltipBackgroundColor.replace(CraftPresence.CONFIG.splitCharacter, ":") : (CraftPresence.CONFIG.tooltipBackgroundColor.contains(":") && !CraftPresence.CONFIG.tooltipBackgroundColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBackgroundColor : (CraftPresence.CONFIG.tooltipBackgroundColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBackgroundColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.tooltipBackgroundColor));
                        if (backgroundColor.contains(":")) {
                            String[] splitInput = backgroundColor.split(":", 2);
                            backGroundTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                        } else {
                            backGroundTexture = new ResourceLocation(backgroundColor);
                        }
                    } else {
                        String formattedConvertedName = CraftPresence.CONFIG.tooltipBackgroundColor.replaceFirst("file://", "");
                        String[] urlBits = formattedConvertedName.trim().split("/");
                        String textureName = urlBits[urlBits.length - 1].trim();
                        backGroundTexture = ImageUtils.getTextureFromUrl(textureName, CraftPresence.CONFIG.tooltipBackgroundColor.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                        widthDivider = tooltipTextWidth + 8;
                        heightDivider = tooltipHeight + 8;
                    }
                    this.drawTextureRect(300.0, tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 0.0, widthDivider, heightDivider, false, backGroundTexture);
                }
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.tooltipBorderColor)) {
                    borderColor = CraftPresence.CONFIG.tooltipBorderColor.length() == 6 ? "#" + CraftPresence.CONFIG.tooltipBorderColor : (CraftPresence.CONFIG.tooltipBorderColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.tooltipBorderColor).intValue()) : CraftPresence.CONFIG.tooltipBorderColor);
                    int borderColorCode = borderColor.startsWith("#") ? StringUtils.getColorFromHex(borderColor).getRGB() : Integer.parseInt(borderColor);
                    String borderColorEnd = Integer.toString((borderColorCode & 0xFEFEFE) >> 1 | borderColorCode & 0xFF000000);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColor, borderColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
                } else {
                    ResourceLocation borderTexture;
                    usingExternalTexture = ImageUtils.isExternalImage(CraftPresence.CONFIG.tooltipBorderColor);
                    if (!usingExternalTexture) {
                        borderColor = CraftPresence.CONFIG.tooltipBorderColor.contains(CraftPresence.CONFIG.splitCharacter) ? CraftPresence.CONFIG.tooltipBorderColor.replace(CraftPresence.CONFIG.splitCharacter, ":") : (CraftPresence.CONFIG.tooltipBorderColor.contains(":") && !CraftPresence.CONFIG.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBorderColor : (CraftPresence.CONFIG.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBorderColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.tooltipBorderColor));
                        if (borderColor.contains(":")) {
                            String[] splitInput = borderColor.split(":", 2);
                            borderTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                        } else {
                            borderTexture = new ResourceLocation(borderColor);
                        }
                    } else {
                        String formattedConvertedName = CraftPresence.CONFIG.tooltipBorderColor.replaceFirst("file://", "");
                        String[] urlBits = formattedConvertedName.trim().split("/");
                        String textureName = urlBits[urlBits.length - 1].trim();
                        borderTexture = ImageUtils.getTextureFromUrl(textureName, CraftPresence.CONFIG.tooltipBorderColor.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                    }
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 5, 1.0, 0.0, usingExternalTexture ? (double)(tooltipTextWidth + 5) : 32.0, usingExternalTexture ? 1.0 : 32.0, false, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipTextWidth + 5, 1.0, 0.0, usingExternalTexture ? (double)(tooltipTextWidth + 5) : 32.0, usingExternalTexture ? 1.0 : 32.0, false, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, 1.0, tooltipHeight + 5, 0.0, usingExternalTexture ? 1.0 : 32.0, usingExternalTexture ? (double)(tooltipHeight + 5) : 32.0, false, borderTexture);
                    this.drawTextureRect(300.0, tooltipX + tooltipTextWidth + 2, tooltipY - 3, 1.0, tooltipHeight + 6, 0.0, usingExternalTexture ? 1.0 : 32.0, usingExternalTexture ? (double)(tooltipHeight + 6) : 32.0, false, borderTexture);
                }
            }
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                fontRenderer.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            if (withBackground) {
                GL11.glEnable((int)2929);
            }
        }
    }

    public void drawBackground(double width, double height) {
        double widthDivider = 32.0;
        double heightDivider = 32.0;
        if (CraftPresence.instance.field_71441_e != null) {
            this.drawGradientRect(300.0f, 0.0, 0.0, width, height, "-1072689136", "-804253680");
        } else {
            String backgroundCode = CraftPresence.CONFIG.guiBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                this.drawGradientRect(300.0f, 0.0, 0.0, width, height, backgroundCode, backgroundCode);
            } else {
                ResourceLocation texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                        backgroundCode = backgroundCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                    }
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new ResourceLocation(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                    widthDivider = width;
                    heightDivider = height;
                }
                this.drawTextureRect(0.0, 0.0, 0.0, width, height, 0.0, widthDivider, heightDivider, CraftPresence.CONFIG.showBackgroundAsDark, texLocation);
            }
        }
    }

    public void renderSlider(int x, int y, int u, int v, int width, int height, double zLevel, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(x, y, u, v, width, height, zLevel);
        this.drawTexturedModalRect(x + 4, y, u + 196, v, width, height, zLevel);
    }

    public void renderButton(int x, int y, int width, int height, int hoverState, double zLevel, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int v = 46 + hoverState * 20;
        int xOffset = width / 2;
        this.drawTexturedModalRect(x, y, 0, v, xOffset, height, zLevel);
        this.drawTexturedModalRect(x + xOffset, y, 200 - xOffset, v, xOffset, height, zLevel);
        GL11.glDisable((int)3042);
    }

    public void drawTextureRect(double zLevel, double xPos, double yPos, double width, double height, double tint, ResourceLocation texLocation) {
        this.drawTextureRect(zLevel, xPos, yPos, width, height, tint, 32.0, 32.0, false, texLocation);
    }

    public void drawTextureRect(double zLevel, double xPos, double yPos, double width, double height, double tint, double widthDivider, double heightDivider, boolean shouldBeDark, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tuple<Integer, Integer, Integer> rgbData = new Tuple<Integer, Integer, Integer>(shouldBeDark ? 64 : 255, shouldBeDark ? 64 : 255, shouldBeDark ? 64 : 255);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(xPos, yPos + height, zLevel).func_187315_a(0.0, height / heightDivider + tint).func_181669_b(rgbData.getFirst().intValue(), rgbData.getSecond().intValue(), rgbData.getSecond().intValue(), 255).func_181675_d();
        buffer.func_181662_b(xPos + width, yPos + height, zLevel).func_187315_a(width / widthDivider, height / heightDivider + tint).func_181669_b(rgbData.getFirst().intValue(), rgbData.getSecond().intValue(), rgbData.getSecond().intValue(), 255).func_181675_d();
        buffer.func_181662_b(xPos + width, yPos, zLevel).func_187315_a(width / widthDivider, tint).func_181669_b(rgbData.getFirst().intValue(), rgbData.getSecond().intValue(), rgbData.getSecond().intValue(), 255).func_181675_d();
        buffer.func_181662_b(xPos, yPos, zLevel).func_187315_a(0.0, tint).func_181669_b(rgbData.getFirst().intValue(), rgbData.getSecond().intValue(), rgbData.getSecond().intValue(), 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawGradientRect(float zLevel, double left, double top, double right, double bottom, String startColorCode, String endColorCode) {
        Color startColorObj = null;
        Color endColorObj = null;
        int startColor = 0xFFFFFF;
        int endColor = 0xFFFFFF;
        if (!StringUtils.isNullOrEmpty(startColorCode)) {
            if (startColorCode.startsWith("#")) {
                startColorObj = StringUtils.getColorFromHex(startColorCode);
                endColorObj = !StringUtils.isNullOrEmpty(endColorCode) && endColorCode.startsWith("#") ? StringUtils.getColorFromHex(endColorCode) : startColorObj;
            } else {
                Pair<Boolean, Integer> startColorData = StringUtils.getValidInteger(startColorCode);
                Pair<Boolean, Integer> endColorData = StringUtils.getValidInteger(endColorCode);
                if (startColorData.getFirst().booleanValue() || endColorData.getFirst().booleanValue()) {
                    startColor = startColorData.getFirst() != false ? startColorData.getSecond() : endColor;
                    endColor = endColorData.getFirst() != false ? endColorData.getSecond() : startColor;
                }
            }
        }
        int startColorInstance = startColorObj != null ? startColorObj.getRGB() : startColor;
        int endColorInstance = endColorObj != null ? endColorObj.getRGB() : endColor;
        float startAlpha = (float)(startColorInstance >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColorInstance >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColorInstance >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColorInstance & 0xFF) / 255.0f;
        float endAlpha = (float)(endColorInstance >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColorInstance >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColorInstance >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColorInstance & 0xFF) / 255.0f;
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(right, top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b(left, top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b(left, bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b(right, bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public void drawContinuousTexturedBox(Pair<Integer, Integer> positionData, Pair<Integer, Integer> uVLevels, Pair<Integer, Integer> screenDimensions, Pair<Integer, Integer> textureDimensions, Pair<Integer, Integer> verticalBorderData, Pair<Integer, Integer> sideBorderData, double zLevel, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = positionData.getFirst();
        int y = positionData.getSecond();
        int u = uVLevels.getFirst();
        int v = uVLevels.getSecond();
        int width = screenDimensions.getFirst();
        int height = screenDimensions.getSecond();
        int textureWidth = textureDimensions.getFirst();
        int textureHeight = textureDimensions.getSecond();
        int topBorder = verticalBorderData.getFirst();
        int bottomBorder = verticalBorderData.getSecond();
        int leftBorder = sideBorderData.getFirst();
        int rightBorder = sideBorderData.getSecond();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        this.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        this.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        this.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        this.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            this.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            this.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }
}

