/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TileEntityUtils {
    private final List<String> BLOCK_NAMES = Lists.newArrayList();
    private final List<String> BLOCK_CLASSES = Lists.newArrayList();
    private final List<String> ITEM_NAMES = Lists.newArrayList();
    private final List<String> ITEM_CLASSES = Lists.newArrayList();
    private final List<String> TILE_ENTITY_CLASSES = Lists.newArrayList();
    private final Item EMPTY_ITEM = null;
    private final ItemStack EMPTY_STACK = new ItemStack(this.EMPTY_ITEM);
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> TILE_ENTITY_NAMES = Lists.newArrayList();
    public Map<String, ResourceLocation> TILE_ENTITY_RESOURCES = Maps.newHashMap();
    public List<String> CURRENT_MAIN_HAND_ITEM_TAGS = Lists.newArrayList();
    public List<String> CURRENT_OFFHAND_ITEM_TAGS = Lists.newArrayList();
    public List<String> CURRENT_HELMET_TAGS = Lists.newArrayList();
    public List<String> CURRENT_CHEST_TAGS = Lists.newArrayList();
    public List<String> CURRENT_LEGS_TAGS = Lists.newArrayList();
    public List<String> CURRENT_BOOTS_TAGS = Lists.newArrayList();
    private ItemStack CURRENT_MAIN_HAND_ITEM;
    private ItemStack CURRENT_OFFHAND_ITEM;
    private ItemStack CURRENT_HELMET;
    private ItemStack CURRENT_CHEST;
    private ItemStack CURRENT_LEGS;
    private ItemStack CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_OFFHAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;
    private NBTTagCompound CURRENT_MAIN_HAND_ITEM_TAG;
    private NBTTagCompound CURRENT_OFFHAND_ITEM_TAG;
    private NBTTagCompound CURRENT_HELMET_TAG;
    private NBTTagCompound CURRENT_CHEST_TAG;
    private NBTTagCompound CURRENT_LEGS_TAG;
    private NBTTagCompound CURRENT_BOOTS_TAG;
    private boolean allItemsEmpty = false;
    private boolean currentlyCleared = true;

    private void emptyData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_MAIN_HAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_OFFHAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_OFFHAND_ITEM_NAME = null;
        this.CURRENT_HELMET = this.EMPTY_STACK;
        this.CURRENT_CHEST = this.EMPTY_STACK;
        this.CURRENT_LEGS = this.EMPTY_STACK;
        this.CURRENT_BOOTS = this.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.CURRENT_MAIN_HAND_ITEM_TAG = null;
        this.CURRENT_OFFHAND_ITEM_TAG = null;
        this.CURRENT_HELMET_TAG = null;
        this.CURRENT_CHEST_TAG = null;
        this.CURRENT_LEGS_TAG = null;
        this.CURRENT_BOOTS_TAG = null;
        this.CURRENT_MAIN_HAND_ITEM_TAGS.clear();
        this.CURRENT_OFFHAND_ITEM_TAGS.clear();
        this.CURRENT_HELMET_TAGS.clear();
        this.CURRENT_CHEST_TAGS.clear();
        this.CURRENT_LEGS_TAGS.clear();
        this.CURRENT_BOOTS_TAGS.clear();
        this.allItemsEmpty = true;
        this.isInUse = false;
        this.currentlyCleared = true;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerItem : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.TILE_ENTITY_NAMES.isEmpty() || this.TILE_ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private boolean isEmpty(Item item) {
        return item == null || this.isEmpty(this.getDefaultInstance(item));
    }

    private boolean isEmpty(Block block) {
        return block == null || this.isEmpty(Item.func_150898_a((Block)block));
    }

    private ItemStack getDefaultInstance(Item itemIn) {
        return new ItemStack(itemIn);
    }

    private boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null || itemStack.equals(this.EMPTY_STACK)) {
            return true;
        }
        if (itemStack.func_77973_b() != this.EMPTY_ITEM && itemStack.func_77973_b() != Items.field_190931_a) {
            if (itemStack.func_190916_E() <= 0) {
                return true;
            }
            return itemStack.func_77952_i() < Short.MIN_VALUE || itemStack.func_77952_i() > 65535;
        }
        return true;
    }

    private void updateEntityData() {
        boolean hasBootsChanged;
        ItemStack NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.func_184614_ca();
        ItemStack NEW_CURRENT_OFFHAND_ITEM = CraftPresence.player.func_184592_cb();
        ItemStack NEW_CURRENT_HELMET = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(3);
        ItemStack NEW_CURRENT_CHEST = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(2);
        ItemStack NEW_CURRENT_LEGS = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(1);
        ItemStack NEW_CURRENT_BOOTS = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(0);
        String NEW_CURRENT_MAIN_HAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_MAIN_HAND_ITEM.func_82833_r()) : "";
        String NEW_CURRENT_OFFHAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_OFFHAND_ITEM.func_82833_r()) : "";
        String NEW_CURRENT_HELMET_NAME = !this.isEmpty(NEW_CURRENT_HELMET) ? StringUtils.stripColors(NEW_CURRENT_HELMET.func_82833_r()) : "";
        String NEW_CURRENT_CHEST_NAME = !this.isEmpty(NEW_CURRENT_CHEST) ? StringUtils.stripColors(NEW_CURRENT_CHEST.func_82833_r()) : "";
        String NEW_CURRENT_LEGS_NAME = !this.isEmpty(NEW_CURRENT_LEGS) ? StringUtils.stripColors(NEW_CURRENT_LEGS.func_82833_r()) : "";
        String NEW_CURRENT_BOOTS_NAME = !this.isEmpty(NEW_CURRENT_BOOTS) ? StringUtils.stripColors(NEW_CURRENT_BOOTS.func_82833_r()) : "";
        boolean hasMainHandChanged = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !NEW_CURRENT_MAIN_HAND_ITEM.equals(this.CURRENT_MAIN_HAND_ITEM) || !NEW_CURRENT_MAIN_HAND_ITEM_NAME.equals(this.CURRENT_MAIN_HAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM);
        boolean hasOffHandChanged = !this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) && !NEW_CURRENT_OFFHAND_ITEM.equals(this.CURRENT_OFFHAND_ITEM) || !NEW_CURRENT_OFFHAND_ITEM_NAME.equals(this.CURRENT_OFFHAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) && !this.isEmpty(this.CURRENT_OFFHAND_ITEM);
        boolean hasHelmetChanged = !this.isEmpty(NEW_CURRENT_HELMET) && !NEW_CURRENT_HELMET.equals(this.CURRENT_HELMET) || !NEW_CURRENT_HELMET_NAME.equals(this.CURRENT_HELMET_NAME) || this.isEmpty(NEW_CURRENT_HELMET) && !this.isEmpty(this.CURRENT_HELMET);
        boolean hasChestChanged = !this.isEmpty(NEW_CURRENT_CHEST) && !NEW_CURRENT_CHEST.equals(this.CURRENT_CHEST) || !NEW_CURRENT_CHEST_NAME.equals(this.CURRENT_CHEST_NAME) || this.isEmpty(NEW_CURRENT_CHEST) && !this.isEmpty(this.CURRENT_CHEST);
        boolean hasLegsChanged = !this.isEmpty(NEW_CURRENT_LEGS) && !NEW_CURRENT_LEGS.equals(this.CURRENT_LEGS) || !NEW_CURRENT_LEGS_NAME.equals(this.CURRENT_LEGS_NAME) || this.isEmpty(NEW_CURRENT_LEGS) && !this.isEmpty(this.CURRENT_LEGS);
        boolean bl = hasBootsChanged = !this.isEmpty(NEW_CURRENT_BOOTS) && !NEW_CURRENT_BOOTS.equals(this.CURRENT_BOOTS) || !NEW_CURRENT_BOOTS_NAME.equals(this.CURRENT_BOOTS_NAME) || this.isEmpty(NEW_CURRENT_BOOTS) && !this.isEmpty(this.CURRENT_BOOTS);
        if (hasMainHandChanged) {
            ArrayList NEW_CURRENT_MAIN_HAND_ITEM_TAGS;
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_TAG = !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM) ? this.CURRENT_MAIN_HAND_ITEM.func_77955_b(new NBTTagCompound()) : null;
            ArrayList arrayList = NEW_CURRENT_MAIN_HAND_ITEM_TAGS = this.CURRENT_MAIN_HAND_ITEM_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_MAIN_HAND_ITEM_TAG.func_150296_c()) : Lists.newArrayList();
            if (!NEW_CURRENT_MAIN_HAND_ITEM_TAGS.equals(this.CURRENT_MAIN_HAND_ITEM_TAGS)) {
                this.CURRENT_MAIN_HAND_ITEM_TAGS = NEW_CURRENT_MAIN_HAND_ITEM_TAGS;
            }
            this.CURRENT_MAIN_HAND_ITEM_NAME = NEW_CURRENT_MAIN_HAND_ITEM_NAME;
        }
        if (hasOffHandChanged) {
            ArrayList NEW_CURRENT_OFFHAND_ITEM_TAGS;
            this.CURRENT_OFFHAND_ITEM = NEW_CURRENT_OFFHAND_ITEM;
            this.CURRENT_OFFHAND_ITEM_TAG = !this.isEmpty(this.CURRENT_OFFHAND_ITEM) ? this.CURRENT_OFFHAND_ITEM.func_77955_b(new NBTTagCompound()) : null;
            ArrayList arrayList = NEW_CURRENT_OFFHAND_ITEM_TAGS = this.CURRENT_OFFHAND_ITEM_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_OFFHAND_ITEM_TAG.func_150296_c()) : Lists.newArrayList();
            if (!NEW_CURRENT_OFFHAND_ITEM_TAGS.equals(this.CURRENT_OFFHAND_ITEM_TAGS)) {
                this.CURRENT_OFFHAND_ITEM_TAGS = NEW_CURRENT_OFFHAND_ITEM_TAGS;
            }
            this.CURRENT_OFFHAND_ITEM_NAME = NEW_CURRENT_OFFHAND_ITEM_NAME;
        }
        if (hasHelmetChanged) {
            ArrayList NEW_CURRENT_HELMET_TAGS;
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_TAG = !this.isEmpty(this.CURRENT_HELMET) ? this.CURRENT_HELMET.func_77955_b(new NBTTagCompound()) : null;
            ArrayList arrayList = NEW_CURRENT_HELMET_TAGS = this.CURRENT_HELMET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_HELMET_TAG.func_150296_c()) : Lists.newArrayList();
            if (!NEW_CURRENT_HELMET_TAGS.equals(this.CURRENT_HELMET_TAGS)) {
                this.CURRENT_HELMET_TAGS = NEW_CURRENT_HELMET_TAGS;
            }
            this.CURRENT_HELMET_NAME = NEW_CURRENT_HELMET_NAME;
        }
        if (hasChestChanged) {
            ArrayList NEW_CURRENT_CHEST_TAGS;
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_TAG = !this.isEmpty(this.CURRENT_CHEST) ? this.CURRENT_CHEST.func_77955_b(new NBTTagCompound()) : null;
            ArrayList arrayList = NEW_CURRENT_CHEST_TAGS = this.CURRENT_CHEST_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_CHEST_TAG.func_150296_c()) : Lists.newArrayList();
            if (!NEW_CURRENT_CHEST_TAGS.equals(this.CURRENT_CHEST_TAGS)) {
                this.CURRENT_CHEST_TAGS = NEW_CURRENT_CHEST_TAGS;
            }
            this.CURRENT_CHEST_NAME = NEW_CURRENT_CHEST_NAME;
        }
        if (hasLegsChanged) {
            ArrayList NEW_CURRENT_LEGS_TAGS;
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_TAG = !this.isEmpty(this.CURRENT_LEGS) ? this.CURRENT_LEGS.func_77955_b(new NBTTagCompound()) : null;
            ArrayList arrayList = NEW_CURRENT_LEGS_TAGS = this.CURRENT_LEGS_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_LEGS_TAG.func_150296_c()) : Lists.newArrayList();
            if (!NEW_CURRENT_LEGS_TAGS.equals(this.CURRENT_LEGS_TAGS)) {
                this.CURRENT_LEGS_TAGS = NEW_CURRENT_LEGS_TAGS;
            }
            this.CURRENT_LEGS_NAME = NEW_CURRENT_LEGS_NAME;
        }
        if (hasBootsChanged) {
            ArrayList NEW_CURRENT_BOOTS_TAGS;
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_TAG = !this.isEmpty(this.CURRENT_BOOTS) ? this.CURRENT_BOOTS.func_77955_b(new NBTTagCompound()) : null;
            ArrayList arrayList = NEW_CURRENT_BOOTS_TAGS = this.CURRENT_BOOTS_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_BOOTS_TAG.func_150296_c()) : Lists.newArrayList();
            if (!NEW_CURRENT_BOOTS_TAGS.equals(this.CURRENT_BOOTS_TAGS)) {
                this.CURRENT_BOOTS_TAGS = NEW_CURRENT_BOOTS_TAGS;
            }
            this.CURRENT_BOOTS_NAME = NEW_CURRENT_BOOTS_NAME;
        }
        if (hasMainHandChanged || hasOffHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.allItemsEmpty = this.isEmpty(this.CURRENT_MAIN_HAND_ITEM) && this.isEmpty(this.CURRENT_OFFHAND_ITEM) && this.isEmpty(this.CURRENT_HELMET) && this.isEmpty(this.CURRENT_CHEST) && this.isEmpty(this.CURRENT_LEGS) && this.isEmpty(this.CURRENT_BOOTS);
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String placeholderItemMessage = CraftPresence.CONFIG.playerItemsPlaceholderMessage;
        String offHandItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_OFFHAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_OFFHAND_ITEM_NAME);
        String mainItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_MAIN_HAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultItemMessage);
        String helmetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_HELMET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_HELMET_NAME);
        String chestMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_CHEST_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_CHEST_NAME);
        String legsMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_LEGS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_LEGS_NAME);
        String bootsMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_BOOTS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BOOTS_NAME);
        ArrayList tileEntityArgs = Lists.newArrayList();
        if (!this.CURRENT_MAIN_HAND_ITEM_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_MAIN_HAND_ITEM_TAGS) {
                mainItemMessage = StringUtils.replaceAnyCase(mainItemMessage, "&" + tagName + "&", this.CURRENT_MAIN_HAND_ITEM_TAG.func_74781_a(tagName).toString());
            }
        }
        if (!this.CURRENT_OFFHAND_ITEM_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_OFFHAND_ITEM_TAGS) {
                offHandItemMessage = StringUtils.replaceAnyCase(offHandItemMessage, "&" + tagName + "&", this.CURRENT_OFFHAND_ITEM_TAG.func_74781_a(tagName).toString());
            }
        }
        if (!this.CURRENT_HELMET_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_HELMET_TAGS) {
                helmetMessage = StringUtils.replaceAnyCase(helmetMessage, "&" + tagName + "&", this.CURRENT_HELMET_TAG.func_74781_a(tagName).toString());
            }
        }
        if (!this.CURRENT_CHEST_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_CHEST_TAGS) {
                chestMessage = StringUtils.replaceAnyCase(chestMessage, "&" + tagName + "&", this.CURRENT_CHEST_TAG.func_74781_a(tagName).toString());
            }
        }
        if (!this.CURRENT_LEGS_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_LEGS_TAGS) {
                legsMessage = StringUtils.replaceAnyCase(legsMessage, "&" + tagName + "&", this.CURRENT_LEGS_TAG.func_74781_a(tagName).toString());
            }
        }
        if (!this.CURRENT_BOOTS_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_BOOTS_TAGS) {
                bootsMessage = StringUtils.replaceAnyCase(bootsMessage, "&" + tagName + "&", this.CURRENT_BOOTS_TAG.func_74781_a(tagName).toString());
            }
        }
        tileEntityArgs.add(new Pair<String, String>("&MAIN&", !StringUtils.isNullOrEmpty(this.CURRENT_MAIN_HAND_ITEM_NAME) ? StringUtils.replaceAnyCase(mainItemMessage, "&item&", this.CURRENT_MAIN_HAND_ITEM_NAME) : ""));
        tileEntityArgs.add(new Pair<String, String>("&OFFHAND&", !StringUtils.isNullOrEmpty(this.CURRENT_OFFHAND_ITEM_NAME) ? StringUtils.replaceAnyCase(offHandItemMessage, "&item&", this.CURRENT_OFFHAND_ITEM_NAME) : ""));
        tileEntityArgs.add(new Pair<String, String>("&HELMET&", !StringUtils.isNullOrEmpty(this.CURRENT_HELMET_NAME) ? StringUtils.replaceAnyCase(helmetMessage, "&item&", this.CURRENT_HELMET_NAME) : ""));
        tileEntityArgs.add(new Pair<String, String>("&CHEST&", !StringUtils.isNullOrEmpty(this.CURRENT_CHEST_NAME) ? StringUtils.replaceAnyCase(chestMessage, "&item&", this.CURRENT_CHEST_NAME) : ""));
        tileEntityArgs.add(new Pair<String, String>("&LEGS&", !StringUtils.isNullOrEmpty(this.CURRENT_LEGS_NAME) ? StringUtils.replaceAnyCase(legsMessage, "&item&", this.CURRENT_LEGS_NAME) : ""));
        tileEntityArgs.add(new Pair<String, String>("&BOOTS&", !StringUtils.isNullOrEmpty(this.CURRENT_BOOTS_NAME) ? StringUtils.replaceAnyCase(bootsMessage, "&item&", this.CURRENT_BOOTS_NAME) : ""));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            tileEntityArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_MESSAGE = StringUtils.sequentialReplaceAnyCase(placeholderItemMessage, tileEntityArgs);
        if (!this.allItemsEmpty) {
            CraftPresence.CLIENT.syncArgument("&TILEENTITY&", CURRENT_MESSAGE, false);
        } else if (!this.currentlyCleared) {
            CraftPresence.CLIENT.initArgument("&TILEENTITY&");
        }
    }

    public List<String> getListFromName(String name) {
        return name.equalsIgnoreCase(this.CURRENT_MAIN_HAND_ITEM_NAME) ? this.CURRENT_MAIN_HAND_ITEM_TAGS : (name.equalsIgnoreCase(this.CURRENT_OFFHAND_ITEM_NAME) ? this.CURRENT_OFFHAND_ITEM_TAGS : (name.equalsIgnoreCase(this.CURRENT_HELMET_NAME) ? this.CURRENT_HELMET_TAGS : (name.equalsIgnoreCase(this.CURRENT_CHEST_NAME) ? this.CURRENT_CHEST_TAGS : (name.equalsIgnoreCase(this.CURRENT_LEGS_NAME) ? this.CURRENT_LEGS_TAGS : (name.equalsIgnoreCase(this.CURRENT_BOOTS_NAME) ? this.CURRENT_BOOTS_TAGS : Lists.newArrayList())))));
    }

    public String generatePlaceholderString(String name, boolean addExtraData, List<String> tags) {
        StringBuilder finalString = new StringBuilder();
        if (!tags.isEmpty()) {
            for (String tagName : tags) {
                String tagValue;
                finalString.append("\n - &").append(tagName).append("&");
                if (!addExtraData || StringUtils.isNullOrEmpty(tagValue = tags.equals(this.CURRENT_MAIN_HAND_ITEM_TAGS) ? this.CURRENT_MAIN_HAND_ITEM_TAG.func_74781_a(tagName).toString() : (tags.equals(this.CURRENT_OFFHAND_ITEM_TAGS) ? this.CURRENT_OFFHAND_ITEM_TAG.func_74781_a(tagName).toString() : (tags.equals(this.CURRENT_HELMET_TAGS) ? this.CURRENT_HELMET_TAG.func_74781_a(tagName).toString() : (tags.equals(this.CURRENT_CHEST_TAGS) ? this.CURRENT_CHEST_TAG.func_74781_a(tagName).toString() : (tags.equals(this.CURRENT_LEGS_TAGS) ? this.CURRENT_LEGS_TAG.func_74781_a(tagName).toString() : (tags.equals(this.CURRENT_BOOTS_TAGS) ? this.CURRENT_BOOTS_TAG.func_74781_a(tagName).toString() : null))))))) continue;
                finalString.append(" (Value -> ").append(tagValue).append(")");
            }
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        ResourceLocation initialData;
        for (Block block : Block.field_149771_c) {
            if (this.isEmpty(block)) continue;
            if (!this.BLOCK_NAMES.contains(block.func_149732_F())) {
                this.BLOCK_NAMES.add(block.func_149732_F());
            }
            if (!this.BLOCK_CLASSES.contains(block.getClass().getName())) {
                this.BLOCK_CLASSES.add(block.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(block.func_149732_F())) continue;
            initialData = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
            this.TILE_ENTITY_RESOURCES.put(block.func_149732_F(), new ResourceLocation(initialData.func_110624_b(), (ModUtils.MCProtocolID > 340 ? "textures/block/" : "textures/blocks/") + initialData.func_110623_a() + ".png"));
        }
        for (Item item : Item.field_150901_e) {
            if (this.isEmpty(item)) continue;
            if (!this.ITEM_NAMES.contains(item.func_77653_i(this.getDefaultInstance(item)))) {
                this.ITEM_NAMES.add(item.func_77653_i(this.getDefaultInstance(item)));
            }
            if (!this.ITEM_CLASSES.contains(item.getClass().getName())) {
                this.ITEM_CLASSES.add(item.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(item.func_77653_i(this.getDefaultInstance(item)))) continue;
            initialData = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
            this.TILE_ENTITY_RESOURCES.put(item.func_77653_i(this.getDefaultInstance(item)), new ResourceLocation(initialData.func_110624_b(), (ModUtils.MCProtocolID > 340 ? "textures/item/" : "textures/items/") + initialData.func_110623_a() + ".png"));
        }
        for (String itemMessage : CraftPresence.CONFIG.itemMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(itemMessage) || StringUtils.isNullOrEmpty((part = itemMessage.split(CraftPresence.CONFIG.splitCharacter))[0])) continue;
            if (!this.ITEM_NAMES.contains(part[0])) {
                this.ITEM_NAMES.add(part[0]);
            }
            if (this.BLOCK_NAMES.contains(part[0])) continue;
            this.BLOCK_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
        ArrayList removingBlocks = Lists.newArrayList();
        ArrayList removingItems = Lists.newArrayList();
        for (String itemName : this.ITEM_NAMES) {
            String lowerItemName;
            if (StringUtils.isNullOrEmpty(itemName) || !(lowerItemName = itemName.toLowerCase()).contains("tile.") && !lowerItemName.contains("item.") && !lowerItemName.contains(".") && !lowerItemName.contains(".name")) continue;
            removingItems.add(itemName);
        }
        for (String blockName : this.BLOCK_NAMES) {
            String lowerBlockName;
            if (StringUtils.isNullOrEmpty(blockName) || !(lowerBlockName = blockName.toLowerCase()).contains("tile.") && !lowerBlockName.contains("item.") && !lowerBlockName.contains(".") && !lowerBlockName.contains(".name")) continue;
            removingBlocks.add(blockName);
        }
        this.ITEM_NAMES.removeAll(removingItems);
        this.ITEM_NAMES.removeAll(this.BLOCK_NAMES);
        this.BLOCK_NAMES.removeAll(this.ITEM_NAMES);
        this.BLOCK_NAMES.removeAll(removingBlocks);
        this.TILE_ENTITY_NAMES.addAll(this.BLOCK_NAMES);
        this.TILE_ENTITY_NAMES.addAll(this.ITEM_NAMES);
        this.TILE_ENTITY_CLASSES.addAll(this.BLOCK_CLASSES);
        this.TILE_ENTITY_CLASSES.addAll(this.ITEM_CLASSES);
    }
}

