/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.lwjgl.input.Keyboard;

public class KeyUtils {
    private final List<Integer> invalidKeys = Lists.newArrayList((Object[])new Integer[]{1, 256});

    public boolean isValidKeyCode(int sourceKeyCode) {
        return !this.invalidKeys.contains(sourceKeyCode);
    }

    public String getKeyName(String original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue()) {
                return this.getKeyName(integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    public String getKeyName(int original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (this.isValidKeyCode(original)) {
            if (ModUtils.MCProtocolID <= 340 && KeyConverter.toGlfw.containsKey(original)) {
                return KeyConverter.toGlfw.get(original).getSecond();
            }
            if (ModUtils.MCProtocolID > 340 && KeyConverter.fromGlfw.containsKey(original)) {
                return KeyConverter.fromGlfw.get(original).getSecond();
            }
            String keyName = Keyboard.getKeyName((int)original);
            if (!StringUtils.isNullOrEmpty(keyName)) {
                return keyName;
            }
            return Integer.toString(original);
        }
        return unknownKeyName;
    }

    void onTick() {
        if (Keyboard.isCreated() && CraftPresence.CONFIG != null) {
            try {
                if (this.isValidKeyCode(CraftPresence.CONFIG.configKeyCode) && Keyboard.isKeyDown((int)CraftPresence.CONFIG.configKeyCode) && !CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.openConfigGUI && !CraftPresence.GUIS.configGUIOpened) {
                    CraftPresence.GUIS.openConfigGUI = true;
                }
            }
            catch (Error | Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keycode", CraftPresence.CONFIG.NAME_configKeyCode.replaceAll("_", " ")), new Object[0]);
                CraftPresence.CONFIG.configKeyCode = ModUtils.MCProtocolID > 340 ? 96 : 41;
                CraftPresence.CONFIG.updateConfig(false);
            }
        }
    }
}

