/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.plug;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.client.model.key.KeyPlugLens;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class PluggableLens
extends PipePluggable {
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[6];
    public final EnumDyeColor colour;
    public final boolean isFilter;

    public PluggableLens(PluggableDefinition def, IPipeHolder holder, EnumFacing side, EnumDyeColor colour, boolean isFilter) {
        super(def, holder, side);
        this.colour = colour;
        this.isFilter = isFilter;
    }

    public PluggableLens(PluggableDefinition def, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        super(def, holder, side);
        this.colour = nbt.func_74764_b("colour") ? NBTUtilBC.readEnum(nbt.func_74781_a("colour"), EnumDyeColor.class) : EnumDyeColor.func_176764_b((int)nbt.func_74771_c("c"));
        this.isFilter = nbt.func_74767_n("f");
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("colour", NBTUtilBC.writeEnum(this.colour));
        nbt.func_74757_a("f", this.isFilter);
        return nbt;
    }

    public PluggableLens(PluggableDefinition def, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        super(def, holder, side);
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        this.colour = MessageUtil.readEnumOrNull((ByteBuf)buf, EnumDyeColor.class);
        this.isFilter = buf.readBoolean();
    }

    @Override
    public void writeCreationPayload(PacketBuffer buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        MessageUtil.writeEnumOrNull((ByteBuf)buf, this.colour);
        buf.writeBoolean(this.isFilter);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return BOXES[this.side.func_176745_a()];
    }

    @Override
    public ItemStack getPickStack() {
        return BCSiliconItems.plugLens.getStack(this.colour, this.isFilter);
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        switch (layer) {
            case CUTOUT: 
            case TRANSLUCENT: {
                return new KeyPlugLens(layer, this.side, this.colour, this.isFilter);
            }
        }
        return null;
    }

    @PipeEventHandler
    public void tryInsert(PipeEventItem.TryInsert tryInsert) {
        EnumDyeColor itemColour;
        if (this.isFilter && tryInsert.from == this.side && (itemColour = tryInsert.colour) != null && itemColour != this.colour) {
            tryInsert.cancel();
        }
    }

    @PipeEventHandler
    public void sideCheck(PipeEventItem.SideCheck event) {
        if (this.isFilter) {
            if (event.colour == this.colour) {
                event.increasePriority(this.side);
            } else if (event.colour != null) {
                event.disallow(this.side);
            } else {
                event.decreasePriority(this.side);
            }
        }
    }

    void sideCheckAnyPos(PipeEventItem.SideCheck event, EnumFacing compareSide) {
        if (this.isFilter) {
            if (event.colour == this.colour) {
                event.increasePriority(compareSide);
            } else if (event.colour != null) {
                if (compareSide == this.side) {
                    event.disallow(compareSide);
                }
            } else {
                event.decreasePriority(compareSide);
            }
        }
    }

    @PipeEventHandler
    public void beforeInsert(PipeEventItem.OnInsert event) {
        if (!this.isFilter && event.from == this.side) {
            event.colour = this.colour;
        }
    }

    @PipeEventHandler
    public void reachEnd(PipeEventItem.ReachEnd event) {
        if (!this.isFilter && event.to == this.side) {
            event.colour = this.colour;
        }
    }

    static {
        double ll = 0.0;
        double lu = 0.125;
        double ul = 0.875;
        double uu = 1.0;
        double min = 0.1875;
        double max = 0.8125;
        PluggableLens.BOXES[EnumFacing.DOWN.func_176745_a()] = new AxisAlignedBB(min, ll, min, max, lu, max);
        PluggableLens.BOXES[EnumFacing.UP.func_176745_a()] = new AxisAlignedBB(min, ul, min, max, uu, max);
        PluggableLens.BOXES[EnumFacing.NORTH.func_176745_a()] = new AxisAlignedBB(min, min, ll, max, max, lu);
        PluggableLens.BOXES[EnumFacing.SOUTH.func_176745_a()] = new AxisAlignedBB(min, min, ul, max, max, uu);
        PluggableLens.BOXES[EnumFacing.WEST.func_176745_a()] = new AxisAlignedBB(ll, min, min, lu, max, max);
        PluggableLens.BOXES[EnumFacing.EAST.func_176745_a()] = new AxisAlignedBB(ul, min, min, uu, max, max);
    }
}

