/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit;

import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduit;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import javax.annotation.Nonnull;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;

public class AbstractGasTankConduitNetwork<T extends AbstractGasTankConduit>
extends AbstractConduitNetwork<IGasConduit, T> {
    protected GasStack gasType;
    protected boolean gasTypeLocked = false;

    protected AbstractGasTankConduitNetwork(@Nonnull Class<T> cl) {
        super(cl, IGasConduit.class);
    }

    public GasStack getGasType() {
        return this.gasType;
    }

    public void addConduit(@Nonnull T con) {
        super.addConduit(con);
        ((AbstractGasTankConduit)con).setGasType(this.gasType);
        if (((AbstractGasTankConduit)con).gasTypeLocked && !this.gasTypeLocked) {
            this.setGasTypeLocked(true);
        }
    }

    public boolean setGasType(GasStack newType) {
        if (this.gasType != null && this.gasType.isGasEqual(newType)) {
            return false;
        }
        if (newType != null) {
            this.gasType = newType.copy();
            this.gasType.amount = 0;
        } else {
            this.gasType = null;
        }
        this.getConduits().forEach(conduit -> conduit.setGasType(this.gasType));
        return true;
    }

    public void setGasTypeLocked(boolean gasTypeLocked) {
        if (this.gasTypeLocked == gasTypeLocked) {
            return;
        }
        this.gasTypeLocked = gasTypeLocked;
        this.getConduits().forEach(conduit -> conduit.setGasTypeLocked(gasTypeLocked));
    }

    public boolean canAcceptGas(GasStack acceptable) {
        return AbstractGasTankConduitNetwork.areGasesCompatible(this.gasType, acceptable);
    }

    public static boolean areGasesCompatible(GasStack a, GasStack b) {
        return a == null || b == null || a.isGasEqual(b);
    }

    public static boolean areGasesCompatible(Gas a, Gas b) {
        return a == null || b == null || a == b;
    }

    public static boolean areGasesCompatible(GasStack a, Gas b) {
        return a == null || AbstractGasTankConduitNetwork.areGasesCompatible(a.getGas(), b);
    }

    public int getTotalVolume() {
        int totalVolume = 0;
        for (AbstractGasTankConduit con : this.getConduits()) {
            totalVolume += con.getTank().getStored();
        }
        return totalVolume;
    }
}

