/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.json;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeApplier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.world.biome.Biome;

public class JsonBiomePropertyApplierSpecies
implements IJsonBiomeApplier {
    @Override
    public void apply(BiomeDataBase dbase, JsonElement element, Biome biome) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            dbase.setSpeciesSelector(biome, this.readSpeciesSelector(object), this.readMethod(object));
        } else if (element.isJsonPrimitive()) {
            dbase.setSpeciesSelector(biome, this.createStaticSpeciesSelector(element.getAsString()), BiomeDataBase.Operation.REPLACE);
        }
    }

    private BiomePropertySelectors.ISpeciesSelector createStaticSpeciesSelector(String speciesName) {
        if (this.isDefault(speciesName)) {
            return new BiomePropertySelectors.StaticSpeciesSelector();
        }
        Species species = TreeRegistry.findSpeciesSloppy(speciesName);
        if (species != Species.NULLSPECIES) {
            return new BiomePropertySelectors.StaticSpeciesSelector(new BiomePropertySelectors.SpeciesSelection(species));
        }
        return null;
    }

    private BiomePropertySelectors.ISpeciesSelector readSpeciesSelector(JsonObject mainObject) {
        JsonElement staticElement = mainObject.get("static");
        if (staticElement != null && staticElement.isJsonPrimitive()) {
            return this.createStaticSpeciesSelector(staticElement.getAsString());
        }
        JsonElement randomElement = mainObject.get("random");
        if (randomElement != null && randomElement.isJsonObject()) {
            BiomePropertySelectors.RandomSpeciesSelector rand = new BiomePropertySelectors.RandomSpeciesSelector();
            for (Map.Entry entry : randomElement.getAsJsonObject().entrySet()) {
                String speciesName = (String)entry.getKey();
                JsonElement speciesElement = (JsonElement)entry.getValue();
                int weight = 0;
                if (!speciesElement.isJsonPrimitive() || !speciesElement.getAsJsonPrimitive().isNumber() || (weight = speciesElement.getAsJsonPrimitive().getAsInt()) <= 0) continue;
                if (this.isDefault(speciesName)) {
                    rand.add(weight);
                    continue;
                }
                Species species = TreeRegistry.findSpeciesSloppy(speciesName);
                if (species == Species.NULLSPECIES) continue;
                rand.add(species, weight);
            }
            if (rand.getSize() > 0) {
                return rand;
            }
        }
        return null;
    }
}

