/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkTreeHelper {
    public static void removeOrphanedBranchNodes(World world, ChunkPos cPos, int radius) {
        if (cPos == null) {
            return;
        }
        Chunk chunk = world.func_72964_e(cPos.field_77276_a, cPos.field_77275_b);
        BlockBounds bounds = new BlockBounds(cPos);
        bounds.shrink(EnumFacing.UP, 255 - (chunk.func_76625_h() + 16));
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            bounds.expand(dir, radius * 16);
        }
        HashSet found = new HashSet();
        for (BlockPos.MutableBlockPos pos : bounds.iterate()) {
            EnumFacing trunkDir;
            BlockPos trunkPos;
            IBlockState trunkState;
            Optional<BlockBranch> trunk;
            IBlockState state;
            Optional<BlockBranch> branchBlock;
            if (found.contains(pos) || !(branchBlock = TreeHelper.getBranchOpt(state = world.func_180495_p((BlockPos)pos))).isPresent()) continue;
            BlockPos rootPos = TreeHelper.findRootNode(world, (BlockPos)pos);
            if (rootPos == BlockPos.field_177992_a) {
                BranchDestructionData destroyData = branchBlock.get().destroyBranchFromNode(world, (BlockPos)pos, EnumFacing.DOWN, true);
                EntityFallingTree.dropTree(world, destroyData, new ArrayList<ItemStack>(0), EntityFallingTree.DestroyType.ROOT);
                continue;
            }
            IBlockState rootyState = world.func_180495_p(rootPos);
            Optional<BlockRooty> rootyBlock = TreeHelper.getRootyOpt(rootyState);
            if (!rootyBlock.isPresent() || !(trunk = TreeHelper.getBranchOpt(trunkState = world.func_180495_p(trunkPos = rootPos.func_177972_a(trunkDir = rootyBlock.get().getTrunkDirection((IBlockAccess)world, rootPos))))).isPresent()) continue;
            MapSignal signal = new MapSignal();
            signal.destroyLoopedNodes = false;
            trunk.get().analyse(trunkState, world, trunkPos, null, signal);
            if (!signal.multiroot && !signal.overflow) continue;
            BranchDestructionData destroyData = branchBlock.get().destroyBranchFromNode(world, (BlockPos)pos, EnumFacing.DOWN, true);
            EntityFallingTree.dropTree(world, destroyData, new ArrayList<ItemStack>(0), EntityFallingTree.DestroyType.ROOT);
        }
    }

    public static void removeAllBranchesFromChunk(World world, ChunkPos cPos, int radius) {
        if (cPos == null) {
            return;
        }
        Chunk chunk = world.func_72964_e(cPos.field_77276_a, cPos.field_77275_b);
        BlockBounds bounds = new BlockBounds(cPos);
        bounds.shrink(EnumFacing.UP, 255 - (chunk.func_76625_h() + 16));
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            bounds.expand(dir, radius * 16);
        }
        for (BlockPos.MutableBlockPos pos : bounds.iterate()) {
            IBlockState state = world.func_180495_p((BlockPos)pos);
            Optional<BlockBranch> branchBlock = TreeHelper.getBranchOpt(state);
            if (!branchBlock.isPresent()) continue;
            BranchDestructionData destroyData = branchBlock.get().destroyBranchFromNode(world, (BlockPos)pos, EnumFacing.DOWN, true);
            EntityFallingTree.dropTree(world, destroyData, new ArrayList<ItemStack>(0), EntityFallingTree.DestroyType.ROOT);
        }
    }
}

