/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchCactus;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreator;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeCactus
extends TreeFamily {
    public TreeCactus() {
        super(new ResourceLocation("dynamictrees", "cactus"));
        this.setPrimitiveLog(Blocks.field_150434_aF.func_176223_P(), new ItemStack((Block)Blocks.field_150434_aF));
        this.setStick(ItemStack.field_190927_a);
    }

    @Override
    public ILeavesProperties getCommonLeaves() {
        return ModBlocks.leaves.get(this.getName().func_110623_a());
    }

    @Override
    public BlockBranch createBranch() {
        String branchName = this.getName() + "branch";
        return new BlockBranchCactus(branchName);
    }

    @Override
    public float getPrimaryThickness() {
        return 5.0f;
    }

    @Override
    public float getSecondaryThickness() {
        return 4.0f;
    }

    @Override
    public void createSpecies() {
        this.setCommonSpecies(new SpeciesCactus((TreeFamily)this));
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        this.getCommonSpecies().generateSeed();
    }

    protected class JoCodeCactus
    extends JoCode {
        public JoCodeCactus(String code) {
            super(code);
        }

        @Override
        public void generate(World world, Species species, BlockPos rootPos, Biome biome, EnumFacing facing, int radius, SafeChunkBounds safeBounds) {
            IBlockState initialDirtState = world.func_180495_p(rootPos);
            species.placeRootyDirtBlock(world, rootPos, 0);
            radius = MathHelper.func_76125_a((int)radius, (int)2, (int)8);
            BlockPos treePos = rootPos.func_177984_a();
            this.setFacing(facing);
            this.generateFork(world, species, 0, rootPos, false);
            BlockBranch branch = TreeHelper.getBranch(world.func_180495_p(treePos));
            if (branch != null) {
                NodeFindEnds endFinder = new NodeFindEnds();
                MapSignal signal = new MapSignal(endFinder);
                branch.analyse(world.func_180495_p(treePos), world, treePos, EnumFacing.DOWN, signal);
                List<BlockPos> endPoints = endFinder.getEnds();
                species.postGeneration(world, rootPos, biome, radius, endPoints, safeBounds, initialDirtState);
                MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(world, species, rootPos, endPoints, safeBounds, initialDirtState));
            } else {
                world.func_180501_a(rootPos, initialDirtState, this.careful ? 3 : 2);
            }
        }

        @Override
        public boolean setBlockForGeneration(World world, Species species, BlockPos pos, EnumFacing dir, boolean careful) {
            IBlockState defaultBranchState = species.getFamily().getDynamicBranch().func_176223_P();
            if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                IBlockState downState;
                boolean trunk = false;
                if (dir == EnumFacing.UP && (TreeHelper.isRooty(downState = world.func_180495_p(pos.func_177977_b())) || downState.func_177230_c() == defaultBranchState.func_177230_c() && ((Boolean)downState.func_177229_b((IProperty)BlockBranchCactus.TRUNK)).booleanValue() && downState.func_177229_b(BlockBranchCactus.ORIGIN) == EnumFacing.DOWN)) {
                    trunk = true;
                }
                return !world.func_180501_a(pos, defaultBranchState.func_177226_a((IProperty)BlockBranchCactus.TRUNK, (Comparable)Boolean.valueOf(trunk)).func_177226_a(BlockBranchCactus.ORIGIN, (Comparable)dir.func_176734_d()), careful ? 3 : 2);
            }
            return true;
        }
    }

    public class SpeciesCactus
    extends Species {
        public SpeciesCactus(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.875f, 4.0f, 4, 2, 1.0f);
            this.setSoilLongevity(1);
            this.addDropCreator(new DropCreator(new ResourceLocation("dynamictrees", "cactusseeds")){

                @Override
                public List<ItemStack> getLogsDrop(World world, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, float volume) {
                    for (int numLogs = (int)(volume / 2.0f); numLogs > 0; numLogs -= 64) {
                        dropList.add(species.getSeedStack(numLogs >= 64 ? 64 : numLogs));
                    }
                    return dropList;
                }
            });
            this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.SANDY, 1.05f);
        }

        @Override
        protected void setStandardSoils() {
            this.addAcceptableSoils("sandlike");
        }

        @Override
        public boolean isTransformable() {
            return false;
        }

        @Override
        public JoCode getJoCode(String joCodeString) {
            return new JoCodeCactus(joCodeString);
        }

        @Override
        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_82737_E() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode(pos.func_177981_b(month), 2) % 3);
        }

        @Override
        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            return ModBlocks.blockRootySand;
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesCactus.isOneOfBiomes(biome, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R);
        }

        @Override
        public boolean handleRot(World world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, SafeChunkBounds safeBounds) {
            return false;
        }

        @Override
        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = signal.delta.func_177958_n() % 2 == 0 || signal.delta.func_177952_p() % 2 == 0 ? this.getUpProbability() : 0;
            probMap[5] = signal.isInTrunk() && signal.energy > 1.0f ? 1 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            if (signal.dir != EnumFacing.UP) {
                probMap[signal.dir.ordinal()] = 0;
            }
            probMap[originDir.ordinal()] = 0;
            return probMap;
        }

        @Override
        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy += 0.0f;
            }
            return newDir;
        }

        @Override
        public boolean applySubstance(World world, BlockPos rootPos, BlockPos hitPos, EntityPlayer player, EnumHand hand, ItemStack itemStack) {
            if (!(this.getSubstanceEffect(itemStack) instanceof SubstanceTransform)) {
                return super.applySubstance(world, rootPos, hitPos, player, hand, itemStack);
            }
            return false;
        }

        @Override
        public boolean canBoneMeal() {
            return false;
        }

        @Override
        public boolean transitionToTree(World world, BlockPos pos) {
            TreeFamily tree = this.getFamily();
            if (world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
                world.func_175656_a(pos, tree.getDynamicBranch().func_176223_P());
                this.placeRootyDirtBlock(world, pos.func_177977_b(), 15);
                return true;
            }
            return false;
        }

        @Override
        public AxisAlignedBB getSaplingBoundingBox() {
            return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625);
        }

        @Override
        public SoundType getSaplingSound() {
            return SoundType.field_185854_g;
        }
    }
}

