/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.IFullGenFeature;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.IPreGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.IEmptiable;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreatorStorage;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.entities.EntityLingeringEffector;
import com.ferreusveritas.dynamictrees.entities.animation.IAnimationHandler;
import com.ferreusveritas.dynamictrees.event.BiomeSuitabilityEvent;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKits;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorLogs;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorStorage;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeDisease;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeInflator;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeShrinker;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceFertilize;
import com.ferreusveritas.dynamictrees.tileentity.TileEntitySpecies;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.Deprecatron;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class Species
extends IForgeRegistryEntry.Impl<Species> {
    public static final Species NULLSPECIES = new Species(){

        @Override
        public Seed getSeed() {
            return Seed.NULLSEED;
        }

        @Override
        public TreeFamily getFamily() {
            return TreeFamily.NULLFAMILY;
        }

        @Override
        public boolean isTransformable() {
            return false;
        }

        @Override
        public void addJoCodes() {
        }

        @Override
        public boolean plantSapling(World world, BlockPos pos) {
            return false;
        }

        @Override
        public boolean generate(World world, BlockPos pos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
            return false;
        }

        @Override
        public float biomeSuitability(World world, BlockPos pos) {
            return 0.0f;
        }

        @Override
        public boolean addDropCreator(IDropCreator dropCreator) {
            return false;
        }

        @Override
        public ItemStack setSeedStack(ItemStack newSeedStack) {
            return new ItemStack((Item)this.getSeed());
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return new ItemStack((Item)this.getSeed());
        }

        @Override
        public Species setupStandardSeedDropping() {
            return this;
        }

        @Override
        public boolean update(World world, BlockRooty rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean rapid) {
            return false;
        }

        @Override
        public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
            return false;
        }
    };
    public static IForgeRegistry<Species> REGISTRY;
    protected final TreeFamily treeFamily;
    protected IGrowthLogicKit logicKit = GrowthLogicKits.nullLogic;
    protected float tapering = 0.3f;
    protected int upProbability = 2;
    protected int lowestBranchHeight = 3;
    protected float signalEnergy = 16.0f;
    protected float growthRate = 1.0f;
    protected int soilLongevity = 8;
    protected int soilTypeFlags = 0;
    private boolean requiresTileEntity = false;
    protected ILeavesProperties leavesProperties;
    protected ItemStack seedStack;
    protected IBlockState saplingBlock;
    protected IDropCreatorStorage dropCreatorStorage = new DropCreatorStorage();
    protected Map<BiomeDictionary.Type, Float> envFactors = new HashMap<BiomeDictionary.Type, Float>();
    protected JoCodeStore joCodeStore = new JoCodeStore(this);
    protected IFullGenFeature genFeatureOverride;
    protected List<IPreGenFeature> preGenFeatures;
    protected List<IPostGenFeature> postGenFeatures;
    protected List<IPostGrowFeature> postGrowFeatures;
    public int saplingModelId;
    private String unlocalizedName = "";
    private static final EnumFacing[] upFirst;
    protected float flowerSeasonHoldMin = 0.0f;
    protected float flowerSeasonHoldMax = 0.5f;

    public static void newRegistry(RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("dynamictrees", "species")).setDefaultKey(new ResourceLocation("dynamictrees", "null")).disableSaving().setType(Species.class).setIDRange(0, 0x7FFFFFFE).create();
    }

    public Species() {
        this.treeFamily = TreeFamily.NULLFAMILY;
        this.leavesProperties = LeavesProperties.NULLPROPERTIES;
    }

    public Species(ResourceLocation name, TreeFamily treeFamily) {
        this(name, treeFamily, treeFamily.getCommonLeaves());
    }

    public Species(ResourceLocation name, TreeFamily treeFamily, ILeavesProperties leavesProperties) {
        this.setRegistryName(name);
        this.setUnlocalizedName(name.toString());
        this.treeFamily = treeFamily;
        this.setLeavesProperties(leavesProperties);
        this.setStandardSoils();
        this.seedStack = new ItemStack((Item)Seed.NULLSEED);
        this.saplingBlock = Blocks.field_150350_a.func_176223_P();
        this.addJoCodes();
        this.addDropCreator(new DropCreatorLogs());
    }

    public boolean isValid() {
        return this != NULLSPECIES;
    }

    public void ifValid(Consumer<Species> c) {
        if (this.isValid()) {
            c.accept(this);
        }
    }

    public TreeFamily getFamily() {
        return this.treeFamily;
    }

    public Species setUnlocalizedName(String name) {
        this.unlocalizedName = name;
        return this;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)(this.getUnlocalizedName() + ".name"));
    }

    public String getUnlocalizedName() {
        return "species." + this.unlocalizedName;
    }

    public Species setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate) {
        this.tapering = tapering;
        this.signalEnergy = energy;
        this.upProbability = upProbability;
        this.lowestBranchHeight = lowestBranchHeight;
        this.growthRate = growthRate;
        return this;
    }

    public float getEnergy(World world, BlockPos rootPos) {
        return this.getGrowthLogicKit().getEnergy(world, rootPos, this, this.signalEnergy);
    }

    public float getGrowthRate(World world, BlockPos rootPos) {
        return this.growthRate * this.seasonalGrowthFactor(world, rootPos);
    }

    public int getUpProbability() {
        return this.upProbability;
    }

    public int getReinfTravel() {
        return 1;
    }

    public int getLowestBranchHeight() {
        return this.lowestBranchHeight;
    }

    public int getLowestBranchHeight(World world, BlockPos pos) {
        return this.getLowestBranchHeight();
    }

    public float getTapering() {
        return this.tapering;
    }

    public boolean getRequiresTileEntity(World world, BlockPos pos) {
        return this.requiresTileEntity;
    }

    public void setRequiresTileEntity(boolean truth) {
        this.requiresTileEntity = truth;
    }

    public boolean isTransformable() {
        return true;
    }

    public Species setLeavesProperties(ILeavesProperties leavesProperties) {
        this.leavesProperties = leavesProperties;
        return this;
    }

    public ILeavesProperties getLeavesProperties() {
        return this.leavesProperties;
    }

    public ItemStack getSeedStack(int qty) {
        if (this.seedStack == null) {
            return null;
        }
        ItemStack stack = this.seedStack.func_77946_l();
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public Seed getSeed() {
        return (Seed)this.seedStack.func_77973_b();
    }

    public Species generateSeed() {
        Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed");
        this.setSeedStack(new ItemStack((Item)seed));
        return this;
    }

    public ItemStack setSeedStack(ItemStack newSeedStack) {
        if (newSeedStack.func_77973_b() instanceof Seed) {
            this.seedStack = newSeedStack;
            Seed seed = (Seed)this.seedStack.func_77973_b();
            seed.setSpecies(this, this.seedStack);
            return this.seedStack;
        }
        System.err.println("setSeedStack must have an ItemStack with an Item that is an instance of a Seed");
        return ItemStack.field_190927_a;
    }

    public Species setupStandardSeedDropping() {
        this.addDropCreator(new DropCreatorSeed());
        return this;
    }

    public boolean addDropCreator(IDropCreator dropCreator) {
        return this.dropCreatorStorage.addDropCreator(dropCreator);
    }

    public boolean remDropCreator(ResourceLocation dropCreatorName) {
        return this.dropCreatorStorage.remDropCreator(dropCreatorName);
    }

    public Map<ResourceLocation, IDropCreator> getDropCreators() {
        return this.dropCreatorStorage.getDropCreators();
    }

    public List<ItemStack> getTreeHarvestDrops(World world, BlockPos leafPos, List<ItemStack> dropList, Random random) {
        dropList = TreeRegistry.globalDropCreatorStorage.getHarvestDrop(world, this, leafPos, random, dropList, 0, 0);
        return this.dropCreatorStorage.getHarvestDrop(world, this, leafPos, random, dropList, 0, 0);
    }

    public List<ItemStack> getVoluntaryDrops(World world, BlockPos rootPos, BlockPos treePos, int soilLife) {
        List<ItemStack> dropList = TreeRegistry.globalDropCreatorStorage.getVoluntaryDrop(world, this, rootPos, world.field_73012_v, null, soilLife);
        return this.dropCreatorStorage.getVoluntaryDrop(world, this, rootPos, world.field_73012_v, dropList, soilLife);
    }

    public List<ItemStack> getLeavesDrops(IBlockAccess access, BlockPos breakPos, List<ItemStack> dropList, int fortune) {
        Random random = access instanceof World ? ((World)access).field_73012_v : new Random();
        dropList = TreeRegistry.globalDropCreatorStorage.getLeavesDrop(access, this, breakPos, random, dropList, fortune);
        return this.dropCreatorStorage.getLeavesDrop(access, this, breakPos, random, dropList, fortune);
    }

    public List<ItemStack> getLogsDrops(World world, BlockPos breakPos, List<ItemStack> dropList, float volume) {
        dropList = TreeRegistry.globalDropCreatorStorage.getLogsDrop(world, this, breakPos, world.field_73012_v, dropList, volume);
        return this.dropCreatorStorage.getLogsDrop(world, this, breakPos, world.field_73012_v, dropList, volume);
    }

    public LogsAndSticks getLogsAndSticks(float volume) {
        int logs = (int)volume;
        int sticks = (int)((volume - (float)logs) * 8.0f);
        return new LogsAndSticks(logs, sticks);
    }

    public boolean handleVoluntaryDrops(World world, List<BlockPos> endPoints, BlockPos rootPos, BlockPos treePos, int soilLife) {
        int tickSpeed = world.func_82736_K().func_180263_c("randomTickSpeed");
        if (tickSpeed > 0) {
            List<ItemStack> drops;
            double slowFactor = 3.0 / (double)tickSpeed;
            if (world.field_73012_v.nextDouble() < slowFactor && !(drops = this.getVoluntaryDrops(world, rootPos, treePos, soilLife)).isEmpty() && !endPoints.isEmpty()) {
                for (ItemStack drop : drops) {
                    BlockPos branchPos = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
                    BlockPos itemPos = CoordUtils.getRayTraceFruitPos(world, this, treePos, branchPos = branchPos.func_177984_a(), SafeChunkBounds.ANY);
                    if (itemPos == BlockPos.field_177992_a) continue;
                    EntityItem itemEntity = new EntityItem(world, (double)itemPos.func_177958_n() + 0.5, (double)itemPos.func_177956_o() + 0.5, (double)itemPos.func_177952_p() + 0.5, drop);
                    Vec3d motion = new Vec3d((Vec3i)itemPos).func_178788_d(new Vec3d((Vec3i)treePos));
                    float distAngle = 15.0f;
                    float launchSpeed = 4.0f;
                    motion = new Vec3d(motion.field_72450_a, 0.0, motion.field_72448_b).func_72432_b().func_178785_b(world.field_73012_v.nextFloat() * distAngle * 2.0f - distAngle).func_186678_a((double)(launchSpeed / 20.0f));
                    itemEntity.field_70159_w = motion.field_72450_a;
                    itemEntity.field_70181_x = motion.field_72448_b;
                    itemEntity.field_70179_y = motion.field_72449_c;
                    return world.func_72838_d((Entity)itemEntity);
                }
            }
        }
        return true;
    }

    public boolean plantSapling(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && BlockDynamicSapling.canSaplingStay(world, this, pos)) {
            ModBlocks.blockDynamicSapling.setSpecies(world, pos, this);
            return true;
        }
        return false;
    }

    public boolean canGrowWithBoneMeal(World world, BlockPos pos) {
        return this.canBoneMeal();
    }

    public boolean canUseBoneMealNow(World world, Random rand, BlockPos pos) {
        return this.canBoneMeal();
    }

    public boolean canBoneMeal() {
        return true;
    }

    public boolean transitionToTree(World world, BlockPos pos) {
        TreeFamily family = this.getFamily();
        if (world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
            family.getDynamicBranch().setRadius(world, pos, (int)family.getPrimaryThickness(), null);
            world.func_175656_a(pos.func_177984_a(), this.getLeavesProperties().getDynamicLeavesState());
            this.placeRootyDirtBlock(world, pos.func_177977_b(), 15);
            return true;
        }
        return false;
    }

    public AxisAlignedBB getSaplingBoundingBox() {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    }

    public ResourceLocation getSaplingName() {
        return this.getRegistryName();
    }

    public int saplingColorMultiplier(IBlockState state, IBlockAccess access, BlockPos pos, int tintIndex) {
        return this.getLeavesProperties().foliageColorMultiplier(state, access, pos);
    }

    public SoundType getSaplingSound() {
        return SoundType.field_185850_c;
    }

    public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
        return this.getRequiresTileEntity(world, rootPos) ? ModBlocks.blockRootyDirtSpecies : ModBlocks.blockRootyDirt;
    }

    public boolean placeRootyDirtBlock(World world, BlockPos rootPos, int life) {
        world.func_175656_a(rootPos, this.getRootyBlock(world, rootPos).func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(life)));
        TileEntity tileEntity = world.func_175625_s(rootPos);
        if (tileEntity instanceof TileEntitySpecies) {
            TileEntitySpecies speciesTE = (TileEntitySpecies)tileEntity;
            speciesTE.setSpecies(this);
        }
        return true;
    }

    public Species setSoilLongevity(int longevity) {
        this.soilLongevity = longevity;
        return this;
    }

    public int getSoilLongevity(World world, BlockPos rootPos) {
        return (int)(this.biomeSuitability(world, rootPos) * (float)this.soilLongevity);
    }

    public boolean isThick() {
        return false;
    }

    public int maxBranchRadius() {
        return this.isThick() ? 24 : 8;
    }

    @Deprecated
    public Species addAcceptableSoil(Block ... soilBlocks) {
        Deprecatron.Complain("addAcceptableSoil", "The Block version of addAcceptableSoil is DEPRECATED. Species: " + this.getRegistryName());
        return this;
    }

    public Species addAcceptableSoils(String ... soilTypes) {
        this.soilTypeFlags |= DirtHelper.getSoilFlags(soilTypes);
        return this;
    }

    public Species clearAcceptableSoils() {
        this.soilTypeFlags = 0;
        return this;
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils("dirtlike");
    }

    public boolean isAcceptableSoil(IBlockState soilBlockState) {
        return DirtHelper.isSoilAcceptable(soilBlockState.func_177230_c(), this.soilTypeFlags);
    }

    public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
        return this.isAcceptableSoil(soilBlockState);
    }

    public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
        return this.isAcceptableSoil(world, pos, soilBlockState);
    }

    public boolean update(World world, BlockRooty rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean natural) {
        List<BlockPos> ends = this.getEnds(world, treePos, treeBase);
        if (this.handleRot(world, ends, rootPos, treePos, soilLife, SafeChunkBounds.ANY)) {
            return false;
        }
        if (natural) {
            this.handleVoluntaryDrops(world, ends, rootPos, treePos, soilLife);
            if (this.handleDisease(world, treeBase, treePos, random, soilLife)) {
                return true;
            }
        }
        return this.grow(world, rootyDirt, rootPos, soilLife, treeBase, treePos, random, natural);
    }

    protected final List<BlockPos> getEnds(World world, BlockPos treePos, ITreePart treeBase) {
        NodeFindEnds endFinder = new NodeFindEnds();
        treeBase.analyse(world.func_180495_p(treePos), world, treePos, null, new MapSignal(endFinder));
        return endFinder.getEnds();
    }

    public boolean handleRot(World world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, SafeChunkBounds safeBounds) {
        Iterator<BlockPos> iter = ends.iterator();
        SimpleVoxmap leafMap = this.getLeavesProperties().getCellKit().getLeafCluster();
        while (iter.hasNext()) {
            float rotChance;
            int radius;
            BlockPos endPos = iter.next();
            IBlockState branchState = world.func_180495_p(endPos);
            BlockBranch branch = TreeHelper.getBranch(branchState);
            if (branch == null || !branch.checkForRot(world, endPos, this, radius = branch.getRadius(branchState), world.field_73012_v, rotChance = this.rotChance(world, endPos, world.field_73012_v, radius), safeBounds != SafeChunkBounds.ANY) && radius == 1) continue;
            if (safeBounds != SafeChunkBounds.ANY) {
                TreeHelper.ageVolume(world, endPos.func_177979_c((leafMap.getLenZ() - 1) / 2), (leafMap.getLenX() - 1) / 2, leafMap.getLenY(), 2, safeBounds);
            }
            iter.remove();
        }
        return ends.isEmpty() && !TreeHelper.isBranch(world.func_180495_p(treePos));
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (radius <= 1) {
            BlockDynamicLeaves leaves = (BlockDynamicLeaves)this.getLeavesProperties().getDynamicLeavesState().func_177230_c();
            for (EnumFacing dir : upFirst) {
                if (!leaves.growLeavesIfLocationIsSuitable(world, this.getLeavesProperties(), pos.func_177972_a(dir), 0)) continue;
                return false;
            }
        }
        if (rapid || ModConfigs.maxBranchRotRadius != 0 && radius <= ModConfigs.maxBranchRotRadius) {
            BlockBranch branch = TreeHelper.getBranch(world.func_180495_p(pos));
            if (branch != null) {
                branch.rot(world, pos);
            }
            return true;
        }
        return false;
    }

    public float rotChance(World world, BlockPos pos, Random rand, int radius) {
        return 0.3f + (float)(8 - radius) * 0.1f;
    }

    public boolean grow(World world, BlockRooty rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean natural) {
        float growthRate = this.getGrowthRate(world, rootPos) * ModConfigs.treeGrowthMultiplier * (float)ModConfigs.treeGrowthFolding;
        do {
            if (soilLife <= 0 || !(growthRate > random.nextFloat())) continue;
            GrowSignal signal = new GrowSignal(this, rootPos, this.getEnergy(world, rootPos));
            boolean success = treeBase.growSignal((World)world, (BlockPos)treePos, (GrowSignal)signal).success;
            int soilLongevity = this.getSoilLongevity(world, rootPos) * (success ? 1 : 16);
            if (soilLongevity <= 0 || random.nextInt(soilLongevity) == 0) {
                rootyDirt.setSoilLife(world, rootPos, soilLife - 1);
            }
            if (!signal.choked) continue;
            soilLife = 0;
            rootyDirt.setSoilLife(world, rootPos, soilLife);
            TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(new NodeShrinker(signal.getSpecies())));
        } while ((growthRate -= 1.0f) > 0.0f);
        return this.postGrow(world, rootPos, treePos, soilLife, natural);
    }

    public Species setGrowthLogicKit(IGrowthLogicKit logicKit) {
        this.logicKit = logicKit;
        return this;
    }

    public IGrowthLogicKit getGrowthLogicKit() {
        return this.logicKit;
    }

    public EnumFacing selectNewDirection(World world, BlockPos pos, BlockBranch branch, GrowSignal signal) {
        EnumFacing originDir = signal.dir.func_176734_d();
        if (signal.numSteps + 1 <= this.getLowestBranchHeight(world, signal.rootPos)) {
            return EnumFacing.UP;
        }
        int[] probMap = new int[6];
        probMap[EnumFacing.UP.ordinal()] = signal.dir != EnumFacing.DOWN ? this.getUpProbability() : 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + this.getReinfTravel();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir.equals((Object)originDir)) continue;
            BlockPos deltaPos = pos.func_177972_a(dir);
            IBlockState deltaBlockState = world.func_180495_p(deltaPos);
            int n2 = dir.func_176745_a();
            probMap[n2] = probMap[n2] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (IBlockAccess)world, deltaPos, branch);
        }
        probMap = this.customDirectionManipulation(world, pos, branch.getRadius(world.func_180495_p(pos)), signal, probMap);
        int choice = com.ferreusveritas.dynamictrees.util.MathHelper.selectRandomFromDistribution(signal.rand, probMap);
        return this.newDirectionSelected(EnumFacing.func_82600_a((int)(choice != -1 ? choice : 1)), signal);
    }

    protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
        return this.getGrowthLogicKit().directionManipulation(world, pos, this, radius, signal, probMap);
    }

    protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
        return this.getGrowthLogicKit().newDirectionSelected(this, newDir, signal);
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean natural) {
        if (this.postGrowFeatures != null) {
            for (IPostGrowFeature feature : this.postGrowFeatures) {
                feature.postGrow(world, rootPos, treePos, this, soilLife, natural);
            }
        }
        return true;
    }

    public boolean handleDisease(World world, ITreePart baseTreePart, BlockPos treePos, Random random, int soilLife) {
        if (soilLife == 0 && ModConfigs.diseaseChance > random.nextFloat()) {
            baseTreePart.analyse(world.func_180495_p(treePos), world, treePos, EnumFacing.DOWN, new MapSignal(new NodeDisease(this)));
            return true;
        }
        return false;
    }

    public Species envFactor(BiomeDictionary.Type type, float factor) {
        this.envFactors.put(type, Float.valueOf(factor));
        return this;
    }

    public float biomeSuitability(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        BiomeSuitabilityEvent suitabilityEvent = new BiomeSuitabilityEvent(world, biome, this, pos);
        MinecraftForge.EVENT_BUS.post((Event)suitabilityEvent);
        if (suitabilityEvent.isHandled()) {
            return suitabilityEvent.getSuitability();
        }
        float ugs = ModConfigs.scaleBiomeGrowthRate;
        if (ugs == 1.0f || this.isBiomePerfect(biome)) {
            return 1.0f;
        }
        float suit = Species.defaultSuitability();
        for (BiomeDictionary.Type t : BiomeDictionary.getTypes((Biome)biome)) {
            suit *= this.envFactors.containsKey(t) ? this.envFactors.get(t).floatValue() : 1.0f;
        }
        suit = ugs <= 0.5f ? ugs * 2.0f * suit : ((1.0f - ugs) * suit + (ugs - 0.5f)) * 2.0f;
        return MathHelper.func_76131_a((float)suit, (float)0.0f, (float)1.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return false;
    }

    public static final float defaultSuitability() {
        return 0.85f;
    }

    public static boolean isOneOfBiomes(Biome biomeToCheck, Biome ... biomes) {
        for (Biome biome : biomes) {
            if (biomeToCheck != biome) continue;
            return true;
        }
        return false;
    }

    public float seasonalGrowthFactor(World world, BlockPos rootPos) {
        return ModConfigs.enableSeasonalGrowthFactor ? SeasonHelper.globalSeasonalGrowthFactor(world, rootPos) : 1.0f;
    }

    public float seasonalSeedDropFactor(World world, BlockPos pos) {
        return ModConfigs.enableSeasonalSeedDropFactor ? SeasonHelper.globalSeasonalSeedDropFactor(world, pos) : 1.0f;
    }

    public float seasonalFruitProductionFactor(World world, BlockPos pos) {
        return ModConfigs.enableSeasonalFruitProductionFactor ? SeasonHelper.globalSeasonalFruitProductionFactor(world, pos) : 1.0f;
    }

    public int getSeasonalTooltipFlags(int dimension) {
        float seasonStart = 0.167f;
        float seasonEnd = 0.833f;
        float threshold = 0.75f;
        if (BlockFruit.getFruitBlockForSpecies(this) != null) {
            int seasonFlags = 0;
            for (int i = 0; i < 4; ++i) {
                float prod2;
                float prod1 = this.seasonalFruitProductionFactor(null, new BlockPos(dimension, (int)(((float)i + seasonStart) * 64.0f), 0));
                if (!(Math.min(prod1, prod2 = this.seasonalFruitProductionFactor(null, new BlockPos(dimension, (int)(((float)i + seasonEnd) * 64.0f), 0))) >= threshold)) continue;
                seasonFlags |= 1 << i;
            }
            return seasonFlags;
        }
        return 0;
    }

    public Species setFlowerSeasonHold(float min, float max) {
        this.flowerSeasonHoldMin = min;
        this.flowerSeasonHoldMax = max;
        return this;
    }

    public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
        return SeasonHelper.isSeasonBetween(seasonValue, this.flowerSeasonHoldMin, this.flowerSeasonHoldMax);
    }

    public ISubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        if (this.canBoneMeal() && itemStack.func_77973_b() == Items.field_151100_aR && itemStack.func_77952_i() == 15) {
            return new SubstanceFertilize().setAmount(1).setGrow(true);
        }
        if (itemStack.func_77973_b() instanceof ISubstanceEffectProvider) {
            ISubstanceEffectProvider provider = (ISubstanceEffectProvider)itemStack.func_77973_b();
            return provider.getSubstanceEffect(itemStack);
        }
        return null;
    }

    public boolean applySubstance(World world, BlockPos rootPos, BlockPos hitPos, EntityPlayer player, EnumHand hand, ItemStack itemStack) {
        ISubstanceEffect effect = this.getSubstanceEffect(itemStack);
        if (effect != null) {
            if (effect.isLingering()) {
                world.func_72838_d((Entity)new EntityLingeringEffector(world, rootPos, effect));
                return true;
            }
            return effect.apply(world, rootPos);
        }
        return false;
    }

    public boolean onTreeActivated(World world, BlockPos rootPos, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && this.applySubstance(world, rootPos, hitPos, player, hand, heldItem)) {
            Species.consumePlayerItem(player, hand, heldItem);
            return true;
        }
        return false;
    }

    public static void consumePlayerItem(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (heldItem.func_77973_b() instanceof IEmptiable) {
                IEmptiable emptiable = (IEmptiable)heldItem.func_77973_b();
                player.func_184611_a(hand, emptiable.getEmptyContainer());
            } else if (heldItem.func_77973_b() == Items.field_151068_bn) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                heldItem.func_190918_g(1);
            }
        }
    }

    public boolean useDefaultWailaBody() {
        return true;
    }

    public boolean isMega() {
        return false;
    }

    public Species getMegaSpecies() {
        return NULLSPECIES;
    }

    public IAnimationHandler selectAnimationHandler(EntityFallingTree fallingEntity) {
        return this.getFamily().selectAnimationHandler(fallingEntity);
    }

    public BlockBonsaiPot getBonzaiPot() {
        return ModBlocks.blockBonsaiPot;
    }

    public boolean generate(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        JoCode code;
        if (this.genFeatureOverride != null) {
            return this.genFeatureOverride.generate(world, rootPos, this, biome, random, radius, safeBounds);
        }
        EnumFacing facing = CoordUtils.getRandomDir(random);
        if (this.getJoCodeStore() != null && (code = this.getJoCodeStore().getRandomCode(radius, random)) != null) {
            code.generate(world, this, rootPos, biome, facing, radius, safeBounds);
            return true;
        }
        return false;
    }

    public JoCodeStore getJoCodeStore() {
        return this.joCodeStore;
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCode(joCodeString);
    }

    public void addJoCodes() {
        this.joCodeStore.addCodesFromFile(this, "assets/" + this.getRegistryName().func_110624_b() + "/trees/" + this.getRegistryName().func_110623_a() + ".txt");
    }

    public Species addGenFeature(IGenFeature module) {
        this.addGenFeature(module, 14);
        return this;
    }

    public Species addGenFeature(IGenFeature module, int allowableFlags) {
        IGenFeature feature;
        if (module instanceof IFullGenFeature && (allowableFlags & 1) != 0) {
            this.genFeatureOverride = (IFullGenFeature)module;
        }
        if (module instanceof IPreGenFeature && (allowableFlags & 2) != 0) {
            feature = (IPreGenFeature)module;
            if (this.preGenFeatures == null) {
                this.preGenFeatures = new ArrayList<IPreGenFeature>(1);
            }
            this.preGenFeatures.add((IPreGenFeature)feature);
        }
        if (module instanceof IPostGenFeature && (allowableFlags & 4) != 0) {
            feature = (IPostGenFeature)module;
            if (this.postGenFeatures == null) {
                this.postGenFeatures = new ArrayList<IPostGenFeature>(1);
            }
            this.postGenFeatures.add((IPostGenFeature)feature);
        }
        if (module instanceof IPostGrowFeature && (allowableFlags & 8) != 0) {
            feature = (IPostGrowFeature)module;
            if (this.postGrowFeatures == null) {
                this.postGrowFeatures = new ArrayList<IPostGrowFeature>(1);
            }
            this.postGrowFeatures.add((IPostGrowFeature)feature);
        }
        return this;
    }

    public BlockPos preGeneration(World world, BlockPos rootPos, int radius, EnumFacing facing, SafeChunkBounds safeBounds, JoCode joCode) {
        if (this.preGenFeatures != null) {
            for (IPreGenFeature feature : this.preGenFeatures) {
                rootPos = feature.preGeneration(world, rootPos, this, radius, facing, safeBounds, joCode);
            }
        }
        return rootPos;
    }

    public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (this.postGenFeatures != null) {
            for (IPostGenFeature feature : this.postGenFeatures) {
                feature.postGeneration(world, rootPos, this, biome, radius, endPoints, safeBounds, initialDirtState);
            }
        }
    }

    public float getWorldGenTaperingFactor() {
        return 1.5f;
    }

    public int getWorldGenLeafMapHeight() {
        return 32;
    }

    public int getWorldGenAgeIterations() {
        return 3;
    }

    public INodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return new NodeInflator(this, leafMap);
    }

    public int coordHashCode(BlockPos pos) {
        return CoordUtils.coordHashCode(pos, 2);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    static {
        upFirst = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
    }

    public class LogsAndSticks {
        public final int logs;
        public final int sticks;

        public LogsAndSticks(int logs, int sticks) {
            this.logs = logs;
            this.sticks = ModConfigs.dropSticks ? sticks : 0;
        }
    }
}

