/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.compat.WailaOther;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SubstanceTransform
implements ISubstanceEffect {
    Species toSpecies;

    public SubstanceTransform(Species toTree) {
        this.toSpecies = toTree;
    }

    @Override
    public boolean apply(World world, BlockPos rootPos) {
        Species fromSpecies;
        IBlockState rootyState = world.func_180495_p(rootPos);
        BlockRooty dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null && this.toSpecies != null && (fromSpecies = dirt.getSpecies(rootyState, world, rootPos)).isTransformable() && fromSpecies != this.toSpecies) {
            if (world.field_72995_K) {
                TreeHelper.treeParticles(world, rootPos, EnumParticleTypes.FIREWORKS_SPARK, 8);
                WailaOther.invalidateWailaPosition();
            } else {
                dirt.startAnalysis(world, rootPos, new MapSignal(new NodeTransform(fromSpecies, this.toSpecies)));
                if (dirt.getSpecies(rootyState, world, rootPos) != this.toSpecies) {
                    this.toSpecies.placeRootyDirtBlock(world, rootPos, dirt.getSoilLife(rootyState, (IBlockAccess)world, rootPos));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(World world, BlockPos rootPos, int deltaTicks) {
        return false;
    }

    @Override
    public String getName() {
        return "transform";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

