/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeTransform
implements INodeInspector {
    Species fromSpecies;
    Species toSpecies;
    TreeFamily toFamily;
    IBlockState toSpeciesLeaves;

    public NodeTransform(Species fromSpecies, Species toSpecies) {
        this.fromSpecies = fromSpecies;
        this.toSpecies = toSpecies;
        this.toFamily = toSpecies.getFamily();
        this.toSpeciesLeaves = toSpecies.getLeavesProperties().getDynamicLeavesState();
    }

    @Override
    public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(blockState);
        if (branch != null && this.fromSpecies.getFamily() == branch.getFamily() && (radius = branch.getRadius(blockState)) > 0) {
            this.toFamily.getDynamicBranch().setRadius(world, pos, radius, null);
            if (radius == 1) {
                this.transformSurroundingLeaves(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(World world, BlockPos twigPos) {
        if (!world.field_72995_K) {
            for (BlockPos leavesPos : BlockPos.func_177980_a((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3))) {
                if (this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster().getVoxel(twigPos, leavesPos) == 0) continue;
                IBlockState state = world.func_180495_p(leavesPos);
                if (!this.fromSpecies.getFamily().isCompatibleGenericLeaves(state, (IBlockAccess)world, leavesPos)) continue;
                int hydro = state.func_177230_c() instanceof BlockDynamicLeaves ? (Integer)state.func_177229_b((IProperty)BlockDynamicLeaves.HYDRO) : 2;
                world.func_175656_a(leavesPos, this.toSpeciesLeaves == null ? Blocks.field_150350_a.func_176223_P() : this.toSpeciesLeaves.func_177226_a((IProperty)BlockDynamicLeaves.HYDRO, (Comparable)Integer.valueOf(hydro)));
            }
        }
    }
}

