/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.proxy;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchCactus;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesPropertiesJson;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.client.BlockColorMultipliers;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.client.TextureUtils;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.event.BlockBreakAnimationClientHandler;
import com.ferreusveritas.dynamictrees.event.ModelBakeEventListener;
import com.ferreusveritas.dynamictrees.event.TextureGenerationHandler;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.models.loaders.ModelLoaderBlockBranchBasic;
import com.ferreusveritas.dynamictrees.models.loaders.ModelLoaderBlockBranchCactus;
import com.ferreusveritas.dynamictrees.models.loaders.ModelLoaderBlockBranchThick;
import com.ferreusveritas.dynamictrees.models.loaders.ModelLoaderBlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.models.loaders.ModelLoaderSapling;
import com.ferreusveritas.dynamictrees.proxy.CommonProxy;
import com.ferreusveritas.dynamictrees.render.RenderFallingTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        this.registerJsonColorMultipliers();
        this.registerClientEventHandlers();
        this.registerEntityRenderers();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerColorHandlers();
        MinecraftForge.EVENT_BUS.register((Object)BlockBreakAnimationClientHandler.instance);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.discoverWoodColors();
        LeavesPropertiesJson.postInitClient();
    }

    private void discoverWoodColors() {
        Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        for (TreeFamily family : Species.REGISTRY.getValues().stream().map(s -> s.getFamily()).distinct().collect(Collectors.toList())) {
            IModel model;
            ResourceLocation resloc;
            IBlockState state;
            family.woodColor = 16773550;
            if (family == TreeFamily.NULLFAMILY || (state = family.getPrimitiveLog()).func_177230_c() == Blocks.field_150350_a || (resloc = QuadManipulator.getModelTexture(model = QuadManipulator.getModelForState(state), bakedTextureGetter, state, EnumFacing.UP)) == null) continue;
            TextureUtils.PixelBuffer pixbuf = new TextureUtils.PixelBuffer(bakedTextureGetter.apply(resloc));
            int u = pixbuf.w / 16;
            TextureUtils.PixelBuffer center = new TextureUtils.PixelBuffer(u * 8, u * 8);
            pixbuf.blit(center, u * -8, u * -8);
            family.woodColor = center.averageColor();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        BlockColorMultipliers.cleanUp();
    }

    @Override
    public void registerModels() {
        LeavesPropertiesJson.resolveAll();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockRootyDirt, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockRootyDirtSpecies, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockRootySand, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
        for (DendroPotion.DendroPotionType type : DendroPotion.DendroPotionType.values()) {
            ModelHelper.regModel(ModItems.dendroPotion, type.getIndex());
        }
        ModelHelper.regModel(ModItems.dirtBucket);
        ModelHelper.regModel(ModItems.treeStaff);
        for (TreeFamily treeFamily : ModTrees.baseFamilies) {
            ModelHelper.regModel(treeFamily.getDynamicBranch());
            ModelHelper.regModel(treeFamily.getCommonSpecies().getSeed());
            ModelHelper.regModel(treeFamily);
        }
        ModelHelper.setGenericStateMapper(ModBlocks.blockDynamicSapling, new ModelResourceLocation(new ResourceLocation("dynamictrees", "sapling"), ""));
        ModelLoader.setCustomStateMapper((Block)ModBlocks.blockTrunkShell, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockTrunkShell.COREDIR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModTrees.dynamicCactus.getDynamicBranch(), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockBranchCactus.TRUNK, BlockBranchCactus.ORIGIN}).func_178441_a());
        ModelHelper.regModel(ModTrees.dynamicCactus.getDynamicBranch());
        ModelHelper.regModel(ModTrees.dynamicCactus.getCommonSpecies().getSeed());
        ModelHelper.regModel(((Species)Species.REGISTRY.getValue(new ResourceLocation("dynamictrees", "apple"))).getSeed());
        LeavesPaging.setStateMappers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockBranchBasic());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockBranchCactus());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockBranchThick());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockSurfaceRoot());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderSapling());
    }

    private boolean isValid(IBlockAccess access, BlockPos pos) {
        return access != null && pos != null;
    }

    @Override
    public void registerColorHandlers() {
        int white = -1;
        int magenta = 0xFF00FF;
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (state.func_177230_c() instanceof BlockRooty) {
                BlockRooty blockRooty = (BlockRooty)state.func_177230_c();
                switch (tintIndex) {
                    case 0: {
                        IBlockState muse = blockRooty.getMimic(world, pos);
                        if (!(muse instanceof MimicProperty.IMimic)) {
                            return blockColors.func_186724_a(muse, world, pos, tintIndex);
                        }
                    }
                    case 1: {
                        return blockRooty.rootColor(state, world, pos);
                    }
                }
                return -1;
            }
            return -1;
        }, new Block[]{ModBlocks.blockRootyDirt, ModBlocks.blockRootyDirtSpecies, ModBlocks.blockRootySand, ModBlocks.blockRootyDirtFake});
        ModelHelper.regColorHandler(ModBlocks.blockDynamicSapling, (state, access, pos, tintIndex) -> this.isValid(access, pos) ? ModBlocks.blockDynamicSapling.getSpecies(access, pos, state).saplingColorMultiplier(state, access, pos, tintIndex) : -1);
        ModelHelper.regColorHandler((Block)ModBlocks.blockBonsaiPot, (state, access, pos, tintIndex) -> this.isValid(access, pos) && state.func_177230_c() instanceof BlockBonsaiPot ? ModBlocks.blockBonsaiPot.getSpecies(access, pos).saplingColorMultiplier(state, access, pos, tintIndex) : -1);
        ModelHelper.regColorHandler(ModItems.dendroPotion, (stack, tint) -> ModItems.dendroPotion.getColor(stack, tint));
        ModelHelper.regColorHandler(ModItems.treeStaff, (stack, tint) -> ModItems.treeStaff.getColor(stack, tint));
        for (BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId("dynamictrees").values()) {
            ModelHelper.regColorHandler((Block)leaves, (state, worldIn, pos, tintIndex) -> TreeHelper.isLeaves(state.func_177230_c()) ? ((BlockDynamicLeaves)state.func_177230_c()).getProperties(state).foliageColorMultiplier(state, worldIn, pos) : 0xFF00FF);
        }
    }

    public void registerJsonColorMultipliers() {
        BlockColorMultipliers.register("birch", (state, worldIn, pos, tintIndex) -> ColorizerFoliage.func_77469_b());
        BlockColorMultipliers.register("spruce", (state, worldIn, pos, tintIndex) -> ColorizerFoliage.func_77466_a());
    }

    public void registerClientEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new ModelBakeEventListener());
        MinecraftForge.EVENT_BUS.register(TextureGenerationHandler.class);
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingTree.class, (IRenderFactory)new RenderFallingTree.Factory());
    }

    @Override
    public int getFoliageColor(ILeavesProperties leavesProperties, World world, IBlockState blockState, BlockPos pos) {
        return leavesProperties.foliageColorMultiplier(blockState, (IBlockAccess)world, pos);
    }

    @Override
    public void addDustParticle(World world, double fx, double fy, double fz, double mx, double my, double mz, IBlockState blockState, float r, float g, float b) {
        if (world.field_72995_K) {
            Particle particle = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), fx, fy, fz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)blockState)});
            particle.func_70538_b(r, g, b);
        }
    }

    @Override
    public void spawnParticle(World world, EnumParticleTypes particleType, double x, double y, double z, double mx, double my, double mz) {
        if (world.field_72995_K) {
            world.func_175688_a(particleType, x, y, z, mx, my, mz, new int[0]);
        }
    }

    @Override
    public void crushLeavesBlock(World world, BlockPos pos, IBlockState blockState, Entity entity) {
        if (world.field_72995_K) {
            Random random = world.field_73012_v;
            ITreePart treePart = TreeHelper.getTreePart(blockState);
            if (treePart instanceof BlockDynamicLeaves) {
                BlockDynamicLeaves leaves = (BlockDynamicLeaves)treePart;
                ILeavesProperties leavesProperties = leaves.getProperties(blockState);
                int color = this.getFoliageColor(leavesProperties, world, blockState, pos);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                for (int dz = 0; dz < 8; ++dz) {
                    for (int dy = 0; dy < 8; ++dy) {
                        for (int dx = 0; dx < 8; ++dx) {
                            if (random.nextInt(8) != 0) continue;
                            double fx = (double)pos.func_177958_n() + (double)dx / 8.0;
                            double fy = (double)pos.func_177956_o() + (double)dy / 8.0;
                            double fz = (double)pos.func_177952_p() + (double)dz / 8.0;
                            this.addDustParticle(world, fx, fy, fz, 0.0, (double)random.nextFloat() * entity.field_70181_x, 0.0, blockState, r, g, b);
                        }
                    }
                }
            }
        }
    }
}

