/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.IFutureBreakable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.event.FutureBreak;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeDestroyer;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeExtState;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeNetVolume;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeSpecies;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class BlockBranch
extends Block
implements ITreePart,
IFutureBreakable {
    public static final int RADMAX_NORMAL = 8;
    public static final IUnlistedProperty[] CONNECTIONS = new IUnlistedProperty[]{new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusd", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusu", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusn", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuss", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusw", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuse", (int)0, (int)8))};
    private TreeFamily tree = TreeFamily.NULLFAMILY;
    public static EnumDestroyMode destroyMode = EnumDestroyMode.SLOPPY;

    public BlockBranch(Material material, String name) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.setHarvestLevel("axe", 0);
    }

    public IProperty<?>[] getIgnorableProperties() {
        return new IProperty[0];
    }

    public void setFamily(TreeFamily tree) {
        this.tree = tree;
    }

    public TreeFamily getFamily() {
        return this.tree;
    }

    @Override
    public TreeFamily getFamily(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getFamily();
    }

    public boolean isSameTree(ITreePart treepart) {
        return this.isSameTree(TreeHelper.getBranch(treepart));
    }

    public boolean isSameTree(BlockBranch branch) {
        return branch != null && this.getFamily() == branch.getFamily();
    }

    @Override
    public abstract int branchSupport(IBlockState var1, IBlockAccess var2, BlockBranch var3, BlockPos var4, EnumFacing var5, int var6);

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return this.getFamily().isWood();
    }

    public abstract boolean checkForRot(World var1, BlockPos var2, Species var3, int var4, Random var5, float var6, boolean var7);

    public static int setSupport(int branches, int leaves) {
        return (branches & 0xF) << 4 | leaves & 0xF;
    }

    public static int getBranchSupport(int support) {
        return support >> 4 & 0xF;
    }

    public static int getLeavesSupport(int support) {
        return support & 0xF;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        return TreeHelper.getTreePart(state).getFamily(state, (IBlockAccess)world, pos).onTreeActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return 1;
    }

    public abstract int setRadius(World var1, BlockPos var2, int var3, EnumFacing var4, int var5);

    public int setRadius(World world, BlockPos pos, int radius, EnumFacing originDir) {
        return this.setRadius(world, pos, radius, originDir, 2);
    }

    public abstract IBlockState getStateForRadius(int var1);

    public int getMaxRadius() {
        return 8;
    }

    @Override
    public boolean shouldAnalyse() {
        return true;
    }

    public BranchDestructionData destroyBranchFromNode(World world, BlockPos cutPos, EnumFacing toolDir, boolean wholeTree) {
        IBlockState blockState = world.func_180495_p(cutPos);
        NodeSpecies nodeSpecies = new NodeSpecies();
        MapSignal signal = this.analyse(blockState, world, cutPos, null, new MapSignal(nodeSpecies));
        Species species = nodeSpecies.getSpecies();
        NodeExtState extStateMapper = new NodeExtState(cutPos);
        this.analyse(blockState, world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(extStateMapper));
        NodeNetVolume volumeSum = new NodeNetVolume();
        NodeDestroyer destroyer = new NodeDestroyer(species);
        destroyMode = EnumDestroyMode.HARVEST;
        this.analyse(blockState, world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(volumeSum, destroyer));
        destroyMode = EnumDestroyMode.SLOPPY;
        List<Object> endPoints = destroyer.getEnds();
        HashMap<BlockPos, IBlockState> destroyedLeaves = new HashMap<BlockPos, IBlockState>();
        ArrayList<BlockItemStack> leavesDropsList = new ArrayList<BlockItemStack>();
        this.destroyLeaves(world, cutPos, species, endPoints, destroyedLeaves, leavesDropsList);
        endPoints = endPoints.stream().map(p -> p.func_177973_b((Vec3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (extStateMapper.getExtStateMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.func_177984_a();
        }
        EnumFacing cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = EnumFacing.DOWN;
        }
        return new BranchDestructionData(species, extStateMapper.getExtStateMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutDir, toolDir, trunkHeight);
    }

    public void rot(World world, BlockPos pos) {
        this.breakDeliberate(world, pos, EnumDestroyMode.ROT);
    }

    protected void destroyLeaves(World world, BlockPos cutPos, Species species, List<BlockPos> endPoints, Map<BlockPos, IBlockState> destroyedLeaves, List<BlockItemStack> drops) {
        if (!world.field_72995_K && !endPoints.isEmpty()) {
            BlockBounds bounds = new BlockBounds(endPoints).expand(3);
            SimpleVoxmap vmap = new SimpleVoxmap(bounds);
            for (BlockPos endPos : endPoints) {
                for (BlockPos leafPos : BlockPos.func_177975_b((BlockPos)endPos.func_177982_a(-3, -3, -3), (BlockPos)endPos.func_177982_a(3, 3, 3))) {
                    vmap.setVoxel(leafPos, (byte)1);
                }
                vmap.setVoxel(endPos, (byte)0);
            }
            TreeFamily family = species.getFamily();
            BlockBranch familyBranch = family.getDynamicBranch();
            int primaryThickness = (int)family.getPrimaryThickness();
            for (BlockPos.MutableBlockPos findPos : bounds.expand(3).iterate()) {
                IBlockState findState = world.func_180495_p((BlockPos)findPos);
                if (familyBranch.getRadius(findState) != primaryThickness) continue;
                Iterable<BlockPos.MutableBlockPos> leaves = species.getLeavesProperties().getCellKit().getLeafCluster().getAllNonZero();
                for (BlockPos.MutableBlockPos leafpos : leaves) {
                    vmap.setVoxel(findPos.func_177958_n() + leafpos.func_177958_n(), findPos.func_177956_o() + leafpos.func_177956_o(), findPos.func_177952_p() + leafpos.func_177952_p(), (byte)0);
                }
            }
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            for (SimpleVoxmap.Cell cell : vmap.getAllNonZeroCells()) {
                BlockPos.MutableBlockPos pos = cell.getPos();
                IBlockState blockState = world.func_180495_p((BlockPos)pos);
                if (!family.isCompatibleGenericLeaves(blockState, (IBlockAccess)world, (BlockPos)pos)) continue;
                dropList.clear();
                species.getTreeHarvestDrops(world, (BlockPos)pos, dropList, world.field_73012_v);
                BlockPos imPos = pos.func_185334_h();
                BlockPos relPos = imPos.func_177973_b((Vec3i)cutPos);
                world.func_180501_a(imPos, ModBlocks.blockStates.air, 0);
                destroyedLeaves.put(relPos, blockState);
                dropList.forEach(i -> drops.add(new BlockItemStack((ItemStack)i, relPos)));
            }
        }
    }

    public boolean canFall() {
        return false;
    }

    public List<ItemStack> getLogDrops(World world, BlockPos pos, Species species, float volume) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return species.getLogsDrops(world, pos, ret, volume *= ModConfigs.treeHarvestMultiplier);
    }

    @Override
    public void futureBreak(IBlockState state, World world, BlockPos cutPos, EntityLivingBase entity) {
        EnumFacing toolDir;
        double reachDistance = entity instanceof EntityPlayerMP ? entity.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0;
        RayTraceResult rtResult = this.playerRayTrace(entity, reachDistance, 1.0f);
        EnumFacing enumFacing = rtResult != null ? (entity.func_70093_af() ? rtResult.field_178784_b.func_176734_d() : rtResult.field_178784_b) : (toolDir = EnumFacing.DOWN);
        if (toolDir == null) {
            toolDir = EnumFacing.DOWN;
        }
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, toolDir, false);
        ItemStack heldItem = entity.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        float woodVolume = destroyData.woodVolume;
        List<ItemStack> woodItems = this.getLogDrops(world, cutPos, destroyData.species, woodVolume * fortuneFactor);
        if (entity.func_184600_cs() == null) {
            entity.func_184598_c(EnumHand.MAIN_HAND);
        }
        float chance = 1.0f;
        if (entity instanceof EntityPlayer) {
            chance = ForgeEventFactory.fireBlockHarvesting(woodItems, (World)world, (BlockPos)cutPos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)entity));
        }
        float finalChance = chance;
        List<ItemStack> woodDropList = woodItems.stream().filter(i -> world.field_73012_v.nextFloat() <= finalChance).collect(Collectors.toList());
        EntityFallingTree.dropTree(world, destroyData, woodDropList, EntityFallingTree.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos cutPos, EntityPlayer player, boolean canHarvest) {
        return this.removedByEntity(state, world, cutPos, (EntityLivingBase)player);
    }

    public boolean removedByEntity(IBlockState state, World world, BlockPos cutPos, EntityLivingBase entity) {
        FutureBreak.add(new FutureBreak(state, world, cutPos, entity, 0));
        return false;
    }

    protected void sloppyBreak(World world, BlockPos cutPos, EntityFallingTree.DestroyType destroyType) {
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, EnumFacing.DOWN, false);
        List woodDropList = Collections.EMPTY_LIST;
        destroyData.leavesDrops.clear();
        EntityFallingTree.dropTree(world, destroyData, woodDropList, destroyType);
    }

    @Nullable
    public RayTraceResult playerRayTrace(EntityLivingBase entity, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = entity.func_174824_e(partialTicks);
        Vec3d vec3d1 = entity.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return entity.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public void damageAxe(EntityLivingBase entity, ItemStack heldItem, int radius, float woodVolume) {
        if (heldItem == null) {
            return;
        }
        Set toolClasses = heldItem.func_77973_b().getToolClasses(heldItem);
        if (heldItem.func_77973_b() instanceof ItemAxe || toolClasses.contains("axe") || toolClasses.contains("mattock")) {
            int damage;
            switch (ModConfigs.axeDamageMode) {
                default: {
                    damage = 1;
                    break;
                }
                case THICKNESS: {
                    damage = Math.max(1, radius) / 2;
                    break;
                }
                case VOLUME: {
                    damage = (int)woodVolume;
                }
            }
            if (--damage > 0) {
                heldItem.func_77972_a(damage, entity);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && destroyMode == EnumDestroyMode.SLOPPY) {
            IBlockState toBlockState = world.func_180495_p(pos);
            Block toBlock = toBlockState.func_177230_c();
            if (toBlock instanceof BlockBranch) {
                return;
            }
            if (toBlock == Blocks.field_150350_a) {
                world.func_180501_a(pos, state, 0);
                this.sloppyBreak(world, pos, EntityFallingTree.DestroyType.VOID);
                this.setBlockStateIgnored(world, pos, ModBlocks.blockStates.air, 2);
                return;
            }
            if (toBlock == Blocks.field_150480_ab) {
                world.func_180501_a(pos, state, 0);
                this.sloppyBreak(world, pos, EntityFallingTree.DestroyType.FIRE);
                this.setBlockStateIgnored(world, pos, ModBlocks.blockStates.air, 2);
                return;
            }
            if (!toBlock.hasTileEntity(toBlockState) && world.func_175625_s(pos) == null) {
                world.func_180501_a(pos, state, 0);
                this.sloppyBreak(world, pos, EntityFallingTree.DestroyType.VOID);
                this.setBlockStateIgnored(world, pos, toBlockState, 2);
                return;
            }
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos offPos = pos.func_177972_a(dir);
                IBlockState offState = world.func_180495_p(offPos);
                if (!(offState.func_177230_c() instanceof BlockBranch)) continue;
                this.sloppyBreak(world, offPos, EntityFallingTree.DestroyType.VOID);
            }
        }
    }

    public void setBlockStateIgnored(World world, BlockPos pos, IBlockState state, int flags) {
        destroyMode = EnumDestroyMode.IGNORE;
        world.func_180501_a(pos, state, flags);
        destroyMode = EnumDestroyMode.SLOPPY;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void breakDeliberate(World world, BlockPos pos, EnumDestroyMode mode) {
        destroyMode = mode;
        world.func_175698_g(pos);
        destroyMode = EnumDestroyMode.SLOPPY;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            float woodVolume;
            List<ItemStack> woodDropList;
            Species species = TreeHelper.getExactSpecies(world, pos);
            BranchDestructionData destroyData = this.destroyBranchFromNode(world, pos, EnumFacing.DOWN, false);
            EntityFallingTree treeEntity = EntityFallingTree.dropTree(world, destroyData, woodDropList = this.getLogDrops(world, pos, species, woodVolume = destroyData.woodVolume), EntityFallingTree.DestroyType.BLAST);
            if (treeEntity != null) {
                Vec3d expPos = explosion.getPosition();
                EntityLivingBase placer = explosion.func_94613_c();
                float size = placer instanceof EntityCreeper ? (float)(((EntityCreeper)placer).func_70830_n() ? 6 : 3) : 4.0f;
                double distance = treeEntity.func_70011_f(expPos.field_72450_a, expPos.field_72448_b, expPos.field_72449_c);
                if (distance / (double)size <= 1.0 && distance != 0.0) {
                    treeEntity.field_70159_w += (treeEntity.field_70165_t - expPos.field_72450_a) / distance;
                    treeEntity.field_70181_x += (treeEntity.field_70163_u - expPos.field_72448_b) / distance;
                    treeEntity.field_70179_y += (treeEntity.field_70161_v - expPos.field_72449_c) / distance;
                }
            }
        }
    }

    @Override
    public final ITreePart.TreePartType getTreePartType() {
        return ITreePart.TreePartType.BRANCH;
    }

    public static enum EnumDestroyMode {
        IGNORE,
        SLOPPY,
        SETRADIUS,
        HARVEST,
        ROT,
        OVERFLOW;

    }

    public static enum EnumAxeDamage {
        VANILLA,
        THICKNESS,
        VOLUME;

    }

    public class BlockItemStack {
        public final ItemStack stack;
        public final BlockPos pos;

        public BlockItemStack(ItemStack stack, BlockPos pos) {
            this.stack = stack;
            this.pos = pos;
        }
    }
}

