/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.combustion;

import com.enderio.core.common.fluid.SmartTank;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import crazypants.enderio.base.fluid.IFluidCoolant;
import crazypants.enderio.base.fluid.IFluidFuel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CombustionMath {
    public static final double HEAT_PER_RF = (double)1.15E-4f;
    private final int ticksPerCoolant;
    private final int ticksPerFuel;
    private final int energyPerTick;

    public CombustionMath(@Nullable IFluidCoolant coolant, @Nullable IFluidFuel fuel, float capQuality, float machineQuality) {
        if (coolant == null || fuel == null || capQuality == 0.0f || machineQuality == 0.0f) {
            this.energyPerTick = 0;
            this.ticksPerFuel = 0;
            this.ticksPerCoolant = 0;
        } else {
            this.energyPerTick = Math.round((float)fuel.getPowerPerCycle() * capQuality * machineQuality);
            double cooling = coolant.getDegreesCoolingPerMB();
            double toCool = (double)1.15E-4f * (double)this.energyPerTick * (double)machineQuality;
            this.ticksPerCoolant = Math.max((int)Math.round(cooling / toCool), 1);
            this.ticksPerFuel = Math.max((int)((float)fuel.getTotalBurningTime() / capQuality / 1000.0f), 1);
        }
    }

    public CombustionMath(@Nonnull SmartTank coolant, @Nonnull SmartTank fuel, float capQuality, float machineQuality) {
        this(coolant.getFluid(), fuel.getFluid(), capQuality, machineQuality);
    }

    public CombustionMath(@Nullable FluidStack coolantFluid, @Nullable FluidStack fuelFluid, float capQuality, float machineQuality) {
        this(CombustionMath.toCoolant(coolantFluid), CombustionMath.toFuel(fuelFluid), capQuality, machineQuality);
    }

    public static IFluidFuel toFuel(@Nonnull SmartTank fuelTank) {
        return CombustionMath.toFuel(fuelTank.getFluid());
    }

    public static IFluidFuel toFuel(@Nullable FluidStack fuelFluid) {
        return fuelFluid != null ? FluidFuelRegister.instance.getFuel(fuelFluid) : null;
    }

    public static IFluidFuel toFuel(@Nullable Fluid fuelFluid) {
        return fuelFluid != null ? FluidFuelRegister.instance.getFuel(fuelFluid) : null;
    }

    public static IFluidCoolant toCoolant(@Nonnull SmartTank coolantTank) {
        return CombustionMath.toCoolant(coolantTank.getFluid());
    }

    public static IFluidCoolant toCoolant(@Nullable FluidStack coolantFluid) {
        return coolantFluid != null ? FluidFuelRegister.instance.getCoolant(coolantFluid) : null;
    }

    public static IFluidCoolant toCoolant(@Nullable Fluid coolantFluid) {
        return coolantFluid != null ? FluidFuelRegister.instance.getCoolant(coolantFluid) : null;
    }

    public int getTicksPerCoolant() {
        return this.ticksPerCoolant;
    }

    public int getTicksPerCoolant(int amount) {
        return this.ticksPerCoolant * amount;
    }

    public int getTicksPerFuel() {
        return this.ticksPerFuel;
    }

    public int getTicksPerFuel(int amount) {
        return this.ticksPerFuel * amount;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }
}

