/*
 * Decompiled with CFR 0.152.
 */
package weather2.client;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.forge.CULog;
import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilCompatibility;
import CoroUtil.util.CoroUtilEntOrParticle;
import CoroUtil.util.CoroUtilMisc;
import CoroUtil.util.CoroUtilPhysics;
import CoroUtil.util.Vec3;
import extendedrenderer.EventHandler;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorFogGround;
import extendedrenderer.particle.behavior.ParticleBehaviorMiniTornado;
import extendedrenderer.particle.behavior.ParticleBehaviorSandstorm;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleTexExtraRender;
import extendedrenderer.particle.entity.ParticleTexFX;
import extendedrenderer.particle.entity.ParticleTexLeafColor;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.Matrix4fe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector4f;
import weather2.ClientTickHandler;
import weather2.SoundRegistry;
import weather2.client.entity.particle.EntityWaterfallFX;
import weather2.client.entity.particle.ParticleFish;
import weather2.client.entity.particle.ParticleSandstorm;
import weather2.client.foliage.FoliageEnhancerShader;
import weather2.client.tornado.TornadoFunnel;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigStorm;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilConfig;
import weather2.util.WeatherUtilEntity;
import weather2.util.WeatherUtilParticle;
import weather2.util.WeatherUtilSound;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectSandstorm;
import weather2.weathersystem.wind.WindManager;

@SideOnly(value=Side.CLIENT)
public class SceneEnhancer
implements Runnable {
    public World lastWorldDetected = null;
    public static ParticleBehaviors pm;
    public static List<Particle> spawnQueueNormal;
    public static List<Particle> spawnQueue;
    public static long threadLastWorldTickTime;
    public static int lastTickFoundBlocks;
    public static long lastTickAmbient;
    public static long lastTickAmbientThreaded;
    public static ArrayList<ChunkCoordinatesBlock> soundLocations;
    public static HashMap<ChunkCoordinatesBlock, Long> soundTimeLocations;
    public static Block SOUNDMARKER_WATER;
    public static Block SOUNDMARKER_LEAVES;
    public static float curPrecipStr;
    public static float curPrecipStrTarget;
    public static float curOvercastStr;
    public static float curOvercastStrTarget;
    public static ParticleBehaviorMiniTornado miniTornado;
    public static ParticleBehaviorFogGround particleBehaviorFog;
    public static Vec3d vecWOP;
    public static double distToStormThreshold;
    public static double distToStorm;
    public static float stormFogRed;
    public static float stormFogGreen;
    public static float stormFogBlue;
    public static float stormFogRedOrig;
    public static float stormFogGreenOrig;
    public static float stormFogBlueOrig;
    public static float stormFogDensity;
    public static float stormFogDensityOrig;
    public static float stormFogStart;
    public static float stormFogEnd;
    public static float stormFogStartOrig;
    public static float stormFogEndOrig;
    public static float stormFogStartClouds;
    public static float stormFogEndClouds;
    public static float stormFogStartCloudsOrig;
    public static float stormFogEndCloudsOrig;
    public static boolean needFogState;
    public static float scaleIntensityTarget;
    public static float scaleIntensitySmooth;
    public static float adjustAmountTarget;
    public static float adjustAmountSmooth;
    public static float adjustAmountTargetPocketSandOverride;
    public static boolean isPlayerOutside;
    public static ParticleBehaviorSandstorm particleBehavior;
    public static ParticleTexExtraRender testParticle;
    public static EntityRotFX testParticle2;
    private int rainSoundCounter;
    private static List<BlockPos> listPosRandom;
    public static List<EntityRotFX> testParticles;
    public static Matrix4fe matrix;
    public static Matrix4fe matrix2;
    public static Vector3f vec;
    public static Vector3f vec2;
    public static TornadoFunnel funnel;

    public SceneEnhancer() {
        pm = new ParticleBehaviors(null);
        listPosRandom.clear();
        listPosRandom.add(new BlockPos(0, -1, 0));
        listPosRandom.add(new BlockPos(1, 0, 0));
        listPosRandom.add(new BlockPos(-1, 0, 0));
        listPosRandom.add(new BlockPos(0, 0, 1));
        listPosRandom.add(new BlockPos(0, 0, -1));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.tickClientThreaded();
                    Thread.sleep(ConfigMisc.Thread_Particle_Process_Delay);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void tickClient() {
        if (!WeatherUtil.isPaused() && !ConfigMisc.Client_PotatoPC_Mode) {
            this.tryParticleSpawning();
            SceneEnhancer.tickRainRates();
            this.tickParticlePrecipitation();
            this.trySoundPlaying();
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc.field_71441_e != null && this.lastWorldDetected != mc.field_71441_e) {
                this.lastWorldDetected = mc.field_71441_e;
                this.reset();
            }
            SceneEnhancer.tryWind((World)mc.field_71441_e);
            SceneEnhancer.tickSandstorm();
            if (particleBehavior == null) {
                particleBehavior = new ParticleBehaviorSandstorm(null);
            }
            particleBehavior.tickUpdateList();
            if (ConfigCoroUtil.foliageShaders && EventHandler.queryUseOfShaders()) {
                if (!FoliageEnhancerShader.useThread && mc.field_71441_e.func_82737_E() % 40L == 0L) {
                    FoliageEnhancerShader.tickClientThreaded();
                }
                if (mc.field_71441_e.func_82737_E() % 5L == 0L) {
                    FoliageEnhancerShader.tickClientCloseToPlayer();
                }
            }
        }
    }

    public void tickClientThreaded() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e != null && mc.field_71439_g != null && WeatherUtilConfig.listDimensionsWindEffects.contains(mc.field_71441_e.field_73011_w.getDimension())) {
            this.profileSurroundings();
            SceneEnhancer.tryAmbientSounds();
        }
    }

    public synchronized void trySoundPlaying() {
        try {
            int i;
            Minecraft mc;
            if (lastTickAmbient < System.currentTimeMillis()) {
                lastTickAmbient = System.currentTimeMillis() + 500L;
                mc = FMLClientHandler.instance().getClient();
                WorldClient worldRef = mc.field_71441_e;
                EntityPlayerSP player = mc.field_71439_g;
                int size = 32;
                int hsize = size / 2;
                int curX = (int)player.field_70165_t;
                int curY = (int)player.field_70163_u;
                int curZ = (int)player.field_70161_v;
                Random rand = new Random();
                for (i = 0; i < soundLocations.size(); ++i) {
                    ChunkCoordinatesBlock cCor = soundLocations.get(i);
                    if (Math.sqrt(cCor.getDistanceSquared((double)curX, (double)curY, (double)curZ)) > (double)size) {
                        soundLocations.remove(i--);
                        soundTimeLocations.remove(cCor);
                        continue;
                    }
                    Block block = SceneEnhancer.getBlock((World)worldRef, cCor.posX, cCor.posY, cCor.posZ);
                    if (block == null || block.func_149688_o(block.func_176223_P()) != Material.field_151586_h && block.func_149688_o(block.func_176223_P()) != Material.field_151584_j) {
                        soundLocations.remove(i);
                        soundTimeLocations.remove(cCor);
                        continue;
                    }
                    long lastPlayTime = 0L;
                    if (soundTimeLocations.containsKey(cCor)) {
                        lastPlayTime = soundTimeLocations.get(cCor);
                    }
                    if (lastPlayTime >= System.currentTimeMillis()) continue;
                    if (cCor.block == SOUNDMARKER_WATER) {
                        soundTimeLocations.put(cCor, System.currentTimeMillis() + 2500L + (long)rand.nextInt(50));
                        mc.field_71441_e.func_184156_a(cCor.toBlockPos(), SoundRegistry.get("env.waterfall"), SoundCategory.AMBIENT, (float)ConfigMisc.volWaterfallScale, 0.75f + rand.nextFloat() * 0.05f, false);
                        continue;
                    }
                    if (cCor.block != SOUNDMARKER_LEAVES) continue;
                    float windSpeed = WindReader.getWindSpeed((World)mc.field_71441_e, new Vec3((double)cCor.posX, (double)cCor.posY, (double)cCor.posZ), WindReader.WindType.EVENT);
                    if (windSpeed > 0.2f) {
                        soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                        mc.field_71441_e.func_184156_a(cCor.toBlockPos(), SoundRegistry.get("env.wind_calmfade"), SoundCategory.AMBIENT, (float)((double)(windSpeed * 4.0f) * ConfigMisc.volWindTreesScale), 0.7f + rand.nextFloat() * 0.1f, false);
                        continue;
                    }
                    windSpeed = WindReader.getWindSpeed((World)mc.field_71441_e, new Vec3((double)cCor.posX, (double)cCor.posY, (double)cCor.posZ));
                    if (mc.field_71441_e.field_73012_v.nextInt(15) != 0) continue;
                    soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                    mc.field_71441_e.func_184156_a(cCor.toBlockPos(), SoundRegistry.get("env.wind_calmfade"), SoundCategory.AMBIENT, (float)((double)(windSpeed * 2.0f) * ConfigMisc.volWindTreesScale), 0.7f + rand.nextFloat() * 0.1f, false);
                }
            }
            mc = Minecraft.func_71410_x();
            float vanillaCutoff = 0.2f;
            float precipStrength = Math.abs(SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)mc.field_71439_g, ClientTickHandler.clientConfigData.overcastMode));
            if (precipStrength <= vanillaCutoff) {
                float volAmp = 0.2f + precipStrength / vanillaCutoff * 0.8f;
                Random random = new Random();
                float f = mc.field_71441_e.func_72867_j(1.0f);
                if (!mc.field_71474_y.field_74347_j) {
                    f /= 2.0f;
                }
                if (f != 0.0f) {
                    Entity entity = mc.func_175606_aa();
                    WorldClient world = mc.field_71441_e;
                    BlockPos blockpos = new BlockPos(entity);
                    i = 10;
                    double d0 = 0.0;
                    double d1 = 0.0;
                    double d2 = 0.0;
                    int j = 0;
                    int k = 3;
                    if (mc.field_71474_y.field_74362_aa == 1) {
                        k >>= 1;
                    } else if (mc.field_71474_y.field_74362_aa == 2) {
                        k = 0;
                    }
                    for (int l = 0; l < k; ++l) {
                        BlockPos blockpos1 = world.func_175725_q(blockpos.func_177982_a(random.nextInt(10) - random.nextInt(10), 0, random.nextInt(10) - random.nextInt(10)));
                        Biome biome = world.func_180494_b(blockpos1);
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        IBlockState iblockstate = world.func_180495_p(blockpos2);
                        if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos1.func_177956_o() < blockpos.func_177956_o() - 10 || !biome.func_76738_d() || !(biome.func_180626_a(blockpos1) >= 0.15f)) continue;
                        double d3 = random.nextDouble();
                        double d4 = random.nextDouble();
                        AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, blockpos2);
                        if (iblockstate.func_185904_a() != Material.field_151587_i && iblockstate.func_177230_c() != Blocks.field_189877_df) {
                            if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                            if (random.nextInt(++j) == 0) {
                                d0 = (double)blockpos2.func_177958_n() + d3;
                                d1 = (double)((float)blockpos2.func_177956_o() + 0.1f) + axisalignedbb.field_72337_e - 1.0;
                                d2 = (double)blockpos2.func_177952_p() + d4;
                            }
                            mc.field_71441_e.func_175688_a(EnumParticleTypes.WATER_DROP, (double)blockpos2.func_177958_n() + d3, (double)((float)blockpos2.func_177956_o() + 0.1f) + axisalignedbb.field_72337_e, (double)blockpos2.func_177952_p() + d4, 0.0, 0.0, 0.0, new int[0]);
                            continue;
                        }
                        mc.field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)blockpos1.func_177958_n() + d3, (double)((float)blockpos1.func_177956_o() + 0.1f) - axisalignedbb.field_72338_b, (double)blockpos1.func_177952_p() + d4, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (j > 0 && random.nextInt(3) < this.rainSoundCounter++) {
                        this.rainSoundCounter = 0;
                        if (d1 > (double)(blockpos.func_177956_o() + 1) && world.func_175725_q(blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                            mc.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f * volAmp, 0.5f, false);
                        } else {
                            mc.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f * volAmp, 1.0f, false);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Weather2: Error handling sound play queue: ");
            ex.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void tryAmbientSounds() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient worldRef = mc.field_71441_e;
        EntityPlayerSP player = mc.field_71439_g;
        Random rand = new Random();
        if (lastTickAmbientThreaded < System.currentTimeMillis()) {
            lastTickAmbientThreaded = System.currentTimeMillis() + 500L;
            int size = 32;
            int hsize = size / 2;
            int curX = (int)player.field_70165_t;
            int curY = (int)player.field_70163_u;
            int curZ = (int)player.field_70161_v;
            for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
                for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                    for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                        Block block = SceneEnhancer.getBlock((World)worldRef, xx, yy, zz);
                        if (block == null) continue;
                        if (ConfigParticle.Wind_Particle_waterfall && block.func_149688_o(block.func_176223_P()) == Material.field_151586_h) {
                            Block id2;
                            int meta = SceneEnhancer.getBlockMetadata((World)worldRef, xx, yy, zz);
                            if ((meta & 8) == 0) continue;
                            int bottomY = yy;
                            int index = 0;
                            while (yy - index > 0 && ((id2 = SceneEnhancer.getBlock((World)worldRef, xx, yy - index, zz)) == null || id2.func_149688_o(id2.func_176223_P()) == Material.field_151586_h)) {
                                ++index;
                            }
                            bottomY = yy - index + 1;
                            int meta2 = SceneEnhancer.getBlockMetadata((World)worldRef, xx, bottomY + 10, zz);
                            Block block2 = SceneEnhancer.getBlock((World)worldRef, xx, bottomY + 10, zz);
                            if (index < 4 || block2 == null || block2.func_149688_o(block2.func_176223_P()) != Material.field_151586_h || (meta2 & 8) == 0) continue;
                            boolean proxFail = false;
                            for (int j = 0; j < soundLocations.size(); ++j) {
                                if (!(Math.sqrt(soundLocations.get(j).getDistanceSquared((double)xx, (double)bottomY, (double)zz)) < 5.0)) continue;
                                proxFail = true;
                                break;
                            }
                            if (proxFail) continue;
                            soundLocations.add(new ChunkCoordinatesBlock(xx, bottomY, zz, SOUNDMARKER_WATER, 0));
                            continue;
                        }
                        if (!(ConfigMisc.volWindTreesScale > 0.0) || block.func_149688_o(block.func_176223_P()) != Material.field_151584_j) continue;
                        boolean proxFail = false;
                        for (int j = 0; j < soundLocations.size(); ++j) {
                            if (!(Math.sqrt(soundLocations.get(j).getDistanceSquared((double)xx, (double)yy, (double)zz)) < 15.0)) continue;
                            proxFail = true;
                            break;
                        }
                        if (proxFail) continue;
                        soundLocations.add(new ChunkCoordinatesBlock(xx, yy, zz, SOUNDMARKER_LEAVES, 0));
                    }
                }
            }
        }
    }

    public void reset() {
        this.lastWorldDetected.field_73007_j.clear();
        if (WeatherUtilParticle.fxLayers == null) {
            WeatherUtilParticle.getFXLayers();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tickParticlePrecipitation() {
        boolean doFish;
        boolean testLeaf;
        boolean particleTest;
        if (!ConfigParticle.Particle_RainSnow) return;
        EntityPlayerSP entP = FMLClientHandler.instance().getClient().field_71439_g;
        if (entP.field_70163_u >= (double)StormObject.static_YPos_layer0) {
            return;
        }
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        float curPrecipVal = SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP);
        float maxPrecip = 0.5f;
        int precipitationHeight = entP.field_70170_p.func_175725_q(new BlockPos(MathHelper.func_76128_c((double)entP.field_70165_t), 0, MathHelper.func_76128_c((double)entP.field_70161_v))).func_177956_o();
        Biome biomegenbase = entP.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)entP.field_70165_t), 0, MathHelper.func_76128_c((double)entP.field_70161_v)));
        World world = entP.field_70170_p;
        Random rand = entP.field_70170_p.field_73012_v;
        double particleAmp = 1.0;
        if (RotatingParticleManager.useShaders && ConfigCoroUtil.particleShaders) {
            particleAmp = ConfigMisc.shaderParticleRateAmplifier;
        }
        if (particleTest = false) {
            BlockPos pos;
            if ((testParticle == null || SceneEnhancer.testParticle.field_187133_m) && SceneEnhancer.canPrecipitateAt(world, pos = new BlockPos((Entity)entP))) {
                ParticleTexExtraRender rain = new ParticleTexExtraRender(entP.field_70170_p, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.test_texture);
                rain.setSlantParticleToWind(false);
                rain.setExtraParticlesBaseAmount(1);
                rain.setSeverityOfRainRate(0);
                rain.setDontRenderUnderTopmostBlock(false);
                boolean upward = rand.nextBoolean();
                rain.windWeight = 999999.0f;
                rain.setFacePlayer(false);
                rain.setScale(90.0f + rand.nextFloat() * 3.0f);
                rain.setScale(5.0f);
                rain.func_187114_a(1600);
                rain.setGravity(0.0f);
                rain.setTicksFadeInMax(20.0f);
                rain.func_82338_g(0.0f);
                rain.setTicksFadeOutMax(20.0f);
                rain.rotationYaw = 0.0f;
                rain.rotationPitch = 90.0f;
                rain.setMotionY(-0.0);
                rain.setMotionX((double)((rand.nextFloat() - 0.5f) * 0.01f));
                rain.setMotionZ((double)((rand.nextFloat() - 0.5f) * 0.01f));
                rain.spawnAsWeatherEffect();
                rain.weatherEffect = false;
                rain.isTransparent = false;
                rain.quatControl = true;
                testParticle = rain;
            }
            if (testParticle != null) {
                SceneEnhancer.testParticle.rotationPitch = 0.0f;
                Quaternion q = testParticle.getQuaternion();
                float amp1 = (float)Math.sin(Math.toRadians(world.func_82737_E() * 1L % 360L));
                float amp2 = (float)Math.cos(Math.toRadians(world.func_82737_E() * 3L % 360L));
                Quaternion qNewRot = new Quaternion();
                qNewRot.setFromAxisAngle(new Vector4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(5.0)));
                if (Keyboard.isKeyDown((int)79)) {
                    // empty if block
                }
                qNewRot = new Quaternion();
                qNewRot.setFromAxisAngle(new Vector4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(5.0)));
                if (Keyboard.isKeyDown((int)80)) {
                    // empty if block
                }
                qNewRot = new Quaternion();
                qNewRot.setFromAxisAngle(new Vector4f(0.0f, 0.0f, 1.0f, (float)Math.toRadians(5.0)));
                if (Keyboard.isKeyDown((int)81)) {
                    // empty if block
                }
                if (Keyboard.isKeyDown((int)82)) {
                    q.setIdentity();
                }
                float scale = 3.0f;
                float xAdj = q.x * scale;
                float yAdj = q.y * scale;
                float zAdj = q.z * scale;
                if (Keyboard.isKeyDown((int)79)) {
                    SceneEnhancer.vec.x = SceneEnhancer.vec.x + (float)Math.toRadians(5.0) * (Keyboard.isKeyDown((int)29) ? -1.0f : 1.0f);
                }
                if (Keyboard.isKeyDown((int)80)) {
                    SceneEnhancer.vec.y = SceneEnhancer.vec.y + (float)Math.toRadians(5.0) * (Keyboard.isKeyDown((int)29) ? -1.0f : 1.0f);
                }
                if (Keyboard.isKeyDown((int)81)) {
                    SceneEnhancer.vec.z = SceneEnhancer.vec.z + (float)Math.toRadians(5.0) * (Keyboard.isKeyDown((int)29) ? -1.0f : 1.0f);
                }
                SceneEnhancer.vec.y += (float)Math.toRadians(30.0);
                float ampz1 = (float)(-Math.sin(Math.toRadians((world.func_82737_E() + 20L) * 5L % 360L))) * 0.3f;
                float ampz2 = (float)Math.cos(Math.toRadians(world.func_82737_E() * 3L % 360L)) * 0.3f;
                ampz1 = (float)(-Math.sin(Math.toRadians(0.0)));
                ampz2 = (float)Math.sin(Math.toRadians(30.0));
                SceneEnhancer.vec.x = ampz1;
                SceneEnhancer.vec.z = ampz2;
                matrix.setIdentity();
                matrix.rotateZ((float)Math.sin(Math.toRadians(world.func_82737_E() * 3L % 360L)) * 0.5f);
                matrix.rotateX((float)Math.sin(Math.toRadians((world.func_82737_E() - 40L) * 3L % 360L)) * 0.5f);
                matrix.rotateY(SceneEnhancer.vec.y);
                matrix.translate(new Vector3f(2.0f, 0.0f, 0.0f));
                if (Keyboard.isKeyDown((int)82)) {
                    vec = new Vector3f();
                    matrix.setIdentity();
                }
                if (Keyboard.isKeyDown((int)76)) {
                    SceneEnhancer.matrix.m30 = 0.0f;
                    SceneEnhancer.matrix.m31 = 0.0f;
                    SceneEnhancer.matrix.m32 = 0.0f;
                    matrix.translate(new Vector3f(3.0f, 0.0f, 0.0f));
                }
                Vector3f pos2 = matrix.getTranslation();
                Vector3f pos22 = matrix2.getTranslation();
                xAdj = -pos2.x;
                yAdj = -pos2.y;
                zAdj = pos2.z;
                if (testParticle2 != null) {
                    testParticle2.func_187109_b(SceneEnhancer.testParticle.field_187126_f + (double)xAdj, SceneEnhancer.testParticle.field_187127_g + (double)yAdj, SceneEnhancer.testParticle.field_187128_h + (double)zAdj);
                }
                testParticle.setAge(40);
                if (testParticle2 != null) {
                    testParticle2.setAge(40000);
                }
            }
            if (testParticle != null) {
                testParticle.setAge(40);
            }
        }
        if (funnel == null) {
            funnel = new TornadoFunnel();
            SceneEnhancer.funnel.pos = new Vec3d(entP.field_70165_t, entP.field_70163_u, entP.field_70161_v);
        }
        if ((testLeaf = false) && (testParticle2 == null || SceneEnhancer.testParticle2.field_187133_m)) {
            BlockPos pos = new BlockPos((Entity)entP);
            ParticleTexLeafColor var31 = new ParticleTexLeafColor(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, ParticleRegistry.leaf);
            var31.func_187109_b((double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            var31.setPrevPosX(var31.field_187126_f);
            var31.setPrevPosY(var31.field_187127_g);
            var31.setPrevPosZ(var31.field_187128_h);
            var31.setMotionX(0.0);
            var31.setMotionY(0.0);
            var31.setMotionZ(0.0);
            var31.setGravity(0.05f);
            var31.setCanCollide(true);
            var31.setKillOnCollide(true);
            var31.killWhenUnderCameraAtLeast = 20;
            var31.killWhenFarFromCameraAtLeast = 20;
            var31.rotationYaw = rand.nextInt(360);
            var31.rotationPitch = rand.nextInt(360);
            testParticle2 = var31;
            var31.spawnAsWeatherEffect();
            ClientTickHandler.weatherManager.addWeatheredParticle((Particle)var31);
        }
        if (doFish = false) {
            int spawnTryMax = 200;
            int range = 60;
            for (int spawnTryCur = 0; spawnTryCur < spawnTryMax; ++spawnTryCur) {
                BlockPos pos = new BlockPos((Vec3i)entP.func_180425_c().func_177982_a(rand.nextInt(range) - rand.nextInt(range), rand.nextInt(range) - rand.nextInt(range), rand.nextInt(range) - rand.nextInt(range)));
                IBlockState state = world.func_180495_p(pos);
                if (state.func_185904_a() != Material.field_151586_h) continue;
                ParticleFish fish = new ParticleFish(entP.field_70170_p, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.0, 0.0, 0.0, (TextureAtlasSprite)ParticleRegistry.listFish.get(rand.nextInt(8) + 1));
                fish.setTicksFadeInMax(20.0f);
                fish.func_82338_g(0.0f);
                fish.setTicksFadeOutMax(20.0f);
                fish.func_187114_a(200);
                fish.setScale(6.0f);
                fish.setDontRenderUnderTopmostBlock(false);
                fish.setGravity(0.0f);
                fish.isTransparent = false;
                fish.field_187130_j = 0.0;
                fish.rotationYaw = rand.nextInt(360);
                fish.rotationPitch = rand.nextInt(45);
                fish.func_70538_b(0.6f, 0.6f, 1.0f);
                ExtendedRenderer.rotEffRenderer.addEffect((Particle)fish);
            }
        }
        if (biomegenbase == null || !biomegenbase.func_76738_d() && !biomegenbase.func_76746_c()) return;
        float temperature = CoroUtilCompatibility.getAdjustedTemperature((World)world, (Biome)biomegenbase, (BlockPos)entP.func_180425_c());
        curPrecipVal = Math.min(maxPrecip, Math.abs(curPrecipVal));
        if (!((curPrecipVal *= 1.0f) > 0.0f)) return;
        int spawnNeed = (int)((double)(curPrecipVal * 40.0f) * ConfigParticle.Precipitation_Particle_effect_rate * particleAmp);
        int safetyCutout = 100;
        int extraRenderCount = 15;
        if ((double)curPrecipVal < 0.1 && ConfigParticle.Precipitation_Particle_effect_rate > 0.0) {
            int oldVal = extraRenderCount;
            extraRenderCount = spawnNeed;
            spawnNeed = oldVal;
        }
        if (entP.field_70170_p.func_72959_q().func_76939_a(temperature, precipitationHeight) >= 0.15f) {
            int spawnCount = 0;
            int spawnAreaSize = 20;
            if (spawnNeed > 0) {
                for (int i = 0; i < safetyCutout; ++i) {
                    BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u - 5.0 + (double)rand.nextInt(25), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                    if (!SceneEnhancer.canPrecipitateAt(world, pos)) continue;
                    ParticleTexExtraRender rain = new ParticleTexExtraRender(entP.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, ParticleRegistry.rain_white);
                    rain.setKillWhenUnderTopmostBlock(true);
                    rain.setCanCollide(false);
                    rain.killWhenUnderCameraAtLeast = 5;
                    rain.setTicksFadeOutMaxOnDeath(5.0f);
                    rain.setDontRenderUnderTopmostBlock(true);
                    rain.setExtraParticlesBaseAmount(extraRenderCount);
                    rain.fastLight = true;
                    rain.setSlantParticleToWind(true);
                    rain.windWeight = 1.0f;
                    if (!RotatingParticleManager.useShaders || !ConfigCoroUtil.particleShaders) {
                        rain.setFacePlayer(true);
                        rain.setSlantParticleToWind(true);
                    } else {
                        rain.setFacePlayer(false);
                        rain.extraYRotation = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                    }
                    rain.setScale(2.0f);
                    rain.isTransparent = true;
                    rain.setGravity(2.5f);
                    rain.func_187114_a(50);
                    rain.setTicksFadeInMax(5.0f);
                    rain.func_82338_g(0.0f);
                    rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                    rain.setMotionY(-0.5);
                    rain.spawnAsWeatherEffect();
                    ClientTickHandler.weatherManager.addWeatheredParticle((Particle)rain);
                    if (++spawnCount >= spawnNeed) break;
                }
            }
            boolean groundSplash = ConfigParticle.Particle_Rain_GroundSplash;
            boolean downfall = ConfigParticle.Particle_Rain_DownfallSheet;
            spawnAreaSize = 40;
            if (groundSplash && (double)curPrecipVal > 0.15) {
                int i = 0;
                while ((double)i < (double)(30.0f * curPrecipVal) * ConfigParticle.Precipitation_Particle_effect_rate * particleAmp * 4.0) {
                    BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u - 5.0 + (double)rand.nextInt(15), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                    pos = world.func_175725_q(pos).func_177977_b();
                    IBlockState state = world.func_180495_p(pos);
                    AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
                    if (!(pos.func_185332_f(MathHelper.func_76128_c((double)entP.field_70165_t), MathHelper.func_76128_c((double)entP.field_70163_u), MathHelper.func_76128_c((double)entP.field_70161_v)) > (double)(spawnAreaSize / 2)) && SceneEnhancer.canPrecipitateAt(world, pos.func_177984_a())) {
                        ParticleTexFX rain = new ParticleTexFX(entP.field_70170_p, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + 0.01 + axisalignedbb.field_72337_e, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.cloud256_6);
                        rain.setKillWhenUnderTopmostBlock(true);
                        rain.setCanCollide(false);
                        rain.killWhenUnderCameraAtLeast = 5;
                        boolean upward = rand.nextBoolean();
                        rain.windWeight = 20.0f;
                        rain.setFacePlayer(upward);
                        rain.setScale(3.0f + rand.nextFloat() * 3.0f);
                        rain.func_187114_a(15);
                        rain.setGravity(-0.0f);
                        rain.setTicksFadeInMax(0.0f);
                        rain.func_82338_g(0.0f);
                        rain.setTicksFadeOutMax(4.0f);
                        rain.renderOrder = 2;
                        rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                        rain.rotationPitch = 90.0f;
                        rain.setMotionY(0.0);
                        rain.setMotionX((double)((rand.nextFloat() - 0.5f) * 0.01f));
                        rain.setMotionZ((double)((rand.nextFloat() - 0.5f) * 0.01f));
                        rain.spawnAsWeatherEffect();
                        ClientTickHandler.weatherManager.addWeatheredParticle((Particle)rain);
                    }
                    ++i;
                }
            }
            spawnAreaSize = 20;
            if (!downfall || !((double)curPrecipVal > 0.32)) return;
            int scanAheadRange = 0;
            scanAheadRange = entP.field_70170_p.func_175710_j(entP.func_180425_c()) ? 3 : 10;
            int i = 0;
            while ((double)i < (double)(2.0f * curPrecipVal) * ConfigParticle.Precipitation_Particle_effect_rate) {
                BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u + 5.0 + (double)rand.nextInt(15), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (!(entP.func_174818_b(pos) < 100.0) && SceneEnhancer.canPrecipitateAt(world, pos.func_177981_b(-scanAheadRange))) {
                    ParticleTexExtraRender rain = new ParticleTexExtraRender(entP.field_70170_p, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)(pos.func_177956_o() - 1) + 0.01, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.downfall3);
                    rain.setCanCollide(false);
                    rain.killWhenUnderCameraAtLeast = 5;
                    rain.setKillWhenUnderTopmostBlock(true);
                    rain.setKillWhenUnderTopmostBlock_ScanAheadRange(scanAheadRange);
                    rain.setTicksFadeOutMaxOnDeath(10.0f);
                    rain.noExtraParticles = true;
                    boolean upward = rand.nextBoolean();
                    rain.windWeight = 8.0f;
                    rain.setFacePlayer(true);
                    rain.setFacePlayer(false);
                    rain.facePlayerYaw = true;
                    rain.setScale(90.0f + rand.nextFloat() * 3.0f);
                    rain.func_187114_a(60);
                    rain.setGravity(0.35f);
                    rain.setTicksFadeInMax(20.0f);
                    rain.func_82338_g(0.0f);
                    rain.setTicksFadeOutMax(20.0f);
                    rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                    rain.rotationPitch = 90.0f;
                    rain.rotationPitch = 0.0f;
                    rain.setMotionY(-0.3);
                    rain.setMotionX((double)((rand.nextFloat() - 0.5f) * 0.01f));
                    rain.setMotionZ((double)((rand.nextFloat() - 0.5f) * 0.01f));
                    rain.spawnAsWeatherEffect();
                    ClientTickHandler.weatherManager.addWeatheredParticle((Particle)rain);
                }
                ++i;
            }
            return;
        } else {
            int spawnCount = 0;
            spawnNeed = (int)((double)(curPrecipVal * 40.0f) * ConfigParticle.Precipitation_Particle_effect_rate * particleAmp);
            int spawnAreaSize = 50;
            if (spawnNeed <= 0) return;
            for (int i = 0; i < safetyCutout; ++i) {
                BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u - 5.0 + (double)rand.nextInt(25), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (!SceneEnhancer.canPrecipitateAt(world, pos)) continue;
                ParticleTexExtraRender snow = new ParticleTexExtraRender(entP.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, ParticleRegistry.snow);
                snow.setCanCollide(false);
                snow.setKillWhenUnderTopmostBlock(true);
                snow.setTicksFadeOutMaxOnDeath(5.0f);
                snow.setDontRenderUnderTopmostBlock(true);
                snow.setExtraParticlesBaseAmount(10);
                snow.killWhenFarFromCameraAtLeast = 20;
                snow.setMotionY(-0.1);
                snow.setScale(1.3f);
                snow.setGravity(0.1f);
                snow.windWeight = 0.2f;
                snow.func_187114_a(40);
                snow.setFacePlayer(false);
                snow.setTicksFadeInMax(5.0f);
                snow.func_82338_g(0.0f);
                snow.setTicksFadeOutMax(5.0f);
                snow.rotationYaw = (float)snow.getWorld().field_73012_v.nextInt(360) - 180.0f;
                snow.spawnAsWeatherEffect();
                ClientTickHandler.weatherManager.addWeatheredParticle((Particle)snow);
                if (++spawnCount >= spawnNeed) return;
            }
        }
    }

    public static boolean canPrecipitateAt(World world, BlockPos strikePosition) {
        return world.func_175725_q(strikePosition).func_177956_o() <= strikePosition.func_177956_o();
    }

    public static float getRainStrengthAndControlVisuals(EntityPlayer entP) {
        return SceneEnhancer.getRainStrengthAndControlVisuals(entP, false);
    }

    public static float getRainStrengthAndControlVisuals(EntityPlayer entP, boolean forOvercast) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        double maxStormDist = 384.0;
        Vec3 plPos = new Vec3(entP.field_70165_t, (double)StormObject.static_YPos_layer0, entP.field_70161_v);
        StormObject storm = null;
        ClientTickHandler.checkClientWeather();
        storm = ClientTickHandler.weatherManager.getClosestStorm(plPos, maxStormDist, StormObject.STATE_FORMING, true);
        if (forOvercast) {
            // empty if block
        }
        boolean closeEnough = false;
        double stormDist = 9999.0;
        float tempAdj = 1.0f;
        float sizeToUse = 0.0f;
        float overcastModeMinPrecip = 0.23f;
        overcastModeMinPrecip = (float)ConfigStorm.Storm_Rain_Overcast_Amount;
        if (storm != null) {
            sizeToUse = storm.size;
            if (forOvercast) {
                sizeToUse *= 1.0f;
            }
            if ((double)sizeToUse > (stormDist = storm.pos.distanceTo(plPos))) {
                closeEnough = true;
            }
        }
        if (closeEnough) {
            double stormIntensity = ((double)sizeToUse - stormDist) / (double)sizeToUse;
            float f = tempAdj = storm.levelTemperature > 0.0f ? 1.0f : -1.0f;
            if (storm.levelCurIntensityStage == StormObject.STATE_NORMAL && stormIntensity > 0.3) {
                stormIntensity = 0.3;
            }
            if (ConfigStorm.Storm_NoRainVisual) {
                stormIntensity = 0.0;
            }
            if (stormIntensity < (double)overcastModeMinPrecip) {
                stormIntensity = overcastModeMinPrecip;
            }
            mc.field_71441_e.func_72912_H().func_76084_b(true);
            mc.field_71441_e.func_72912_H().func_76069_a(true);
            if (forOvercast) {
                curOvercastStrTarget = (float)stormIntensity;
            } else {
                curPrecipStrTarget = (float)stormIntensity;
            }
        } else if (!ClientTickHandler.clientConfigData.overcastMode) {
            mc.field_71441_e.func_72912_H().func_76084_b(false);
            mc.field_71441_e.func_72912_H().func_76069_a(false);
            if (forOvercast) {
                curOvercastStrTarget = 0.0f;
            } else {
                curPrecipStrTarget = 0.0f;
            }
        } else if (ClientTickHandler.weatherManager.isVanillaRainActiveOnServer) {
            mc.field_71441_e.func_72912_H().func_76084_b(true);
            mc.field_71441_e.func_72912_H().func_76069_a(true);
            if (forOvercast) {
                curOvercastStrTarget = overcastModeMinPrecip;
            } else {
                curPrecipStrTarget = overcastModeMinPrecip;
            }
        } else if (forOvercast) {
            curOvercastStrTarget = 0.0f;
        } else {
            curPrecipStrTarget = 0.0f;
        }
        if (forOvercast) {
            if ((double)curOvercastStr < 0.001 && curOvercastStr > -0.001f) {
                return 0.0f;
            }
            return curOvercastStr * tempAdj;
        }
        if ((double)curPrecipStr < 0.001 && curPrecipStr > -0.001f) {
            return 0.0f;
        }
        return curPrecipStr * tempAdj;
    }

    public static void tickRainRates() {
        float rateChange = 5.0E-4f;
        if (curOvercastStr > curOvercastStrTarget) {
            curOvercastStr -= rateChange;
        } else if (curOvercastStr < curOvercastStrTarget) {
            curOvercastStr += rateChange;
        }
        if (curPrecipStr > curPrecipStrTarget) {
            curPrecipStr -= rateChange;
        } else if (curPrecipStr < curPrecipStrTarget) {
            curPrecipStr += rateChange;
        }
    }

    public static float getPrecipStrength(EntityPlayer entP, boolean forOvercast) {
        StormObject storm = SceneEnhancer.getClosestStormCached(entP);
        if (storm != null) {
            float tempAdj;
            float f = tempAdj = storm.levelTemperature > 0.0f ? 1.0f : -1.0f;
            if (forOvercast) {
                return curOvercastStr * tempAdj;
            }
            return curPrecipStr * tempAdj;
        }
        return 0.0f;
    }

    public static void controlVanillaPrecipVisuals(EntityPlayer entP, boolean forOvercast) {
    }

    public static StormObject getClosestStormCached(EntityPlayer entP) {
        if (WeatherManagerClient.closestStormCached == null || entP.field_70170_p.func_82737_E() % 5L == 0L) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            double maxStormDist = 384.0;
            Vec3 plPos = new Vec3(entP.field_70165_t, (double)StormObject.static_YPos_layer0, entP.field_70161_v);
            ClientTickHandler.checkClientWeather();
            WeatherManagerClient.closestStormCached = ClientTickHandler.weatherManager.getClosestStorm(plPos, maxStormDist, StormObject.STATE_FORMING, true);
        }
        return WeatherManagerClient.closestStormCached;
    }

    public synchronized void tryParticleSpawning() {
        if (spawnQueue.size() > 0) {
            // empty if block
        }
        try {
            Particle ent;
            int i;
            for (i = 0; i < spawnQueue.size(); ++i) {
                ent = spawnQueue.get(i);
                if (ent == null) continue;
                if (ent instanceof EntityRotFX) {
                    ((EntityRotFX)ent).spawnAsWeatherEffect();
                }
                ClientTickHandler.weatherManager.addWeatheredParticle(ent);
            }
            for (i = 0; i < spawnQueueNormal.size(); ++i) {
                ent = spawnQueueNormal.get(i);
                if (ent == null) continue;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ent);
            }
        }
        catch (Exception ex) {
            CULog.err((String)"Weather2: Error handling particle spawn queue: ");
            ex.printStackTrace();
        }
        spawnQueue.clear();
        spawnQueueNormal.clear();
    }

    public void profileSurroundings() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        World worldRef = this.lastWorldDetected;
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        WeatherManagerClient manager = ClientTickHandler.weatherManager;
        if (worldRef == null || player == null || manager == null || manager.windMan == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (threadLastWorldTickTime == worldRef.func_82737_E()) {
            return;
        }
        threadLastWorldTickTime = worldRef.func_82737_E();
        Random rand = new Random();
        int size = 40;
        int hsize = size / 2;
        int curX = (int)player.field_70165_t;
        int curY = (int)player.field_70163_u;
        int curZ = (int)player.field_70161_v;
        float windStr = manager.windMan.getWindSpeedForPriority();
        if (!ConfigParticle.Wind_Particle_leafs && !ConfigParticle.Wind_Particle_waterfall) {
            return;
        }
        int spawnRate = (int)(30.0 / ((double)windStr + 0.001));
        float lastBlockCount = lastTickFoundBlocks;
        float particleCreationRate = (float)ConfigParticle.Wind_Particle_effect_rate;
        float maxScaleSample = 15000.0f;
        if (lastBlockCount > maxScaleSample) {
            lastBlockCount = maxScaleSample - 1.0f;
        }
        float scaleRate = (maxScaleSample - lastBlockCount) / maxScaleSample;
        spawnRate = (int)((float)spawnRate / (scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        int BlockCountRate = (int)((300.0f / scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        spawnRate *= mc.field_71474_y.field_74362_aa + 1;
        BlockCountRate *= mc.field_71474_y.field_74362_aa + 1;
        if ((spawnRate /= 2) < 40) {
            spawnRate = 40;
        }
        if (BlockCountRate < 80) {
            BlockCountRate = 80;
        }
        if (BlockCountRate > 5000) {
            BlockCountRate = 5000;
        }
        lastTickFoundBlocks = 0;
        double particleAmp = 1.0;
        if (RotatingParticleManager.useShaders && ConfigCoroUtil.particleShaders) {
            particleAmp = ConfigMisc.shaderParticleRateAmplifier * 2.0;
        }
        spawnRate = (int)((double)spawnRate / particleAmp);
        for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
            for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                    Block block = SceneEnhancer.getBlock(worldRef, xx, yy, zz);
                    if (block != null && (block.func_149688_o(block.func_176223_P()) == Material.field_151584_j || block.func_149688_o(block.func_176223_P()) == Material.field_151582_l || block.func_149688_o(block.func_176223_P()) == Material.field_151585_k)) {
                        ++lastTickFoundBlocks;
                        if (worldRef.field_73012_v.nextInt(spawnRate) != 0 || !ConfigParticle.Wind_Particle_leafs) continue;
                        double relAdj = 0.7;
                        BlockPos pos = SceneEnhancer.getRandomWorkingPos(worldRef, new BlockPos(xx, yy, zz));
                        double xRand = 0.0;
                        double yRand = 0.0;
                        double zRand = 0.0;
                        if (pos == null) continue;
                        float particleAABB = 0.1f;
                        float particleAABBAndBuffer = particleAABB + 0.05f;
                        float invert = 1.0f - particleAABBAndBuffer * 2.0f;
                        if (pos.func_177956_o() != 0) {
                            xRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                            zRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                        } else if (pos.func_177958_n() != 0) {
                            yRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                            zRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                        } else if (pos.func_177952_p() != 0) {
                            yRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                            xRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                        }
                        ParticleTexLeafColor var31 = new ParticleTexLeafColor(worldRef, (double)xx, (double)yy, (double)zz, 0.0, 0.0, 0.0, ParticleRegistry.leaf);
                        var31.func_187109_b((double)xx + 0.5 + (double)pos.func_177958_n() * relAdj + xRand, (double)yy + 0.5 + (double)pos.func_177956_o() * relAdj + yRand, (double)zz + 0.5 + (double)pos.func_177952_p() * relAdj + zRand);
                        var31.setPrevPosX(var31.field_187126_f);
                        var31.setPrevPosY(var31.field_187127_g);
                        var31.setPrevPosZ(var31.field_187128_h);
                        var31.setMotionX(0.0);
                        var31.setMotionY(0.0);
                        var31.setMotionZ(0.0);
                        var31.func_187115_a(particleAABB, particleAABB);
                        var31.setGravity(0.05f);
                        var31.setCanCollide(true);
                        var31.setKillOnCollide(false);
                        var31.collisionSpeedDampen = false;
                        var31.killWhenUnderCameraAtLeast = 20;
                        var31.killWhenFarFromCameraAtLeast = 20;
                        var31.isTransparent = false;
                        var31.rotationYaw = rand.nextInt(360);
                        var31.rotationPitch = rand.nextInt(360);
                        var31.updateQuaternion(null);
                        spawnQueue.add((Particle)var31);
                        continue;
                    }
                    if (ConfigParticle.Wind_Particle_waterfall && player.func_70011_f((double)xx, (double)yy, (double)zz) < 16.0 && block != null && block.func_149688_o(block.func_176223_P()) == Material.field_151586_h) {
                        int meta = SceneEnhancer.getBlockMetadata(worldRef, xx, yy, zz);
                        if ((meta & 8) == 0) continue;
                        lastTickFoundBlocks += 70;
                        int chance = (int)(1.0f + (float)BlockCountRate / 120.0f);
                        Block block2 = SceneEnhancer.getBlock(worldRef, xx, yy - 1, zz);
                        int meta2 = SceneEnhancer.getBlockMetadata(worldRef, xx, yy - 1, zz);
                        Block block3 = SceneEnhancer.getBlock(worldRef, xx, yy + 10, zz);
                        if ((block2 != null && block2.func_149688_o(block2.func_176223_P()) == Material.field_151586_h && (meta2 & 8) != 0 || block3 == null || block3.func_149688_o(block3.func_176223_P()) != Material.field_151586_h) && worldRef.field_73012_v.nextInt(chance) != 0) continue;
                        float range = 0.5f;
                        EntityWaterfallFX waterP = new EntityWaterfallFX(worldRef, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), 0.0, 0.0, 0.0, 6.0, 2);
                        if ((block2 == null || block2.func_149688_o(block2.func_176223_P()) != Material.field_151586_h || (meta2 & 8) == 0) && block3 != null && block3.func_149688_o(block3.func_176223_P()) == Material.field_151586_h) {
                            range = 2.0f;
                            float speed = 0.2f;
                            for (int i = 0; i < 10; ++i) {
                                if (worldRef.field_73012_v.nextInt(chance / 2) != 0) continue;
                                waterP = new EntityWaterfallFX(worldRef, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + (double)0.7f + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), rand.nextFloat() * speed - speed / 2.0f, rand.nextFloat() * speed - speed / 2.0f, rand.nextFloat() * speed - speed / 2.0f, 2.0, 3);
                                waterP.setMotionY(4.5);
                                spawnQueueNormal.add((Particle)waterP);
                            }
                            continue;
                        }
                        waterP = new EntityWaterfallFX(worldRef, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), 0.0, 0.0, 0.0, 6.0, 2);
                        waterP.setMotionY(0.5);
                        spawnQueueNormal.add((Particle)waterP);
                        continue;
                    }
                    if (!ConfigParticle.Wind_Particle_fire || block == null || block != Blocks.field_150480_ab) continue;
                    ++lastTickFoundBlocks;
                    if (worldRef.field_73012_v.nextInt(Math.max(1, spawnRate / 100)) != 0) continue;
                    double speed = 0.15;
                    EntityRotFX entityfx = pm.spawnNewParticleIconFX(worldRef, ParticleRegistry.smoke, (double)xx + rand.nextDouble(), (double)yy + 0.2 + rand.nextDouble() * 0.2, (double)zz + rand.nextDouble(), (rand.nextDouble() - rand.nextDouble()) * speed, 0.03, (rand.nextDouble() - rand.nextDouble()) * speed);
                    ParticleBehaviors.setParticleRandoms((EntityRotFX)entityfx, (boolean)true, (boolean)true);
                    ParticleBehaviors.setParticleFire((EntityRotFX)entityfx);
                    entityfx.func_187114_a(100 + rand.nextInt(300));
                    spawnQueueNormal.add((Particle)entityfx);
                }
            }
        }
    }

    public static BlockPos getRandomWorkingPos(World world, BlockPos posOrigin) {
        Collections.shuffle(listPosRandom);
        for (BlockPos posRel : listPosRandom) {
            Block blockCheck = SceneEnhancer.getBlock(world, posOrigin.func_177971_a((Vec3i)posRel));
            if (blockCheck == null || !CoroUtilBlock.isAir((Block)blockCheck)) continue;
            return posRel;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void tryWind(World world) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        int dist = 60;
        List list = world.field_72996_f;
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        Random rand = new Random();
        int handleCount = 0;
        if (world.func_82737_E() % 60L == 0L) {
            // empty if block
        }
        for (int i = 0; i < ClientTickHandler.weatherManager.listWeatherEffectedParticles.size(); ++i) {
            EntityRotFX entity1;
            Particle particle = ClientTickHandler.weatherManager.listWeatherEffectedParticles.get(i);
            if (!particle.func_187113_k()) {
                ClientTickHandler.weatherManager.listWeatherEffectedParticles.remove(i--);
                continue;
            }
            if (!((double)ClientTickHandler.weatherManager.windMan.getWindSpeedForPriority() >= 0.1)) continue;
            ++handleCount;
            if (!(particle instanceof EntityRotFX) || (entity1 = (EntityRotFX)particle) == null) continue;
            if (WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(MathHelper.func_76128_c((double)entity1.getPosX()), 0, MathHelper.func_76128_c((double)entity1.getPosZ()))).func_177956_o() - 1 < (int)entity1.getPosY() + 1 || entity1 instanceof ParticleTexFX) {
                if (entity1 instanceof IWindHandler) {
                    if (entity1.getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge((Particle)entity1) % 2 == 0) {
                        WeatherUtilParticle.setParticleAge((Particle)entity1, WeatherUtilParticle.getParticleAge((Particle)entity1) + entity1.getParticleDecayExtra());
                    }
                } else if (WeatherUtilParticle.getParticleAge((Particle)entity1) % 2 == 0) {
                    WeatherUtilParticle.setParticleAge((Particle)entity1, WeatherUtilParticle.getParticleAge((Particle)entity1) + 1);
                }
                if (entity1 instanceof ParticleTexFX && ((ParticleTexFX)entity1).getParticleTexture() == ParticleRegistry.leaf) {
                    if (entity1.getMotionX() < (double)0.01f && entity1.getMotionZ() < (double)0.01f) {
                        entity1.setMotionY(entity1.getMotionY() + rand.nextDouble() * 0.02 * (double)((ParticleTexFX)entity1).field_70545_g);
                    }
                    entity1.setMotionY(entity1.getMotionY() - (double)(0.01f * ((ParticleTexFX)entity1).field_70545_g));
                }
            }
            windMan.applyWindForceNew(entity1, 0.05f, 0.5f);
        }
        if (WeatherUtilParticle.fxLayers != null && (double)windMan.getWindSpeedForPriority() >= 0.1) {
            for (int layer = 0; layer < WeatherUtilParticle.fxLayers.length; ++layer) {
                for (int i = 0; i < WeatherUtilParticle.fxLayers[layer].length; ++i) {
                    for (Particle entity1 : WeatherUtilParticle.fxLayers[layer][i]) {
                        String className;
                        if (ConfigParticle.Particle_VanillaAndWeatherOnly && !(className = entity1.getClass().getName()).contains("net.minecraft.") && !className.contains("weather2.") || WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(MathHelper.func_76128_c((double)CoroUtilEntOrParticle.getPosX((Object)entity1)), 0, MathHelper.func_76128_c((double)CoroUtilEntOrParticle.getPosZ((Object)entity1)))).func_177956_o() - 1 >= (int)CoroUtilEntOrParticle.getPosY((Object)entity1) + 1 && !(entity1 instanceof ParticleTexFX)) continue;
                        if (entity1 instanceof ParticleFlame) {
                            if ((double)windMan.getWindSpeedForPriority() >= 0.2) {
                                ++entity1.field_70546_d;
                            }
                        } else if (entity1 instanceof IWindHandler && ((IWindHandler)entity1).getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge(entity1) % 2 == 0) {
                            entity1.field_70546_d += ((IWindHandler)entity1).getParticleDecayExtra();
                        }
                        if (!(entity1 instanceof EntityWaterfallFX) && CoroUtilEntOrParticle.getMotionX((Object)entity1) < (double)0.01f && CoroUtilEntOrParticle.getMotionZ((Object)entity1) < (double)0.01f) {
                            CoroUtilEntOrParticle.setMotionY((Object)entity1, (double)(CoroUtilEntOrParticle.getMotionY((Object)entity1) + rand.nextDouble() * 0.02));
                        }
                        windMan.applyWindForceNew(entity1, 0.05f, 0.5f);
                    }
                }
            }
        }
        float volScaleFar = windMan.getWindSpeedForPriority() * 1.0f;
        if (windMan.getWindSpeedForPriority() <= 0.07f) {
            volScaleFar = 0.0f;
        }
        volScaleFar = (float)((double)volScaleFar * ConfigMisc.volWindScale);
    }

    @SideOnly(value=Side.CLIENT)
    private static Block getBlock(World parWorld, BlockPos pos) {
        return SceneEnhancer.getBlock(parWorld, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    private static Block getBlock(World parWorld, int x, int y, int z) {
        try {
            if (!parWorld.func_175667_e(new BlockPos(x, 0, z))) {
                return null;
            }
            return parWorld.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static int getBlockMetadata(World parWorld, int x, int y, int z) {
        if (!parWorld.func_175667_e(new BlockPos(x, 0, z))) {
            return 0;
        }
        IBlockState state = parWorld.func_180495_p(new BlockPos(x, y, z));
        return state.func_177230_c().func_176201_c(state);
    }

    public static void tickTest() {
        Minecraft mc = Minecraft.func_71410_x();
        if (miniTornado == null) {
            miniTornado = new ParticleBehaviorMiniTornado(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v));
        }
        for (int i = 0; i < 1; ++i) {
            ParticleTexFX part = new ParticleTexFX((World)mc.field_71441_e, SceneEnhancer.miniTornado.coordSource.xCoord, SceneEnhancer.miniTornado.coordSource.yCoord, SceneEnhancer.miniTornado.coordSource.zCoord, 0.0, 0.0, 0.0, ParticleRegistry.squareGrey);
            miniTornado.initParticle((EntityRotFX)part);
            SceneEnhancer.miniTornado.particles.add(part);
            part.spawnAsWeatherEffect();
        }
        miniTornado.tickUpdateList();
        double x = 5.0;
        double z = 5.0;
        double x2 = 5.0;
        double z2 = 0.0;
        double vecX = x - x2;
        double vecZ = z - z2;
        double what = Math.atan2(vecZ, vecX);
    }

    public static void tickTestFog() {
        Minecraft mc = Minecraft.func_71410_x();
        if (particleBehaviorFog == null) {
            particleBehaviorFog = new ParticleBehaviorFogGround(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v));
        } else {
            SceneEnhancer.particleBehaviorFog.coordSource = new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u + 0.5, mc.field_71439_g.field_70161_v);
        }
        if (mc.field_71441_e.func_82737_E() % 300L == 0L && SceneEnhancer.particleBehaviorFog.particles.size() <= 10000) {
            for (int i = 0; i < 1; ++i) {
                ParticleTexFX part = new ParticleTexFX((World)mc.field_71441_e, SceneEnhancer.particleBehaviorFog.coordSource.xCoord, SceneEnhancer.particleBehaviorFog.coordSource.yCoord, SceneEnhancer.particleBehaviorFog.coordSource.zCoord, 0.0, 0.0, 0.0, ParticleRegistry.cloud256);
                part.setMotionX(-1.0);
                part.setMotionY(0.1);
                particleBehaviorFog.initParticle((EntityRotFX)part);
                part.spawnAsWeatherEffect();
                part.windWeight = 5.0f;
                part.debugID = 1;
                part.func_187114_a(280);
                part.setVanillaMotionDampen(false);
                ClientTickHandler.weatherManager.addWeatheredParticle((Particle)part);
            }
        }
        particleBehaviorFog.tickUpdateList();
    }

    public static void tickTestSandstormParticles() {
        Minecraft mc = Minecraft.func_71410_x();
        if (vecWOP == null) {
            particleBehaviorFog = new ParticleBehaviorFogGround(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v));
            vecWOP = new Vec3d(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
        }
        for (int i = 0; i < 0; ++i) {
            ParticleTexFX part = new ParticleTexFX((World)mc.field_71441_e, SceneEnhancer.vecWOP.field_72450_a, SceneEnhancer.vecWOP.field_72448_b, SceneEnhancer.vecWOP.field_72449_c, 0.0, 0.0, 0.0, ParticleRegistry.cloud256);
            particleBehaviorFog.initParticle((EntityRotFX)part);
            part.setFacePlayer(false);
            part.spawnAsWeatherEffect();
        }
        boolean derp = false;
        if (derp) {
            IBlockState state = mc.field_71441_e.func_180495_p(new BlockPos(mc.field_71439_g.field_70165_t, mc.field_71439_g.func_174813_aQ().field_72338_b - 1.0, mc.field_71439_g.field_70161_v));
            int id = Block.func_176210_f((IBlockState)state);
            id = 12520;
            double speed = 0.2;
            Random rand = mc.field_71441_e.field_73012_v;
            mc.field_71441_e.func_175688_a(EnumParticleTypes.BLOCK_DUST, mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v, (rand.nextDouble() - rand.nextDouble()) * speed, rand.nextDouble() * speed * 2.0, (rand.nextDouble() - rand.nextDouble()) * speed, new int[]{id});
        }
    }

    public static void tickSandstorm() {
        if (adjustAmountTargetPocketSandOverride > 0.0f) {
            adjustAmountTargetPocketSandOverride -= 0.01f;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        Vec3 posPlayer = new Vec3(mc.field_71439_g.field_70165_t, 0.0, mc.field_71439_g.field_70161_v);
        WeatherObjectSandstorm sandstorm = ClientTickHandler.weatherManager.getClosestSandstormByIntensity(posPlayer);
        WindManager windMan = ClientTickHandler.weatherManager.getWindManager();
        float scaleIntensityTarget = 0.0f;
        if (sandstorm != null) {
            if (mc.field_71441_e.func_82737_E() % 40L == 0L) {
                isPlayerOutside = WeatherUtilEntity.isEntityOutside((Entity)mc.field_71439_g);
            }
            scaleIntensityTarget = sandstorm.getSandstormScale();
            List<Vec3> points = sandstorm.getSandstormAsShape();
            boolean inStorm = CoroUtilPhysics.isInConvexShape((Vec3)posPlayer, points);
            distToStorm = inStorm ? 0.0 : CoroUtilPhysics.getDistanceToShape((Vec3)posPlayer, points);
        } else {
            distToStorm = distToStormThreshold + 10.0;
        }
        scaleIntensitySmooth = CoroUtilMisc.adjVal((float)scaleIntensitySmooth, (float)scaleIntensityTarget, (float)0.01f);
        float fogColorChangeRate = 0.01f;
        float fogDistChangeRate = 2.0f;
        float fogDensityChangeRate = 0.01f;
        adjustAmountTarget = 1.0f - (float)(distToStorm / distToStormThreshold);
        adjustAmountTarget *= 2.0f * scaleIntensitySmooth * (isPlayerOutside ? 1.0f : 0.5f);
        boolean pocketSandOverride = false;
        if (adjustAmountTarget < adjustAmountTargetPocketSandOverride) {
            adjustAmountTarget = adjustAmountTargetPocketSandOverride;
            pocketSandOverride = true;
        }
        if (adjustAmountTarget < 0.0f) {
            adjustAmountTarget = 0.0f;
        }
        if (adjustAmountTarget > 1.0f) {
            adjustAmountTarget = 1.0f;
        }
        float sunBrightness = mc.field_71441_e.func_72971_b(1.0f) * 1.0f;
        adjustAmountSmooth = !pocketSandOverride ? (adjustAmountSmooth < adjustAmountTarget ? CoroUtilMisc.adjVal((float)adjustAmountSmooth, (float)adjustAmountTarget, (float)0.003f) : CoroUtilMisc.adjVal((float)adjustAmountSmooth, (float)adjustAmountTarget, (float)0.002f)) : CoroUtilMisc.adjVal((float)adjustAmountSmooth, (float)adjustAmountTarget, (float)0.02f);
        EventHandler.sandstormFogAmount = adjustAmountSmooth;
        if (mc.field_71441_e.func_82737_E() % 20L != 0L || adjustAmountSmooth > 0.0f) {
            // empty if block
        }
        if (adjustAmountSmooth > 0.0f) {
            if (needFogState) {
                try {
                    Object fogState = ObfuscationReflectionHelper.getPrivateValue(GlStateManager.class, null, (String[])new String[]{"field_179155_g"});
                    Class<?> innerClass = Class.forName("net.minecraft.client.renderer.GlStateManager$FogState");
                    Field fieldDensity = null;
                    Field fieldStart = null;
                    Field fieldEnd = null;
                    try {
                        fieldDensity = innerClass.getField("field_179048_c");
                        fieldDensity.setAccessible(true);
                        fieldStart = innerClass.getField("field_179045_d");
                        fieldStart.setAccessible(true);
                        fieldEnd = innerClass.getField("field_179046_e");
                        fieldEnd.setAccessible(true);
                    }
                    catch (Exception e) {
                        fieldDensity = innerClass.getField("density");
                        fieldDensity.setAccessible(true);
                        fieldStart = innerClass.getField("start");
                        fieldStart.setAccessible(true);
                        fieldEnd = innerClass.getField("end");
                        fieldEnd.setAccessible(true);
                    }
                    stormFogDensity = fieldDensity.getFloat(fogState);
                    stormFogStart = fieldStart.getFloat(fogState);
                    stormFogEnd = fieldEnd.getFloat(fogState);
                    stormFogStartClouds = 0.0f;
                    stormFogEndClouds = 192.0f;
                    stormFogStartOrig = stormFogStart;
                    stormFogEndOrig = stormFogEnd;
                    stormFogStartCloudsOrig = stormFogStartClouds;
                    stormFogEndCloudsOrig = stormFogEndClouds;
                    stormFogDensityOrig = stormFogDensity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                needFogState = false;
            }
            stormFogRed = stormFogRedOrig + -(stormFogRedOrig - 0.7f * sunBrightness) * adjustAmountSmooth;
            stormFogGreen = stormFogGreenOrig + -(stormFogGreenOrig - 0.5f * sunBrightness) * adjustAmountSmooth;
            stormFogBlue = stormFogBlueOrig + -(stormFogBlueOrig - 0.25f * sunBrightness) * adjustAmountSmooth;
            stormFogDensity = stormFogDensityOrig + -(stormFogDensityOrig - 0.02f) * adjustAmountSmooth;
            stormFogStart = stormFogStartOrig + -(stormFogStartOrig - 0.0f) * adjustAmountSmooth;
            stormFogEnd = stormFogEndOrig + -(stormFogEndOrig - 7.0f) * adjustAmountSmooth;
            stormFogStartClouds = stormFogStartCloudsOrig + -(stormFogStartCloudsOrig - 0.0f) * adjustAmountSmooth;
            stormFogEndClouds = stormFogEndCloudsOrig + -(stormFogEndCloudsOrig - 20.0f) * adjustAmountSmooth;
        } else {
            if (!needFogState) {
                // empty if block
            }
            needFogState = true;
        }
        if (adjustAmountSmooth > 0.75f && sandstorm != null) {
            float brightnessMulti;
            ParticleSandstorm part;
            TextureAtlasSprite sprite;
            BlockPos pos;
            Vec3 windForce = windMan.getWindForce();
            Random rand = mc.field_71441_e.field_73012_v;
            int spawnAreaSize = 80;
            double sandstormParticleRateDebris = ConfigParticle.Sandstorm_Particle_Debris_effect_rate;
            double sandstormParticleRateDust = ConfigParticle.Sandstorm_Particle_Dust_effect_rate;
            float adjustAmountSmooth75 = adjustAmountSmooth * 8.0f - 7.0f;
            int i = 0;
            while ((double)i < (double)(30.0f * adjustAmountSmooth75) * sandstormParticleRateDust) {
                pos = new BlockPos(player.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), player.field_70163_u - 2.0 + (double)rand.nextInt(10), player.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (SceneEnhancer.canPrecipitateAt((World)world, pos)) {
                    sprite = ParticleRegistry.cloud256;
                    part = new ParticleSandstorm((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle((EntityRotFX)part);
                    part.setMotionX(windForce.xCoord);
                    part.setMotionZ(windForce.zCoord);
                    part.setFacePlayer(false);
                    part.isTransparent = true;
                    part.rotationYaw = rand.nextInt(360);
                    part.rotationPitch = rand.nextInt(360);
                    part.func_187114_a(40);
                    part.setGravity(0.09f);
                    part.func_82338_g(0.0f);
                    brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
                    part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
                    part.setScale(40.0f);
                    part.aboveGroundHeight = 0.2;
                    part.setKillOnCollide(true);
                    part.windWeight = 1.0f;
                    SceneEnhancer.particleBehavior.particles.add(part);
                    ClientTickHandler.weatherManager.addWeatheredParticle((Particle)part);
                    part.spawnAsWeatherEffect();
                }
                ++i;
            }
            i = 0;
            while ((double)i < (double)(1.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                pos = new BlockPos(player.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), player.field_70163_u - 2.0 + (double)rand.nextInt(10), player.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (SceneEnhancer.canPrecipitateAt((World)world, pos)) {
                    sprite = ParticleRegistry.tumbleweed;
                    part = new ParticleSandstorm((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle((EntityRotFX)part);
                    part.setMotionX(windForce.xCoord);
                    part.setMotionZ(windForce.zCoord);
                    part.setFacePlayer(true);
                    part.isTransparent = true;
                    part.rotationYaw = rand.nextInt(360);
                    part.rotationPitch = rand.nextInt(360);
                    part.func_187114_a(80);
                    part.setGravity(0.3f);
                    part.func_82338_g(0.0f);
                    brightnessMulti = 1.0f - rand.nextFloat() * 0.2f;
                    part.func_70538_b(1.0f * brightnessMulti, 1.0f * brightnessMulti, 1.0f * brightnessMulti);
                    part.setScale(8.0f);
                    part.aboveGroundHeight = 0.5;
                    part.collisionSpeedDampen = false;
                    part.bounceSpeed = 0.03;
                    part.bounceSpeedAhead = 0.03;
                    part.setKillOnCollide(false);
                    part.windWeight = 1.0f;
                    SceneEnhancer.particleBehavior.particles.add(part);
                    ClientTickHandler.weatherManager.addWeatheredParticle((Particle)part);
                    part.spawnAsWeatherEffect();
                }
                ++i;
            }
            i = 0;
            while ((double)i < (double)(8.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                pos = new BlockPos(player.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), player.field_70163_u - 2.0 + (double)rand.nextInt(10), player.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (SceneEnhancer.canPrecipitateAt((World)world, pos)) {
                    sprite = null;
                    int tex = rand.nextInt(3);
                    if (tex == 0) {
                        sprite = ParticleRegistry.debris_1;
                    } else if (tex == 1) {
                        sprite = ParticleRegistry.debris_2;
                    } else if (tex == 2) {
                        sprite = ParticleRegistry.debris_3;
                    }
                    ParticleSandstorm part2 = new ParticleSandstorm((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle((EntityRotFX)part2);
                    part2.setMotionX(windForce.xCoord);
                    part2.setMotionZ(windForce.zCoord);
                    part2.setFacePlayer(false);
                    part2.spinFast = true;
                    part2.isTransparent = true;
                    part2.rotationYaw = rand.nextInt(360);
                    part2.rotationPitch = rand.nextInt(360);
                    part2.func_187114_a(80);
                    part2.setGravity(0.3f);
                    part2.func_82338_g(0.0f);
                    float brightnessMulti2 = 1.0f - rand.nextFloat() * 0.5f;
                    part2.func_70538_b(1.0f * brightnessMulti2, 1.0f * brightnessMulti2, 1.0f * brightnessMulti2);
                    part2.setScale(8.0f);
                    part2.aboveGroundHeight = 0.5;
                    part2.collisionSpeedDampen = false;
                    part2.bounceSpeed = 0.03;
                    part2.bounceSpeedAhead = 0.03;
                    part2.setKillOnCollide(false);
                    part2.windWeight = 1.0f;
                    SceneEnhancer.particleBehavior.particles.add(part2);
                    ClientTickHandler.weatherManager.addWeatheredParticle((Particle)part2);
                    part2.spawnAsWeatherEffect();
                }
                ++i;
            }
        }
        SceneEnhancer.tickSandstormSound();
    }

    public static void tickSandstormSound() {
        Minecraft mc = Minecraft.func_71410_x();
        if (adjustAmountSmooth > 0.0f) {
            if (adjustAmountSmooth < 0.33f) {
                SceneEnhancer.tryPlayPlayerLockedSound(WeatherUtilSound.snd_sandstorm_low, 5, (Entity)mc.field_71439_g, 1.0f);
            } else if (adjustAmountSmooth < 0.66f) {
                SceneEnhancer.tryPlayPlayerLockedSound(WeatherUtilSound.snd_sandstorm_med, 4, (Entity)mc.field_71439_g, 1.0f);
            } else {
                SceneEnhancer.tryPlayPlayerLockedSound(WeatherUtilSound.snd_sandstorm_high, 3, (Entity)mc.field_71439_g, 1.0f);
            }
        }
    }

    public static boolean tryPlayPlayerLockedSound(String[] sound, int arrIndex, Entity source, float vol) {
        Random rand = new Random();
        if (WeatherUtilSound.soundTimer[arrIndex] <= System.currentTimeMillis()) {
            String soundStr = sound[WeatherUtilSound.snd_rand[arrIndex]];
            WeatherUtilSound.playPlayerLockedSound(new Vec3(source.func_174791_d()), "streaming." + soundStr, vol, 1.0f);
            int length = WeatherUtilSound.soundToLength.get(soundStr);
            WeatherUtilSound.soundTimer[arrIndex] = System.currentTimeMillis() + (long)length - 500L;
            WeatherUtilSound.snd_rand[arrIndex] = rand.nextInt(sound.length);
        }
        return false;
    }

    public static boolean isFogOverridding() {
        Minecraft mc = Minecraft.func_71410_x();
        IBlockState iblockstate = ActiveRenderInfo.func_186703_a((World)mc.field_71441_e, (Entity)mc.func_175606_aa(), (float)1.0f);
        if (iblockstate.func_185904_a().func_76224_d()) {
            return false;
        }
        return adjustAmountSmooth > 0.0f;
    }

    public static void renderWorldLast(RenderWorldLastEvent event) {
    }

    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (ConfigMisc.Client_PotatoPC_Mode) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            EntityPlayerSP entP = mc.field_71439_g;
            if (entP != null) {
                float curRainStr = SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP, true);
                curRainStr = Math.abs(curRainStr);
                mc.field_71441_e.func_72894_k(curRainStr);
            }
        }
    }

    static {
        spawnQueueNormal = new ArrayList<Particle>();
        spawnQueue = new ArrayList<Particle>();
        soundLocations = new ArrayList();
        soundTimeLocations = new HashMap();
        SOUNDMARKER_WATER = Blocks.field_150355_j;
        SOUNDMARKER_LEAVES = Blocks.field_150362_t;
        curPrecipStr = 0.0f;
        curPrecipStrTarget = 0.0f;
        curOvercastStr = 0.0f;
        curOvercastStrTarget = 0.0f;
        vecWOP = null;
        distToStormThreshold = 100.0;
        distToStorm = distToStormThreshold + 50.0;
        stormFogRed = 0.0f;
        stormFogGreen = 0.0f;
        stormFogBlue = 0.0f;
        stormFogRedOrig = 0.0f;
        stormFogGreenOrig = 0.0f;
        stormFogBlueOrig = 0.0f;
        stormFogDensity = 0.0f;
        stormFogDensityOrig = 0.0f;
        stormFogStart = 0.0f;
        stormFogEnd = 0.0f;
        stormFogStartOrig = 0.0f;
        stormFogEndOrig = 0.0f;
        stormFogStartClouds = 0.0f;
        stormFogEndClouds = 0.0f;
        stormFogStartCloudsOrig = 0.0f;
        stormFogEndCloudsOrig = 0.0f;
        needFogState = true;
        scaleIntensityTarget = 0.0f;
        scaleIntensitySmooth = 0.0f;
        adjustAmountTarget = 0.0f;
        adjustAmountSmooth = 0.0f;
        adjustAmountTargetPocketSandOverride = 0.0f;
        isPlayerOutside = true;
        listPosRandom = new ArrayList<BlockPos>();
        testParticles = new ArrayList<EntityRotFX>();
        matrix = new Matrix4fe();
        matrix2 = new Matrix4fe();
        vec = new Vector3f();
        vec2 = new Vector3f();
    }
}

