/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModContent;
import dynamictreesbop.blocks.BlockDynamicLeavesPalm;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.property.IExtendedBlockState;

public class TreePalm
extends TreeFamily {
    public TreePalm() {
        super(new ResourceLocation("dynamictreesbop", "palm"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.PALM);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.PALM));
        ModContent.palmLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.PALM);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesPalm(this));
    }

    public float getPrimaryThickness() {
        return 3.0f;
    }

    public float getSecondaryThickness() {
        return 3.0f;
    }

    public HashMap<BlockPos, IBlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        if (destructionData.getNumEndpoints() < 1) {
            return null;
        }
        HashMap<BlockPos, IBlockState> leaves = new HashMap<BlockPos, IBlockState>();
        BlockPos relPos = destructionData.getEndPointRelPos(0).func_177984_a();
        ILeavesProperties leavesProperties = this.getCommonSpecies().getLeavesProperties();
        leaves.put(relPos, leavesProperties.getDynamicLeavesState(4));
        leaves.put(relPos.func_177984_a(), leavesProperties.getDynamicLeavesState(3));
        for (int hydro = 1; hydro <= 2; ++hydro) {
            IExtendedBlockState extState = (IExtendedBlockState)leavesProperties.getDynamicLeavesState(hydro);
            for (CoordUtils.Surround surr : BlockDynamicLeavesPalm.hydroSurroundMap[hydro]) {
                leaves.put(relPos.func_177971_a(surr.getOpposite().getOffset()), (IBlockState)extState.withProperty(BlockDynamicLeavesPalm.CONNECTIONS[surr.ordinal()], (Object)true));
            }
        }
        return leaves;
    }

    public class SpeciesPalm
    extends Species {
        SpeciesPalm(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.palmLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 9.0f, 4, 3, 0.9f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.25f);
            this.generateSeed();
            this.addDropCreator((IDropCreator)new DropCreatorSeed(3.0f){

                public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                    if (random.nextInt(4) == 0) {
                        dropList.add(species.getSeedStack(1));
                    }
                    return dropList;
                }

                public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                    int chance = 4;
                    if (fortune > 0 && (chance -= fortune) < 3) {
                        chance = 3;
                    }
                    if (random.nextInt(chance) == 0) {
                        dropList.add(species.getSeedStack(1));
                    }
                    return dropList;
                }
            });
        }

        protected void setStandardSoils() {
            this.addAcceptableSoils(new String[]{"dirtlike", "sandlike"});
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return super.getLogsAndSticks(volume * 5.0f);
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesPalm.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.oasis.orNull(), (Biome)BOPBiomes.tropical_island.orNull()}) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = 10;
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
            probMap[originDir.ordinal()] = 0;
            return probMap;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 3);
        }

        public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean natural) {
            IBlockState trunkBlockState = world.func_180495_p(treePos);
            BlockBranch branch = TreeHelper.getBranch((IBlockState)trunkBlockState);
            NodeFindEnds endFinder = new NodeFindEnds();
            MapSignal signal = new MapSignal(new INodeInspector[]{endFinder});
            branch.analyse(trunkBlockState, world, treePos, EnumFacing.DOWN, signal);
            List endPoints = endFinder.getEnds();
            for (BlockPos endPoint : endPoints) {
                TreeHelper.ageVolume((World)world, (BlockPos)endPoint, (int)2, (int)3, (int)3, (SafeChunkBounds)SafeChunkBounds.ANY);
            }
            int radius = branch.getRadius(world.func_180495_p(treePos.func_177984_a()));
            if (radius != 0) {
                branch.setRadius(world, treePos, radius + 1, null);
            }
            return super.postGrow(world, rootPos, treePos, soilLife, natural);
        }

        public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
            for (BlockPos endPoint : endPoints) {
                TreeHelper.ageVolume((World)world, (BlockPos)endPoint, (int)1, (int)2, (int)3, (SafeChunkBounds)safeBounds);
            }
        }

        public boolean placeRootyDirtBlock(World world, BlockPos rootPos, int life) {
            if (world.func_180495_p(rootPos).func_185904_a() == Material.field_151595_p) {
                world.func_175656_a(rootPos, ModBlocks.blockRootySand.func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(life)));
            } else {
                world.func_175656_a(rootPos, this.getRootyBlock(world, rootPos).func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(life)));
            }
            return true;
        }
    }
}

