/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.proxy;

import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.models.blockmodels.ModelBlockBranchBasic;
import com.ferreusveritas.dynamictrees.models.loaders.ModelLoaderDelegated;
import dynamictreesbop.ModContent;
import dynamictreesbop.items.ItemMagicSeed;
import dynamictreesbop.items.ItemMapleSeed;
import dynamictreesbop.models.BakedModelBlockBranchBamboo;
import dynamictreesbop.models.ModelBlockBranchMangrove;
import dynamictreesbop.models.ModelBlockPalmFronds;
import dynamictreesbop.proxy.CommonProxy;
import dynamictreesbop.renderers.RenderMagicSeed;
import dynamictreesbop.renderers.RenderMapleSeed;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registerClientEventHandlers();
        this.registerEntityRenderers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderDelegated("dynamicbamboo", new ResourceLocation("dynamictrees", "block/smartmodel/branch"), (resloc, baseModelBlock) -> new ModelBlockBranchBasic((ModelBlock)baseModelBlock){

            public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
                try {
                    return new BakedModelBlockBranchBamboo(this.barkTexture, this.ringsTexture, bakedTextureGetter);
                }
                catch (Exception exception) {
                    System.err.println("BambooModel.bake() failed due to exception:" + exception);
                    return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
                }
            }
        }));
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderDelegated("dynamicpalmfronds", new ResourceLocation("dynamictreesbop", "block/dynamicpalmfronds"), (resloc, baseModelBlock) -> new ModelBlockPalmFronds((ModelBlock)baseModelBlock)));
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderDelegated("dynamicmangrove", new ResourceLocation("dynamictrees", "block/smartmodel/branch"), (resloc, baseModelBlock) -> new ModelBlockBranchMangrove((ModelBlock)baseModelBlock)));
    }

    @Override
    public void init() {
        super.init();
        this.registerColorHandlers();
    }

    public void registerColorHandlers() {
        int magenta = 0xFF00FF;
        ModelHelper.regColorHandler((Block)ModContent.rootyWater, (state, world, pos, tintIndex) -> {
            int color = 0xFFFFFF;
            if (tintIndex != 2) {
                color = Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150355_j.func_176223_P(), world, pos, tintIndex);
            }
            return color;
        });
        ModelHelper.regColorHandler((Block)ModContent.floweringOakLeaves, (IBlockColor)new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                boolean inWorld = worldIn != null && pos != null;
                Block block = state.func_177230_c();
                if (inWorld && tintIndex == 0 && TreeHelper.isLeaves((Block)block)) {
                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                }
                return 0xFFFFFF;
            }
        });
        ModelHelper.regColorHandler((Block)ModContent.palmFrondLeaves, (IBlockColor)new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                boolean inWorld = worldIn != null && pos != null;
                Block block = state.func_177230_c();
                if (inWorld && tintIndex == 0 && TreeHelper.isLeaves((Block)block)) {
                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                }
                return 0xFFFFFF;
            }
        });
        for (final BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"dynamictreesbop").values()) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    boolean inWorld = worldIn != null && pos != null;
                    IBlockState primLeaves = leaves.getProperties(state).getPrimitiveLeaves();
                    Block block = state.func_177230_c();
                    if (primLeaves.func_177230_c() instanceof BlockBOPLeaves) {
                        switch (BlockBOPLeaves.getColoringType((BOPTrees)((BOPTrees)primLeaves.func_177229_b(((BlockBOPLeaves)primLeaves.func_177230_c()).variantProperty)))) {
                            case TINTED: {
                                if (inWorld && TreeHelper.isLeaves((Block)block)) {
                                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                                }
                                return 0xFF00FF;
                            }
                            case OVERLAY: {
                                if (!inWorld || tintIndex != 0) break;
                                if (TreeHelper.isLeaves((Block)block)) {
                                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                                }
                                return 0xFF00FF;
                            }
                        }
                        return 0xFFFFFF;
                    }
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
    }

    public void registerClientEventHandlers() {
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ItemMapleSeed.EntityItemMapleSeed.class, (IRenderFactory)new RenderMapleSeed.Factory());
        RenderingRegistry.registerEntityRenderingHandler(ItemMagicSeed.EntityItemMagicSeed.class, (IRenderFactory)new RenderMagicSeed.Factory());
    }
}

