/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.multiblock;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockCuboid;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockTinker;
import slimeknights.tconstruct.smeltery.tileentity.TileTinkerTank;

public class MultiblockTinkerTank
extends MultiblockTinker {
    public MultiblockTinkerTank(TileTinkerTank tank) {
        super(tank, true, true, true);
    }

    @Override
    public boolean isValidBlock(World world, BlockPos pos) {
        if (pos.equals((Object)this.tile.func_174877_v())) {
            return true;
        }
        return TinkerSmeltery.validTinkerTankBlocks.contains((Object)world.func_180495_p(pos).func_177230_c()) && this.isValidSlave(world, pos);
    }

    @Override
    public boolean isFrameBlock(World world, BlockPos pos, MultiblockCuboid.EnumFrameType type) {
        if (pos.equals((Object)this.tile.func_174877_v())) {
            return true;
        }
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (type == MultiblockCuboid.EnumFrameType.WALL) {
            return TinkerSmeltery.validTinkerTankBlocks.contains((Object)block);
        }
        if (type == MultiblockCuboid.EnumFrameType.CEILING) {
            if (block instanceof BlockSlab && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                return false;
            }
            if (block instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
                return false;
            }
            if (TinkerSmeltery.searedStairsSlabs.contains((Object)block)) {
                return true;
            }
        }
        return block == TinkerSmeltery.searedBlock || block == TinkerSmeltery.smelteryIO;
    }

    @Override
    public boolean isCeilingBlock(World world, BlockPos pos) {
        if (pos.equals((Object)this.tile.func_174877_v())) {
            return true;
        }
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockSlab && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return false;
        }
        if (block instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            return false;
        }
        return TinkerSmeltery.searedStairsSlabs.contains((Object)block) || TinkerSmeltery.validTinkerTankBlocks.contains((Object)block);
    }

    @Override
    public boolean isFloorBlock(World world, BlockPos pos) {
        return TinkerSmeltery.validTinkerTankFloorBlocks.contains((Object)world.func_180495_p(pos).func_177230_c()) && this.isValidSlave(world, pos);
    }
}

