/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.slot;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import mcmultipart.api.slot.EnumEdgeSlot;
import mcmultipart.api.slot.EnumSlotAccess;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.slot.ISlottedContainer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum SlotRegistry {
    INSTANCE;

    private final Map<EnumFacing, List<Map.Entry<IPartSlot, EnumSlotAccess>>> accessFace = new IdentityHashMap<EnumFacing, List<Map.Entry<IPartSlot, EnumSlotAccess>>>();
    private final Map<EnumEdgeSlot, Map<EnumFacing, List<Map.Entry<IPartSlot, EnumSlotAccess>>>> accessEdge = new IdentityHashMap<EnumEdgeSlot, Map<EnumFacing, List<Map.Entry<IPartSlot, EnumSlotAccess>>>>();
    private final List<Map.Entry<IPartSlot, EnumSlotAccess>> mergeAll = new ArrayList<Map.Entry<IPartSlot, EnumSlotAccess>>();
    private ForgeRegistry<IPartSlot> slotRegistry;
    private List<IPartSlot> allSlots;

    public void computeAccess() {
        List<IPartSlot> slots = this.getSlots();
        slots.forEach(s -> this.mergeAll.add(new AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>((IPartSlot)s, EnumSlotAccess.MERGE)));
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            ArrayList<AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>> accesses = new ArrayList<AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>>();
            for (IPartSlot slot : slots) {
                EnumSlotAccess access = slot.getFaceAccess(enumFacing);
                if (access == EnumSlotAccess.NONE) continue;
                accesses.add(new AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>(slot, access));
            }
            accesses.sort((a, b) -> Integer.compare(((IPartSlot)b.getKey()).getFaceAccessPriority(face), ((IPartSlot)a.getKey()).getFaceAccessPriority(face)));
            this.accessFace.put(enumFacing, Collections.unmodifiableList(accesses));
        }
        for (EnumEdgeSlot enumEdgeSlot : EnumEdgeSlot.VALUES) {
            IdentityHashMap map = new IdentityHashMap();
            for (EnumFacing face : EnumFacing.field_82609_l) {
                ArrayList<AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>> accesses = new ArrayList<AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>>();
                for (IPartSlot slot : slots) {
                    EnumSlotAccess access = slot.getEdgeAccess(enumEdgeSlot, face);
                    if (access == EnumSlotAccess.NONE) continue;
                    accesses.add(new AbstractMap.SimpleEntry<IPartSlot, EnumSlotAccess>(slot, access));
                }
                accesses.sort((a, b) -> Integer.compare(((IPartSlot)b.getKey()).getEdgeAccessPriority(enumEdgeSlot, face), ((IPartSlot)a.getKey()).getEdgeAccessPriority(enumEdgeSlot, face)));
                map.put(face, Collections.unmodifiableList(accesses));
            }
            this.accessEdge.put(enumEdgeSlot, map);
        }
    }

    public List<Map.Entry<IPartSlot, EnumSlotAccess>> getAccessPriorities(EnumFacing face) {
        return face == null ? this.mergeAll : this.accessFace.get(face);
    }

    public List<Map.Entry<IPartSlot, EnumSlotAccess>> getAccessPriorities(EnumEdgeSlot edge, EnumFacing face) {
        return face == null || edge == null ? this.mergeAll : this.accessEdge.get(edge).get(face);
    }

    public List<IPartSlot> getSlots() {
        if (this.slotRegistry == null) {
            this.slotRegistry = (ForgeRegistry)GameRegistry.findRegistry(IPartSlot.class);
        }
        if (this.allSlots == null) {
            this.allSlots = Collections.unmodifiableList(this.slotRegistry.getValues());
        }
        return this.allSlots;
    }

    public int getSlotID(IPartSlot slot) {
        if (this.slotRegistry == null) {
            this.slotRegistry = (ForgeRegistry)GameRegistry.findRegistry(IPartSlot.class);
        }
        return this.slotRegistry.getID((IForgeRegistryEntry)slot);
    }

    public IPartSlot getSlotFromID(int slot) {
        if (this.slotRegistry == null) {
            this.slotRegistry = (ForgeRegistry)GameRegistry.findRegistry(IPartSlot.class);
        }
        return (IPartSlot)this.slotRegistry.getValue(slot);
    }

    public <T, O> O viewContainer(ISlottedContainer<T> container, Function<T, O> converter, Function<List<O>, O> joiner, O startVal, boolean ignoreNull, EnumFacing face) {
        return this.viewContainer(container, converter, joiner, startVal, ignoreNull, this.getAccessPriorities(face));
    }

    public <T, O> O viewContainer(ISlottedContainer<T> container, Function<T, O> converter, Function<List<O>, O> joiner, O startVal, boolean ignoreNull, EnumEdgeSlot edge, EnumFacing face) {
        return this.viewContainer(container, converter, joiner, startVal, ignoreNull, this.getAccessPriorities(edge, face));
    }

    public <T, O> O viewContainer(ISlottedContainer<T> container, Function<T, O> converter, Function<List<O>, O> joiner, O startVal, boolean ignoreNull, List<Map.Entry<IPartSlot, EnumSlotAccess>> accessPriorities) {
        LinkedList<O> mergeList = null;
        for (Map.Entry<IPartSlot, EnumSlotAccess> slot : accessPriorities) {
            Optional<T> element = container.get(slot.getKey());
            if (!element.isPresent()) continue;
            O value = converter.apply(element.get());
            if (ignoreNull && value == null) continue;
            switch (slot.getValue()) {
                case NONE: {
                    break;
                }
                case NON_NULL: {
                    if (value == null) break;
                    if (mergeList != null) {
                        mergeList.add(value);
                        return joiner.apply(mergeList);
                    }
                    if (startVal != null || !ignoreNull) {
                        return joiner.apply(Arrays.asList(startVal, value));
                    }
                    return value;
                }
                case MERGE: {
                    if (value == null) break;
                    if (mergeList == null) {
                        mergeList = new LinkedList<O>();
                        if (startVal != null || !ignoreNull) {
                            mergeList.add(startVal);
                        }
                    }
                    mergeList.add(value);
                    break;
                }
                case OVERRIDE: {
                    if (mergeList != null) {
                        mergeList.add(value);
                        return joiner.apply(mergeList);
                    }
                    if (startVal != null || !ignoreNull) {
                        return joiner.apply(Arrays.asList(startVal, value));
                    }
                    return value;
                }
            }
        }
        return (O)(mergeList != null && !mergeList.isEmpty() ? (mergeList.size() == 1 ? mergeList.get(0) : joiner.apply(mergeList)) : startVal);
    }
}

