/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.util;

import jaredbgreat.climaticbiome.util.SpatialHash;
import jaredbgreat.climaticbiome.util.Vec3D;

public class VolumnNoiseMap {
    int xOff;
    int yOff;
    int zOff;
    int sizex;
    int sizey;
    int sizez;
    int fsizex;
    int fsizey;
    int fsizez;
    int scalex;
    int scaley;
    int scalez;
    int interval;
    int cutoff;
    int currentInterval1;
    int currentInterval2;
    float[][][] field;
    float scale;
    float divisor;

    public VolumnNoiseMap(int sizex, int sizey, int sizez, int scalex, int scaley, int scalez, int interval, int cutoff, float scale) {
        this.sizex = sizex;
        this.sizey = sizey;
        this.sizez = sizez;
        this.fsizex = sizex + 1;
        this.fsizey = sizey + 1;
        this.fsizez = sizez + 1;
        this.scalex = scalex;
        this.scaley = scaley;
        this.scalez = scalez;
        this.interval = interval;
        this.cutoff = cutoff;
        this.scale = scale;
    }

    public VolumnNoiseMap(int sizex, int sizey, int sizez, int scalex, int scaley, int scalez, int interval, float scale) {
        this.sizex = sizex;
        this.sizey = sizey;
        this.sizez = sizez;
        this.fsizex = sizex + 1;
        this.fsizey = sizey + 1;
        this.fsizez = sizez + 1;
        this.scalex = scalex;
        this.scaley = scaley;
        this.scalez = scalez;
        this.interval = interval;
        this.cutoff = 2;
        this.scale = scale;
    }

    public VolumnNoiseMap process(SpatialHash rand, int x, int z) {
        this.xOff = x;
        this.zOff = z;
        this.field = new float[this.fsizex][this.fsizey][this.fsizez];
        this.currentInterval1 = this.interval;
        this.divisor = 1.0f;
        while (this.currentInterval1 > this.cutoff) {
            this.currentInterval2 = this.currentInterval1 + 1;
            this.processOne(rand);
            this.divisor *= 2.0f;
            this.currentInterval1 /= 2;
        }
        return this;
    }

    private void processOne(SpatialHash rand) {
        int k;
        int j;
        int i;
        int nodesX = this.fsizex / this.currentInterval2 + 1;
        int nodesY = this.fsizey / this.currentInterval2 + 1;
        int nodesZ = this.fsizez / this.currentInterval2 + 1;
        Vec3D[][][] nodes = new Vec3D[nodesX][nodesY][nodesZ];
        for (i = 0; i < nodesX; ++i) {
            for (j = 0; j < nodesY; ++j) {
                for (k = 0; k < nodesZ; ++k) {
                    nodes[i][j][k] = new Vec3D(rand, i + this.xOff / this.currentInterval1, j + this.yOff / this.currentInterval1, k + this.zOff / this.currentInterval1, (int)this.divisor);
                }
            }
        }
        for (i = 0; i < this.fsizex; ++i) {
            for (j = 0; j < this.fsizey; ++j) {
                for (k = 0; k < this.fsizez; ++k) {
                    float[] fArray = this.field[i][j];
                    int n = k;
                    fArray[n] = fArray[n] + this.processPoint(nodes, i, j, k) * this.scale;
                }
            }
        }
    }

    public float processPoint(Vec3D[][][] nodes, int x, int y, int z) {
        float out = 0.0f;
        float ci = this.currentInterval2;
        float dx = this.fullFade(x % this.currentInterval1);
        float dy = this.fullFade(y % this.currentInterval1);
        float dz = this.fullFade(z % this.currentInterval1);
        int px = x / this.currentInterval1;
        int py = y / this.currentInterval1;
        int pz = z / this.currentInterval1;
        out += this.calcLoc(nodes[px][py][pz], new Vec3D(dx, dy, dz), ci);
        out += this.calcLoc(nodes[px + 1][py][pz], new Vec3D(ci - dx, dy, dz), ci);
        out += this.calcLoc(nodes[px + 1][py + 1][pz], new Vec3D(ci - dx, ci - dy, dz), ci);
        out += this.calcLoc(nodes[px][py + 1][pz], new Vec3D(dx, ci - dy, dz), ci);
        out += this.calcLoc(nodes[px][py][pz + 1], new Vec3D(dx, dy, ci - dz), ci);
        out += this.calcLoc(nodes[px + 1][py][pz + 1], new Vec3D(ci - dx, dy, ci - dz), ci);
        out += this.calcLoc(nodes[px + 1][py + 1][pz + 1], new Vec3D(ci - dx, ci - dy, ci - dz), ci);
        out += this.calcLoc(nodes[px][py + 1][pz + 1], new Vec3D(dx, ci - dy, ci - dz), ci);
        out /= (float)this.interval;
        if ((double)(out = (float)((double)out / 2.0)) >= 0.99 || (double)out <= -0.99) {
            System.out.println(out);
            out = 0.0f;
        }
        return out;
    }

    public float get(int x, int y, int z) {
        float out = 0.0f;
        float cix = this.scalex;
        float ciy = this.scaley;
        float ciz = this.scalez;
        float dx = this.fullFade(x % this.scalex);
        float dy = this.fullFade(y % this.scaley);
        float dz = this.fullFade(z % this.scalez);
        int px = x / this.scalex;
        int py = y / this.scaley;
        int pz = z / this.scalez;
        out += this.calcOut(this.field[px][py][pz], dx / cix, dy / ciy, dz / ciz);
        out += this.calcOut(this.field[px + 1][py][pz], (cix - dx) / cix, dy / ciy, dz / ciz);
        out += this.calcOut(this.field[px + 1][py + 1][pz], (cix - dx) / cix, (ciy - dy) / ciy, dz / ciz);
        out += this.calcOut(this.field[px][py + 1][pz], dx / cix, (ciy - dy) / ciy, dz / ciz);
        out += this.calcOut(this.field[px][py][pz], dx / cix, dy / ciy, (ciz - dz) / ciz);
        out += this.calcOut(this.field[px + 1][py][pz], (cix - dx) / cix, dy / ciy, (ciz - dz) / ciz);
        out += this.calcOut(this.field[px + 1][py + 1][pz], (cix - dx) / cix, (ciy - dy) / ciy, (ciz - dz) / ciz);
        out += this.calcOut(this.field[px][py + 1][pz], dx / cix, (ciy - dy) / ciy, (ciz - dz) / ciz);
        out /= (float)this.interval;
        if ((double)(out = (float)((double)out / 2.0)) >= 0.99 || (double)out <= -0.99) {
            System.out.println(out);
            out = 0.0f;
        }
        return out;
    }

    private float calcLoc(Vec3D from, Vec3D at, float ci) {
        double dx = at.x / (double)ci;
        double dy = at.y / (double)ci;
        double dz = at.z / (double)ci;
        double l = 1.0 - (dx * dx + dy * dy + dz * dz);
        if (l > 0.0) {
            return (float)(Vec3D.dot(from, at) * l);
        }
        return 0.0f;
    }

    private float calcOut(float from, float dx, float dy, float dz) {
        float l = 1.0f - (dx * dx + dy * dy + dz * dz);
        if (l > 0.0f) {
            return from * l;
        }
        return 0.0f;
    }

    private float fade(float in) {
        return in * in * in * (in * (in * 6.0f - 15.0f) + 10.0f);
    }

    private float fullFade(float in) {
        return this.fade(in / (float)this.currentInterval1) * (float)this.currentInterval1;
    }
}

