/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.util;

import jaredbgreat.climaticbiome.util.SpatialHash;
import jaredbgreat.climaticbiome.util.Vec3D;

public class NoiseMap3D {
    int size;
    int interval;
    int cutoff;
    int currentInterval;
    int regx;
    int regy;
    int regz;
    double[][][] field;
    double scale;
    double divisor;
    SpatialHash random;

    public NoiseMap3D(SpatialHash random, int size, int interval, int cutoff, double scale, int regx, int regy, int regz) {
        this.size = size;
        this.interval = interval;
        this.cutoff = cutoff;
        this.scale = scale;
        this.regx = regx;
        this.regy = regy;
        this.size = size;
        this.random = random;
    }

    public NoiseMap3D(SpatialHash random, int size, int interval, double scale, int regx, int regy, int regz) {
        this.size = size;
        this.interval = interval;
        this.cutoff = 2;
        this.scale = scale;
        this.regx = regx;
        this.regy = regy;
        this.size = size;
        this.random = random;
    }

    public double[][][] process(int startz) {
        this.field = new double[this.size][this.size][this.size];
        this.currentInterval = this.interval;
        this.divisor = 1.0;
        while (this.currentInterval > this.cutoff) {
            this.processOne(startz);
            this.divisor *= 2.0;
            this.currentInterval /= 2;
            startz += 2;
        }
        return this.field;
    }

    private void processOne(int startz) {
        int k;
        int j;
        int i;
        int nodesX = this.size / this.currentInterval + 1;
        int nodesY = this.size / this.currentInterval + 1;
        int nodesZ = this.size / this.currentInterval + 1;
        Vec3D[][][] nodes = new Vec3D[nodesX][nodesY][nodesZ];
        for (i = 0; i < nodesX; ++i) {
            for (j = 0; j < nodesY; ++j) {
                for (k = 0; k < nodesZ; ++k) {
                    nodes[i][j][k] = new Vec3D(this.random, this.regx * nodesX - 1 + i, this.regy * nodesY - 1 + j, this.regy * nodesY - 1 + j, startz);
                }
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                for (k = 0; k < this.size; ++k) {
                    double[] dArray = this.field[i][j];
                    int n = k;
                    dArray[n] = dArray[n] + this.processPoint(nodes, i, j, k) * this.scale;
                }
            }
        }
    }

    public double processPoint(Vec3D[][][] nodes, int x, int y, int z) {
        double out = 0.0;
        double ci = this.currentInterval;
        double dx = this.fullFade(x % this.currentInterval);
        double dy = this.fullFade(y % this.currentInterval);
        double dz = this.fullFade(y % this.currentInterval);
        int px = x / this.currentInterval;
        int py = y / this.currentInterval;
        int pz = y / this.currentInterval;
        out += this.calcLoc(nodes[px][py][pz], new Vec3D(dx, dy, dz), ci);
        out += this.calcLoc(nodes[px + 1][py][pz], new Vec3D(ci - dx, dy, dz), ci);
        out += this.calcLoc(nodes[px + 1][py + 1][pz], new Vec3D(ci - dx, ci - dy, dz), ci);
        out += this.calcLoc(nodes[px][py + 1][pz], new Vec3D(dx, ci - dy, dz), ci);
        out += this.calcLoc(nodes[px][py][pz + 1], new Vec3D(dx, dy, ci + dz), ci);
        out += this.calcLoc(nodes[px + 1][py][pz + 1], new Vec3D(ci - dx, dy, ci + dz), ci);
        out += this.calcLoc(nodes[px + 1][py + 1][pz + 1], new Vec3D(ci - dx, ci - dy, ci + dz), ci);
        out += this.calcLoc(nodes[px][py + 1][pz + 1], new Vec3D(dx, ci - dy, ci + dz), ci);
        out /= (double)this.interval;
        return out /= 2.0;
    }

    private double calcLoc(Vec3D from, Vec3D at, double ci) {
        double dx = at.x / ci;
        double dy = at.y / ci;
        double dz = at.z / ci;
        double l = 1.0 - (dx * dx + dy * dy + dy * dy);
        if (l > 0.0) {
            return Vec3D.dot(from, at) * l;
        }
        return 0.0;
    }

    private double fade(double in) {
        return in * in * in * (in * (in * 6.0 - 15.0) + 10.0);
    }

    private double fullFade(double in) {
        return this.fade(in / (double)this.currentInterval) * (double)this.currentInterval;
    }
}

