/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.util;

import jaredbgreat.climaticbiome.util.SpatialHash;
import jaredbgreat.climaticbiome.util.Vec2D;

public class HeightNoiseMap {
    int xOff;
    int zOff;
    int sizex;
    int sizez;
    int interval;
    int cutoff;
    int currentInterval;
    float[][] field;
    float scale;
    float divisor;

    public HeightNoiseMap(int sizex, int sizey, int interval, int cutoff, float scale) {
        this.sizex = sizex;
        this.sizez = sizey;
        this.interval = interval;
        this.cutoff = cutoff;
        this.scale = scale;
    }

    public HeightNoiseMap(int sizex, int sizey, int interval, float scale) {
        this.sizex = sizex;
        this.sizez = sizey;
        this.interval = interval;
        this.cutoff = 2;
        this.scale = scale;
    }

    public float[][] process(SpatialHash rand, int x, int z) {
        this.xOff = x;
        this.zOff = z;
        this.field = new float[this.sizex][this.sizez];
        this.currentInterval = this.interval;
        this.divisor = 1.0f;
        while (this.currentInterval > this.cutoff) {
            this.processOne(rand);
            this.divisor *= 2.0f;
            this.currentInterval /= 2;
        }
        return this.field;
    }

    @Deprecated
    public float[][] process(SpatialHash rand) {
        this.zOff = 0;
        int x = 0;
        this.field = new float[this.sizex][this.sizez];
        this.currentInterval = this.interval;
        this.divisor = 1.0f;
        while (this.currentInterval > 2) {
            this.processOne(rand);
            this.divisor *= 2.0f;
            this.currentInterval /= 2;
        }
        return this.field;
    }

    private void processOne(SpatialHash rand) {
        int j;
        int i;
        int nodesX = this.sizex / this.currentInterval + 1;
        int nodesY = this.sizez / this.currentInterval + 1;
        Vec2D[][] nodes = new Vec2D[nodesX][nodesY];
        for (i = 0; i < nodesX; ++i) {
            for (j = 0; j < nodesY; ++j) {
                nodes[i][j] = new Vec2D(rand, i + this.xOff / this.currentInterval, j + this.zOff / this.currentInterval, (int)this.divisor);
            }
        }
        for (i = 0; i < this.sizex; ++i) {
            for (j = 0; j < this.sizez; ++j) {
                float[] fArray = this.field[i];
                int n = j;
                fArray[n] = fArray[n] + this.processPoint(nodes, i, j) * this.scale;
            }
        }
    }

    public float processPoint(Vec2D[][] nodes, int x, int y) {
        float out = 0.0f;
        float ci = this.currentInterval;
        float dx = this.fullFade(x % this.currentInterval);
        float dy = this.fullFade(y % this.currentInterval);
        int px = x / this.currentInterval;
        int py = y / this.currentInterval;
        out += this.calcLoc(nodes[px][py], new Vec2D(dx, dy), ci);
        out += this.calcLoc(nodes[px + 1][py], new Vec2D(ci - dx, dy), ci);
        out += this.calcLoc(nodes[px + 1][py + 1], new Vec2D(ci - dx, ci - dy), ci);
        out += this.calcLoc(nodes[px][py + 1], new Vec2D(dx, ci - dy), ci);
        out /= (float)this.interval;
        if ((double)(out = (float)((double)out / 2.0)) >= 0.99 || (double)out <= -0.99) {
            System.out.println(out);
            out = 0.0f;
        }
        return out;
    }

    private float calcLoc(Vec2D from, Vec2D at, float ci) {
        double dx = at.x / (double)ci;
        double dy = at.y / (double)ci;
        double l = 1.0 - (dx * dx + dy * dy);
        if (l > 0.0) {
            return (float)(Vec2D.dot(from, at) * l);
        }
        return 0.0f;
    }

    private float fade(float in) {
        return in * in * in * (in * (in * 6.0f - 15.0f) + 10.0f);
    }

    private float fullFade(float in) {
        return this.fade(in / (float)this.currentInterval) * (float)this.currentInterval;
    }
}

