/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.gui;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

public class GuiWorldTypeButton
extends GuiButton {
    private int state;
    private ClimaticWorldSettings.ModeSetter target;
    private static final String[] texts = new String[]{"createWorld.climaticbiomesjbg.continents", "createWorld.climaticbiomesjbg.isles", "createWorld.climaticbiomesjbg.water", "createWorld.climaticbiomesjbg.sislands"};

    public GuiWorldTypeButton(int buttonId, int x, int y, int defaultState, ClimaticWorldSettings.ModeSetter target) {
        super(buttonId, x, y, 150, 20, texts[(defaultState - 1) % ConfigHandler.modes]);
        this.state = (defaultState - 1) % ConfigHandler.modes;
        this.setStateText();
        this.target = target;
    }

    private void setStateText() {
        this.field_146126_j = I18n.func_135052_a((String)texts[this.state], (Object[])new Object[0]);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean out = super.func_146116_c(mc, mouseX, mouseY);
        if (out) {
            this.state = (this.state + 1) % ConfigHandler.modes;
            this.target.set(this.state);
            this.setStateText();
        }
        return out;
    }

    public void setValue(int value, ClimaticWorldSettings settings) {
        this.state = value;
        this.setStateText();
        this.target.setTarget(settings);
    }

    public int getState() {
        return this.state + 1;
    }
}

