/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class ClimateNode
extends BasinNode {
    final double faintness;

    public ClimateNode(int x, int z, int value, double decay, int faintness) {
        super(x, z, value, decay);
        this.faintness = (double)faintness * decay;
    }

    @Override
    public double getRelativeWeakness(int range) {
        double effect = ((double)range + this.faintness) * this.decay;
        return range * range;
    }

    @Override
    public double getWeaknessAt(double atx, double aty) {
        double xdisplace = ((double)this.x - atx) * this.decay;
        double ydisplace = ((double)this.z - aty) * this.decay;
        return Math.min(xdisplace * xdisplace + ydisplace * ydisplace, 1.0) + this.faintness;
    }

    public static double summateEffect(ClimateNode[] n, ChunkTile t, double noise, double scale) {
        double effect = 0.0;
        double sum = 0.0;
        for (int i = 0; i < n.length; ++i) {
            double x = (double)t.tx * scale;
            double z = (double)t.tz * scale;
            if (n[i].x == (int)x && n[i].z == (int)z && n[i].faintness == 0.0) {
                return n[i].value;
            }
            double weakness = n[i].getWeaknessAt(x, z);
            double power = 1.0 / weakness;
            sum += power;
            effect += (double)n[i].value * power;
        }
        return Math.max(effect / sum + noise, 0.0);
    }

    @Override
    public String toString() {
        return "    [x=" + this.x + ", z=" + this.z + ", val=" + this.value + ", decay=" + this.decay + ", faint=] ";
    }
}

