/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.cache.AbstractCachable;
import jaredbgreat.climaticbiome.generation.mapgenerator.TerrainType;

public class ChunkTile
extends AbstractCachable {
    static final int size = 16;
    final int x;
    final int z;
    final int tx;
    final int tz;
    int val = 0;
    int rlBiome;
    int temp = 0;
    int wet = 0;
    int biomeSeed = 0;
    int noiseVal = 0;
    int river;
    double height;
    double centrality;
    float scale;
    boolean beach;
    TerrainType terrainType = TerrainType.VARIABLE;

    public ChunkTile(int x, int z, int xoff, int zoff) {
        super(x, z);
        this.x = x;
        this.z = z;
        this.tx = x + xoff;
        this.tz = z + zoff;
    }

    public static int getSize() {
        return 16;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getTX() {
        return this.tx;
    }

    public int getTZ() {
        return this.tz;
    }

    public int getVal() {
        return this.val;
    }

    public int getRlBiome() {
        return this.rlBiome;
    }

    public int getTemp() {
        return this.temp;
    }

    public int getWet() {
        return this.wet;
    }

    public double getHeight() {
        return this.height;
    }

    public int getBiomeSeed() {
        return this.biomeSeed;
    }

    public int getNoise() {
        return this.noiseVal;
    }

    public double getCentrality() {
        return this.centrality;
    }

    public int getCNoise() {
        return this.noiseVal + (int)(this.centrality * 10.0);
    }

    public boolean isBeach() {
        return this.beach;
    }

    public boolean isMountain() {
        return this.terrainType == TerrainType.MOUNTIANOUS;
    }

    public boolean isVanilla() {
        return this.terrainType == TerrainType.VANILLA;
    }

    public boolean isSteep() {
        return this.terrainType == TerrainType.STEEP;
    }

    public boolean isNoramlTerrain() {
        return this.terrainType == TerrainType.VARIABLE;
    }

    public boolean isAveragedTerrain() {
        return this.terrainType == TerrainType.AVERAGED;
    }

    public boolean shouldSmooth() {
        return this.terrainType.smooth;
    }

    public TerrainType getTerrainType() {
        return this.terrainType;
    }

    public boolean isRiver() {
        return this.river > 0;
    }

    public void beRiver(int id) {
        this.river = id;
    }

    public void setTerrainType(TerrainType type) {
        this.terrainType = type;
    }

    public void setMountainous() {
        if (this.terrainType == TerrainType.VARIABLE) {
            this.terrainType = TerrainType.MOUNTIANOUS;
        }
    }

    public void setVanilla() {
        if (this.terrainType == TerrainType.VARIABLE) {
            this.terrainType = TerrainType.VANILLA;
        }
    }

    public void setSteep() {
        this.terrainType = TerrainType.STEEP;
    }

    public void setPlateau() {
        this.terrainType = TerrainType.PLATEAU;
    }

    public void setSwamp() {
        this.terrainType = TerrainType.SWAMP;
    }

    public void setNormalTerrain() {
        if (this.terrainType != TerrainType.STEEP) {
            this.terrainType = TerrainType.VANILLA;
        }
    }

    public void setAveraged() {
        if (this.terrainType == TerrainType.VARIABLE) {
            this.terrainType = TerrainType.AVERAGED;
        }
    }

    public ChunkTile nextBiomeSeed() {
        this.biomeSeed ^= this.biomeSeed << 13;
        this.biomeSeed ^= this.biomeSeed >> 19;
        this.biomeSeed ^= this.biomeSeed << 7;
        this.biomeSeed &= Integer.MAX_VALUE;
        return this;
    }
}

